/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.reconfigure.screen.widget.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1144;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_7845;
import net.minecraft.class_8021;
import net.minecraft.class_9848;
import net.replaceitem.reconfigure.config.BaseSettings;
import net.replaceitem.reconfigure.config.property.PropertyImpl;
import net.replaceitem.reconfigure.screen.ConfigWidgetList;
import net.replaceitem.reconfigure.screen.widget.DynamicTextFieldWidget;
import net.replaceitem.reconfigure.screen.widget.config.PropertyConfigWidget;
import net.replaceitem.reconfigure.screen.widget.layout.FlowWidget;
import net.replaceitem.reconfigure.screen.widget.layout.SocketWidget;

public class ChipListConfigWidget
extends PropertyConfigWidget<List<String>> {
    private final DynamicTextFieldWidget textField;
    private final class_7845 grid = new class_7845();
    private final class_4185 addButton;
    private final List<Chip> chips = new ArrayList<Chip>();
    private final SocketWidget<FlowWidget> flowSocket = new SocketWidget<FlowWidget>(ChipListConfigWidget.createFlowWidget());
    private final boolean chipsEditable;

    public ChipListConfigWidget(ConfigWidgetList listWidget, PropertyImpl<List<String>> property, BaseSettings baseSettings, boolean chipsEditable) {
        super(listWidget, 0, property, baseSettings);
        this.chipsEditable = chipsEditable;
        this.grid.method_48636(3);
        this.textField = new DynamicTextFieldWidget(listWidget.getTextRenderer(), 0, 0, this.method_25368() - 6, 20, (class_2561)class_2561.method_43473());
        this.textField.method_1880(10000);
        this.grid.method_46452((class_8021)this.textField, 0, 0);
        this.addButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+").method_27694(style -> style.method_10977(class_124.field_1060)), this::addChipButtonClicked).method_46437(20, 20).method_46431();
        this.grid.method_46452((class_8021)this.addButton, 0, 1);
        this.grid.method_46453(this.flowSocket, 1, 0, 1, 2);
        this.grid.method_48206(this.children::add);
        this.loadValue(property.get());
    }

    private void addChipButtonClicked(class_4185 buttonWidget) {
        this.addChip(this.textField.method_1882());
    }

    private static FlowWidget createFlowWidget() {
        FlowWidget flowWidget = new FlowWidget(FlowWidget.DisplayAxis.HORIZONTAL);
        flowWidget.setFlowSpacing(1);
        flowWidget.setWrapSpacing(2);
        return flowWidget;
    }

    private void addChip(String value) {
        Chip chip = new Chip(this.parent.getTextRenderer(), value);
        this.chips.add(chip);
        this.children.add(chip);
        this.onValueChanged();
        this.refreshChips();
    }

    private void removeChip(Chip chip) {
        this.chips.remove((Object)chip);
        this.children.remove((Object)chip);
        this.onValueChanged();
        this.refreshChips();
    }

    private void refreshChips() {
        FlowWidget flowWidget = ChipListConfigWidget.createFlowWidget();
        this.flowSocket.setInner(flowWidget);
        for (Chip c : this.chips) {
            flowWidget.add(c);
        }
        this.refreshPosition();
    }

    @Override
    protected List<String> getSaveValue() {
        return this.chips.stream().map(class_342::method_1882).toList();
    }

    @Override
    protected void loadValue(List<String> value) {
        this.chips.forEach(this.children::remove);
        this.chips.clear();
        for (String item : value) {
            Chip chip = new Chip(this.parent.getTextRenderer(), item);
            this.chips.add(chip);
            this.children.add(chip);
        }
        this.onValueChanged();
        this.refreshChips();
    }

    @Override
    protected void positionName() {
        this.positionNameFullWidth();
    }

    @Override
    public void refreshPosition() {
        super.refreshPosition();
        int gridWidth = this.method_25368() - 6;
        this.textField.method_25358(gridWidth - this.addButton.method_25368());
        this.flowSocket.getInner().setFlowWidth(gridWidth);
        this.grid.method_48229(this.method_46426() + 3, this.method_46427() + 20 + 6);
        this.grid.method_48222();
        this.height = 23 + this.grid.method_25364() + 6;
    }

    class Chip
    extends class_342 {
        private final class_327 textRenderer;
        private static final class_2561 REMOVE_TEXT = class_2561.method_43470((String)"x").method_27694(style -> style.method_10977(class_124.field_1061));
        public static final int REMOVE_BUTTON_SIZE = 10;

        public Chip(class_327 textRenderer, String value) {
            super(textRenderer, class_3532.method_15340((int)(textRenderer.method_1727(value) + 8 + 2 + 10), (int)50, (int)250), 20, (class_2561)class_2561.method_43473());
            this.textRenderer = textRenderer;
            this.method_1880(Integer.MAX_VALUE);
            this.method_1852(value);
            this.method_1883(0, false);
            this.method_1888(ChipListConfigWidget.this.chipsEditable);
            this.method_1863(s -> ChipListConfigWidget.this.onValueChanged());
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_48579(context, mouseX, mouseY, delta);
            int n = this.method_55442() - this.field_22759 / 2;
            int n2 = this.method_46427() + this.field_22759 / 2;
            Objects.requireNonNull(this.textRenderer);
            context.method_27534(this.textRenderer, REMOVE_TEXT, n, n2 - 9 / 2, -1);
            int backgroundColor = class_9848.method_61324((int)(this.removeButtonHovered(mouseX, mouseY) ? 128 : 64), (int)255, (int)255, (int)255);
            context.method_25294(this.method_55442() - this.field_22759 / 2 - 5, this.method_46427() + this.field_22759 / 2 - 5, this.method_55442() - this.field_22759 / 2 + 5, this.method_46427() + this.field_22759 / 2 + 5, backgroundColor);
        }

        public boolean removeButtonHovered(int mouseX, int mouseY) {
            return mouseX >= this.method_55442() - this.field_22759 / 2 - 5 && mouseY >= this.method_46427() + this.field_22759 / 2 - 5 && mouseX < this.method_55442() - this.field_22759 / 2 + 5 && mouseY < this.method_46427() + this.field_22759 / 2 + 5;
        }

        public void method_25348(double mouseX, double mouseY) {
            if (this.removeButtonHovered((int)mouseX, (int)mouseY)) {
                Chip.method_62888((class_1144)class_310.method_1551().method_1483());
                ChipListConfigWidget.this.removeChip(this);
            } else {
                super.method_25348(mouseX, mouseY);
            }
        }

        public int method_1859() {
            return super.method_1859() - 10 - 2;
        }
    }
}

