/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra;

import de.feelix.sierra.compatibility.CompatibilityHandler;
import de.feelix.sierra.manager.config.PunishmentConfig;
import de.feelix.sierra.manager.config.SierraConfigEngine;
import de.feelix.sierra.manager.event.AbstractEventBus;
import de.feelix.sierra.manager.init.InitManager;
import de.feelix.sierra.manager.server.SierraServerManager;
import de.feelix.sierra.manager.storage.AddressStorage;
import de.feelix.sierra.manager.storage.SierraDataManager;
import de.feelix.sierra.utilities.message.ConfigValue;
import de.feelix.sierra.utilities.update.UpdateChecker;
import de.feelix.sierraapi.LoaderAPI;
import de.feelix.sierraapi.SierraApi;
import de.feelix.sierraapi.SierraApiAccessor;
import de.feelix.sierraapi.events.EventBus;
import de.feelix.sierraapi.server.SierraServer;
import de.feelix.sierraapi.user.UserRepository;
import lombok.Generated;
import org.bukkit.plugin.java.JavaPlugin;

public final class Sierra
extends JavaPlugin
implements SierraApi {
    private static Sierra plugin;
    public static String PREFIX;
    private SierraConfigEngine sierraConfigEngine;
    private SierraDataManager sierraDataManager;
    private PunishmentConfig punishmentConfig;
    private UpdateChecker updateChecker;
    private CompatibilityHandler compatibilityHandler = new CompatibilityHandler();
    private final EventBus eventBus = new AbstractEventBus();
    private final SierraServer sierraServer = new SierraServerManager();
    private final InitManager initManager = new InitManager();
    private AddressStorage addressStorage = new AddressStorage();

    public void onLoad() {
        plugin = this;
        this.sierraConfigEngine = new SierraConfigEngine();
        this.initManager.load();
        this.updateChecker = new UpdateChecker();
    }

    public void onEnable() {
        long startTime = System.currentTimeMillis();
        this.sierraDataManager = new SierraDataManager();
        this.setPrefix();
        this.initManager.start();
        SierraApiAccessor.setSierraApiInstance(this);
        this.getLogger().info("API is ready");
        LoaderAPI.triggerCallbacks();
        long delay = System.currentTimeMillis() - startTime;
        this.getLogger().info("Sierra is ready. (Took: " + delay + "ms)");
        this.compatibilityHandler.processDescriptors();
    }

    public void setPrefix() {
        PREFIX = new ConfigValue("layout.prefix", "&3Sierra &7>", true).colorize().message();
    }

    public void onDisable() {
        this.initManager.stop();
    }

    @Override
    public UserRepository userRepository() {
        return this.sierraDataManager;
    }

    @Override
    public EventBus eventBus() {
        return this.eventBus;
    }

    @Override
    public SierraServer server() {
        return this.sierraServer;
    }

    @Generated
    public SierraConfigEngine getSierraConfigEngine() {
        return this.sierraConfigEngine;
    }

    @Generated
    public SierraDataManager getSierraDataManager() {
        return this.sierraDataManager;
    }

    @Generated
    public PunishmentConfig getPunishmentConfig() {
        return this.punishmentConfig;
    }

    @Generated
    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    @Generated
    public CompatibilityHandler getCompatibilityHandler() {
        return this.compatibilityHandler;
    }

    @Generated
    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Generated
    public SierraServer getSierraServer() {
        return this.sierraServer;
    }

    @Generated
    public InitManager getInitManager() {
        return this.initManager;
    }

    @Generated
    public AddressStorage getAddressStorage() {
        return this.addressStorage;
    }

    @Generated
    public void setSierraConfigEngine(SierraConfigEngine sierraConfigEngine) {
        this.sierraConfigEngine = sierraConfigEngine;
    }

    @Generated
    public void setSierraDataManager(SierraDataManager sierraDataManager) {
        this.sierraDataManager = sierraDataManager;
    }

    @Generated
    public void setPunishmentConfig(PunishmentConfig punishmentConfig) {
        this.punishmentConfig = punishmentConfig;
    }

    @Generated
    public void setUpdateChecker(UpdateChecker updateChecker) {
        this.updateChecker = updateChecker;
    }

    @Generated
    public void setCompatibilityHandler(CompatibilityHandler compatibilityHandler) {
        this.compatibilityHandler = compatibilityHandler;
    }

    @Generated
    public void setAddressStorage(AddressStorage addressStorage) {
        this.addressStorage = addressStorage;
    }

    @Generated
    public static Sierra getPlugin() {
        return plugin;
    }
}

