/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.check;

import de.feelix.sierra.check.impl.book.BookValidation;
import de.feelix.sierra.check.impl.command.CommandValidation;
import de.feelix.sierra.check.impl.creative.CreativeCrasher;
import de.feelix.sierra.check.impl.frequency.FrequencyDetection;
import de.feelix.sierra.check.impl.move.MovementValidation;
import de.feelix.sierra.check.impl.post.PostCheck;
import de.feelix.sierra.check.impl.protocol.ProtocolValidation;
import de.feelix.sierra.manager.packet.IngoingProcessor;
import de.feelix.sierra.manager.packet.OutgoingProcessor;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierraapi.check.CheckRepository;
import de.feelix.sierraapi.check.impl.SierraCheck;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.event.PacketSendEvent;

public class CheckManager
implements CheckRepository {
    private final List<SierraCheck> packetChecks = new ArrayList<SierraCheck>();
    private final PlayerData playerData;

    public CheckManager(PlayerData playerData) {
        this.playerData = playerData;
        this.packetChecks.add(new FrequencyDetection(playerData));
        this.packetChecks.add(new BookValidation(playerData));
        this.packetChecks.add(new ProtocolValidation(playerData));
        this.packetChecks.add(new MovementValidation(playerData));
        this.packetChecks.add(new CreativeCrasher(playerData));
        this.packetChecks.add(new PostCheck(playerData));
        this.packetChecks.add(new CommandValidation(playerData));
    }

    public void processAvailableChecksReceive(PacketReceiveEvent event) {
        for (SierraCheck availableCheck : this.packetChecks) {
            if (!(availableCheck instanceof IngoingProcessor)) continue;
            ((IngoingProcessor)((Object)availableCheck)).handle(event, this.playerData);
        }
    }

    public void processAvailableChecksSend(PacketSendEvent event) {
        for (SierraCheck availableCheck : this.packetChecks) {
            if (!(availableCheck instanceof OutgoingProcessor)) continue;
            ((OutgoingProcessor)((Object)availableCheck)).handle(event, this.playerData);
        }
    }

    @Override
    public List<SierraCheck> availableChecks() {
        return new ArrayList<SierraCheck>(this.packetChecks);
    }

    @Generated
    public List<SierraCheck> getPacketChecks() {
        return this.packetChecks;
    }

    @Generated
    public PlayerData getPlayerData() {
        return this.playerData;
    }
}

