/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.check;

import de.feelix.sierra.Sierra;
import de.feelix.sierra.check.violation.ViolationDocument;
import de.feelix.sierra.manager.config.SierraConfigEngine;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.manager.storage.SierraDataManager;
import de.feelix.sierra.manager.storage.logger.LogTag;
import de.feelix.sierra.utilities.FormatUtils;
import de.feelix.sierra.utilities.message.ConfigValue;
import de.feelix.sierraapi.check.CheckType;
import de.feelix.sierraapi.check.SierraCheckData;
import de.feelix.sierraapi.check.impl.SierraCheck;
import de.feelix.sierraapi.events.impl.AsyncUserDetectionEvent;
import de.feelix.sierraapi.violation.MitigationStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import lombok.Generated;
import net.square.sierra.kyori.adventure.text.Component;
import net.square.sierra.kyori.adventure.text.TextComponent;
import net.square.sierra.kyori.adventure.text.event.ClickEvent;
import net.square.sierra.kyori.adventure.text.event.HoverEvent;
import net.square.sierra.packetevents.api.adventure.serializer.legacy.LegacyComponentSerializer;
import net.square.sierra.packetevents.api.event.ProtocolPacketEvent;
import net.square.sierra.packetevents.api.protocol.player.User;
import net.square.sierra.packetevents.api.util.folia.FoliaScheduler;
import org.bukkit.plugin.Plugin;

public class SierraDetection
implements SierraCheck {
    public final PlayerData playerData;
    private final CheckType rawCheckType;
    private String friendlyName;
    private long lastDetectionTime = 0L;
    private int checkId;
    private int violations = 0;

    public SierraDetection(PlayerData playerData) {
        this.playerData = playerData;
        this.rawCheckType = this.initializeCheckType();
        if (this.rawCheckType != null) {
            this.friendlyName = this.rawCheckType.getFriendlyName();
            this.checkId = this.rawCheckType.getId();
        }
    }

    private CheckType initializeCheckType() {
        if (this.getClass().isAnnotationPresent(SierraCheckData.class)) {
            SierraCheckData checkData = this.getClass().getAnnotation(SierraCheckData.class);
            return checkData.checkType();
        }
        return null;
    }

    public void dispatch(ProtocolPacketEvent event, ViolationDocument violationDocument) {
        this.playerData.cancelEvent(event);
        this.lastDetectionTime = System.currentTimeMillis();
        this.playerData.getSierraLogger().log(LogTag.DETECTION, violationDocument.toString());
        if (this.playerData.isReceivedPunishment()) {
            return;
        }
        ++this.violations;
        this.correctViolation(violationDocument);
        this.throwDetectionEvent(violationDocument);
        User user = event.getUser();
        this.logViolation(user, violationDocument);
        this.alertStaff(user, violationDocument);
        if (violationDocument.getMitigationStrategy().mitigationOrdinal() >= MitigationStrategy.KICK.mitigationOrdinal()) {
            this.handlePunishment(violationDocument);
        }
    }

    private void correctViolation(ViolationDocument violationDocument) {
        if (violationDocument.getDebugs() == null) {
            violationDocument.setDebugs(Collections.emptyList());
        }
        if (violationDocument.getDescription() == null) {
            violationDocument.setDescription("No description provided");
        }
        if (violationDocument.getMitigationStrategy() == null) {
            violationDocument.setMitigationStrategy(MitigationStrategy.MITIGATE);
        }
    }

    private void throwDetectionEvent(ViolationDocument violationDocument) {
        FoliaScheduler.getAsyncScheduler().runNow((Plugin)Sierra.getPlugin(), o -> Sierra.getPlugin().getEventBus().publish(new AsyncUserDetectionEvent(violationDocument, this.playerData, this.checkType(), this.violations)));
    }

    private void logViolation(User user, ViolationDocument violationDocument) {
        if (!Sierra.getPlugin().getSierraConfigEngine().config().getBoolean("log-violation-to-console", true) || violationDocument.getMitigationStrategy() == MitigationStrategy.MITIGATE) {
            return;
        }
        Logger logger = Sierra.getPlugin().getLogger();
        logger.info(this.createGeneralMessage(user, violationDocument.getMitigationStrategy()));
        logger.info(this.createGeneralInformation(violationDocument));
        logger.info(this.createGeneralCheck());
    }

    private String createGeneralMessage(User user, MitigationStrategy mitigationStrategy) {
        return String.format("Player %s got %s sending a protocol packet", user.getName(), mitigationStrategy.friendlyMessage());
    }

    private String createGeneralInformation(ViolationDocument violationDocument) {
        return String.format("Debug information: %s", violationDocument.getDebugs().isEmpty() ? "No debug available" : violationDocument.debugInformation());
    }

    private String createGeneralCheck() {
        return String.format("Check Information: %s/%d - VL: %d", this.friendlyName, this.checkId, this.violations);
    }

    private void alertStaff(User user, ViolationDocument violationDocument) {
        String staffAlert = this.formatStaffAlertMessage(user, violationDocument.getMitigationStrategy(), violationDocument.getDescription());
        String content = this.formatAlertContent(user, violationDocument);
        Collection<PlayerData> playerDataList = Sierra.getPlugin().getSierraDataManager().getPlayerData().values();
        playerDataList.forEach(playerData -> {
            if (this.shouldAlertPlayer((PlayerData)playerData, violationDocument.getMitigationStrategy())) {
                playerData.getUser().sendMessage((Component)((TextComponent)LegacyComponentSerializer.legacy('&').deserialize(staffAlert).clickEvent(ClickEvent.clickEvent(ClickEvent.Action.RUN_COMMAND, this.getPunishmentCommand(user.getName())))).hoverEvent(HoverEvent.showText(Component.text(content))));
            }
        });
    }

    private boolean shouldAlertPlayer(PlayerData playerData, MitigationStrategy mitigationStrategy) {
        return mitigationStrategy == MitigationStrategy.MITIGATE && playerData.getMitigationSettings().enabled() || mitigationStrategy != MitigationStrategy.MITIGATE && playerData.getAlertSettings().enabled();
    }

    private String formatStaffAlertMessage(User user, MitigationStrategy mitigationStrategy, String description) {
        return new ConfigValue("layout.detection-message.staff-alert", "{prefix} &b{username} &8\u2503 &f{mitigation} &b{checkname} &8\u2503 &3x{violations}", true).colorize().replacePrefix().replace("{username}", user.getName()).replace("{mitigation}", mitigationStrategy.friendlyMessage()).replace("{description}", description).replace("{checkname}", this.friendlyName).replace("{violations}", String.valueOf(this.violations)).message();
    }

    private String formatAlertContent(User user, ViolationDocument violationDocument) {
        return new ConfigValue("layout.detection-message.alert-content", " &7Username: &b{username}{n} &7Version: &b{clientVersion}{n} &7Brand: &b{brand}{n} &7Exist since: &b{ticksExisted}{n} &7Game mode: &b{gameMode}{n} &7Tag: &b{tags}{n} &7Description: &b{description}{n} &7Debug info: &b{debugInfo}{n}{n} {alertNote}", true).replace("{username}", user.getName()).replace("{clientVersion}", this.playerData.getUser().getClientVersion().getReleaseName().replace("V_", "").replace("_", ".")).replace("{brand}", this.playerData.brand()).replace("{ticksExisted}", this.playerData.ticksExisted() + " ticks").replace("{gameMode}", this.playerData.gameMode().name()).replace("{description}", violationDocument.getDescription()).replace("{tags}", this.friendlyName.toLowerCase()).replace("{debugInfo}", FormatUtils.shortenString(violationDocument.debugInformation())).replace("{alertNote}", this.getAlertNote()).stripped().colorize().replacePrefix().message();
    }

    private String getPunishmentCommand(String username) {
        return new ConfigValue("layout.detection-message.alert-command", "/tp {username}", true).replace("{username}", username).message();
    }

    private String getAlertNote() {
        return new ConfigValue("layout.detection-message.alert-command-note", "&fClick to teleport", true).colorize().replacePrefix().message();
    }

    private void handlePunishment(ViolationDocument violationDocument) {
        Sierra plugin = Sierra.getPlugin();
        SierraDataManager sierraDataManager = plugin.getSierraDataManager();
        sierraDataManager.addKick(this.checkType());
        sierraDataManager.createPunishmentHistory(this.playerData.username(), this.playerData.version(), violationDocument.getMitigationStrategy(), this.playerData.getPingProcessor().getPing(), FormatUtils.chainDebugs(violationDocument.getDebugs()));
        this.blockAddressIfEnabled(violationDocument);
        this.playerData.punish(violationDocument.getMitigationStrategy());
    }

    private void blockAddressIfEnabled(ViolationDocument violation) {
        boolean punishmentSetting = Sierra.getPlugin().getPunishmentConfig().isBan();
        boolean blockConnections = Sierra.getPlugin().getSierraConfigEngine().config().getBoolean("block-connections-after-ban", true);
        if (violation.getMitigationStrategy() == MitigationStrategy.BAN && punishmentSetting && blockConnections) {
            Sierra.getPlugin().getAddressStorage().addIPAddress(this.playerData.getUser().getAddress().getAddress().getHostAddress());
        }
    }

    public SierraConfigEngine configEngine() {
        return Sierra.getPlugin().getSierraConfigEngine();
    }

    @Override
    public double violations() {
        return this.violations;
    }

    @Override
    public long lastDetection() {
        return this.lastDetectionTime;
    }

    @Override
    public void setViolations(double violations) {
        this.violations = (int)violations;
    }

    @Override
    public CheckType checkType() {
        return this.rawCheckType;
    }

    @Generated
    public PlayerData getPlayerData() {
        return this.playerData;
    }

    @Generated
    public CheckType getRawCheckType() {
        return this.rawCheckType;
    }

    @Generated
    public String getFriendlyName() {
        return this.friendlyName;
    }

    @Generated
    public long getLastDetectionTime() {
        return this.lastDetectionTime;
    }

    @Generated
    public int getCheckId() {
        return this.checkId;
    }

    @Generated
    public int getViolations() {
        return this.violations;
    }
}

