/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.check.impl.book;

import de.feelix.sierra.Sierra;
import de.feelix.sierra.check.SierraDetection;
import de.feelix.sierra.check.violation.Debug;
import de.feelix.sierra.check.violation.ViolationDocument;
import de.feelix.sierra.manager.packet.IngoingProcessor;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.utilities.CastUtil;
import de.feelix.sierra.utilities.FieldReader;
import de.feelix.sierra.utilities.FormatUtils;
import de.feelix.sierra.utilities.Triple;
import de.feelix.sierraapi.annotation.Nullable;
import de.feelix.sierraapi.check.CheckType;
import de.feelix.sierraapi.check.SierraCheckData;
import de.feelix.sierraapi.violation.MitigationStrategy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.netty.buffer.ByteBufHelper;
import net.square.sierra.packetevents.api.netty.buffer.UnpooledByteBufAllocationHelper;
import net.square.sierra.packetevents.api.protocol.item.ItemStack;
import net.square.sierra.packetevents.api.protocol.item.type.ItemTypes;
import net.square.sierra.packetevents.api.protocol.nbt.NBTCompound;
import net.square.sierra.packetevents.api.protocol.nbt.NBTList;
import net.square.sierra.packetevents.api.protocol.nbt.NBTString;
import net.square.sierra.packetevents.api.protocol.packettype.PacketType;
import net.square.sierra.packetevents.api.protocol.packettype.PacketTypeCommon;
import net.square.sierra.packetevents.api.protocol.player.GameMode;
import net.square.sierra.packetevents.api.wrapper.PacketWrapper;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientClickWindow;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientCreativeInventoryAction;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientEditBook;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientPickItem;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientPlayerBlockPlacement;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientPluginMessage;

@SierraCheckData(checkType=CheckType.BOOK_VALIDATION)
public class BookValidation
extends SierraDetection
implements IngoingProcessor {
    private String lastContent = "";
    private int lastContentCount = 0;
    private static final String[] MOJANG_CRASH_TRANSLATIONS = new String[]{"translation.test.invalid", "translation.test.invalid2"};

    public BookValidation(PlayerData playerData) {
        super(playerData);
    }

    @Override
    public void handle(PacketReceiveEvent event, PlayerData data) {
        if (!this.configEngine().config().getBoolean("prevent-book-crasher", true)) {
            return;
        }
        boolean blockBooks = this.configEngine().config().getBoolean("disable-books-completely", false);
        ArrayList<String> pageList = new ArrayList<String>();
        PacketTypeCommon packetType = event.getPacketType();
        if (packetType == PacketType.Play.Client.EDIT_BOOK) {
            this.handleEditBook(event, data, blockBooks, pageList);
        } else if (packetType == PacketType.Play.Client.PLUGIN_MESSAGE) {
            this.handlePluginMessage(event, data, blockBooks, pageList);
        } else if (packetType == PacketType.Play.Client.PICK_ITEM) {
            this.handlePickItem(event, data, blockBooks, pageList);
        } else if (packetType == PacketType.Play.Client.PLAYER_BLOCK_PLACEMENT) {
            this.handleBlockPlacement(event, data, blockBooks, pageList);
        } else if (packetType == PacketType.Play.Client.CREATIVE_INVENTORY_ACTION) {
            this.handleCreativeInventoryAction(event, data, blockBooks, pageList);
        } else if (packetType == PacketType.Play.Client.CLICK_WINDOW) {
            this.handleClickWindow(event, data, blockBooks, pageList);
        }
        Triple<String, MitigationStrategy, List<Debug<?>>> invalid = this.validatePages(pageList);
        if (invalid != null) {
            this.dispatch(event, ViolationDocument.builder().description(invalid.getFirst()).mitigationStrategy(invalid.getSecond()).debugs(invalid.getThird()).build());
        }
    }

    private void handleEditBook(PacketReceiveEvent event, PlayerData data, boolean blockBooks, List<String> pageList) {
        if (blockBooks) {
            this.dispatch(event, ViolationDocument.builder().description("used book while disabled").mitigationStrategy(MitigationStrategy.BAN).debugs(Collections.emptyList()).build());
            return;
        }
        pageList.addAll(CastUtil.getSupplier(() -> new WrapperPlayClientEditBook(event), data::exceptionDisconnect).getPages());
    }

    private void handlePluginMessage(PacketReceiveEvent event, PlayerData data, boolean blockBooks, List<String> pageList) {
        WrapperPlayClientPluginMessage wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientPluginMessage(event), data::exceptionDisconnect);
        if (wrapper.getChannelName().contains("MC|BEdit") || wrapper.getChannelName().contains("MC|BSign")) {
            this.processPluginMessage(event, blockBooks, pageList, wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPluginMessage(PacketReceiveEvent event, boolean blockBooks, List<String> pageList, WrapperPlayClientPluginMessage wrapper) {
        Object buffer = null;
        try {
            buffer = UnpooledByteBufAllocationHelper.buffer();
            ByteBufHelper.writeBytes(buffer, wrapper.getData());
            PacketWrapper<?> universalWrapper = PacketWrapper.createUniversalPacketWrapper(buffer);
            try {
                ItemStack wrappedItemStack = universalWrapper.readItemStack();
                this.checkGeneral(event, blockBooks, pageList, wrappedItemStack);
            }
            catch (IndexOutOfBoundsException exception) {
                this.dispatch(event, ViolationDocument.builder().description("send invalid payload").mitigationStrategy(MitigationStrategy.KICK).debugs(Collections.singletonList(new Debug<String>("Exception", exception.getMessage()))).build());
            }
        }
        finally {
            ByteBufHelper.release(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePickItem(PacketReceiveEvent event, PlayerData data, boolean blockBooks, List<String> pageList) {
        WrapperPlayClientPickItem wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientPickItem(event), data::exceptionDisconnect);
        Object buffer = null;
        try {
            buffer = UnpooledByteBufAllocationHelper.buffer();
            ByteBufHelper.writeBytes(buffer, wrapper.getBuffer());
            PacketWrapper<?> universalWrapper = PacketWrapper.createUniversalPacketWrapper(buffer);
            ItemStack wrappedItemStack = universalWrapper.readItemStack();
            if ((wrappedItemStack.getType() == ItemTypes.WRITTEN_BOOK || wrappedItemStack.getType() == ItemTypes.WRITTEN_BOOK) && blockBooks) {
                this.dispatch(event, ViolationDocument.builder().description("used book while disabled").mitigationStrategy(MitigationStrategy.KICK).debugs(Collections.emptyList()).build());
            }
            this.checkForInvalidAuthor(event, pageList, wrappedItemStack);
        }
        finally {
            ByteBufHelper.release(buffer);
        }
    }

    private void handleBlockPlacement(PacketReceiveEvent event, PlayerData data, boolean blockBooks, List<String> pageList) {
        WrapperPlayClientPlayerBlockPlacement wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientPlayerBlockPlacement(event), data::exceptionDisconnect);
        if (wrapper.getItemStack().isPresent()) {
            ItemStack itemStack = wrapper.getItemStack().get();
            this.checkGeneral(event, blockBooks, pageList, itemStack);
        }
    }

    private void handleCreativeInventoryAction(PacketReceiveEvent event, PlayerData data, boolean blockBooks, List<String> pageList) {
        if (this.playerData != null && this.playerData.getGameMode() != GameMode.CREATIVE) {
            this.dispatch(event, ViolationDocument.builder().description("spoofed his game-mode").mitigationStrategy(MitigationStrategy.BAN).debugs(Arrays.asList(new Debug<String>("GameMode", this.playerData.getGameMode().name()), new Debug<String>("Fake", "CREATIVE"))).build());
            return;
        }
        WrapperPlayClientCreativeInventoryAction wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientCreativeInventoryAction(event), data::exceptionDisconnect);
        int slot = wrapper.getSlot();
        if ((slot >= 100 || slot < -1) && slot != -999) {
            this.dispatch(event, ViolationDocument.builder().description("clicked invalid slot").mitigationStrategy(MitigationStrategy.KICK).debugs(Arrays.asList(new Debug<Integer>("Slot", slot), new Debug<String>("Tag", "CREATIVE"))).build());
            return;
        }
        ItemStack itemStack = wrapper.getItemStack();
        this.checkGeneral(event, blockBooks, pageList, itemStack);
    }

    private void checkGeneral(PacketReceiveEvent event, boolean blockBooks, List<String> pageList, ItemStack itemStack) {
        if (this.checkForInvalidAuthor(event, blockBooks, itemStack)) {
            return;
        }
        if (this.invalidTitleOrAuthor(itemStack)) {
            this.replaceTags(itemStack);
            this.dispatch(event, ViolationDocument.builder().description("used invalid book").mitigationStrategy(MitigationStrategy.BAN).debugs(Collections.singletonList(new Debug<String>("Tag", "Author"))).build());
        }
        pageList.addAll(this.getPages(itemStack));
    }

    private boolean checkForInvalidAuthor(PacketReceiveEvent event, boolean blockBooks, ItemStack itemStack) {
        if ((itemStack.getType() == ItemTypes.WRITTEN_BOOK || itemStack.getType() == ItemTypes.WRITTEN_BOOK) && blockBooks) {
            this.dispatch(event, ViolationDocument.builder().description("used book while disabled").mitigationStrategy(MitigationStrategy.BAN).debugs(Collections.emptyList()).build());
        }
        return itemStack.getType() != ItemTypes.WRITABLE_BOOK && itemStack.getType() != ItemTypes.WRITTEN_BOOK;
    }

    private void handleClickWindow(PacketReceiveEvent event, PlayerData data, boolean blockBooks, List<String> pageList) {
        WrapperPlayClientClickWindow wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientClickWindow(event), data::exceptionDisconnect);
        if (wrapper == null) {
            return;
        }
        if (wrapper.getCarriedItemStack() != null) {
            ItemStack itemStack = wrapper.getCarriedItemStack();
            if ((itemStack.getType() == ItemTypes.WRITTEN_BOOK || itemStack.getType() == ItemTypes.WRITTEN_BOOK) && blockBooks) {
                this.dispatch(event, ViolationDocument.builder().description("used book while disabled").mitigationStrategy(MitigationStrategy.BAN).debugs(Collections.emptyList()).build());
            }
            this.checkForInvalidAuthor(event, pageList, itemStack);
        }
    }

    private void checkForInvalidAuthor(PacketReceiveEvent event, List<String> pageList, ItemStack itemStack) {
        if (itemStack.getType() != ItemTypes.WRITABLE_BOOK && itemStack.getType() != ItemTypes.WRITTEN_BOOK) {
            return;
        }
        if (this.invalidTitleOrAuthor(itemStack)) {
            this.replaceTags(itemStack);
            this.dispatch(event, ViolationDocument.builder().description("used invalid book").mitigationStrategy(MitigationStrategy.BAN).debugs(Collections.singletonList(new Debug<String>("Tag", "Author"))).build());
        }
        pageList.addAll(this.getPages(itemStack));
    }

    private void replaceTags(ItemStack carriedItemStack) {
        if (carriedItemStack != null) {
            carriedItemStack.setNBT(new NBTCompound());
        }
    }

    private Triple<String, MitigationStrategy, List<Debug<?>>> validatePages(List<String> pageList) {
        long totalBytes = 0L;
        long allowedBytes = 2560L;
        if (pageList.size() > 50) {
            return new Triple("interacted with an invalid item", MitigationStrategy.KICK, Collections.singletonList(new Debug<Integer>("Pages", pageList.size())));
        }
        for (String pageContent : pageList) {
            Triple<String, MitigationStrategy, List<Debug<?>>> duplicatedContent = this.isDuplicatedContent(pageContent);
            if (duplicatedContent != null) {
                return duplicatedContent;
            }
            String strippedContent = FormatUtils.stripColor(pageContent.replaceAll("\\+", ""));
            if (strippedContent == null || strippedContent.equals("null")) {
                return new Triple("interacted with an invalid item", MitigationStrategy.KICK, Collections.singletonList(new Debug<String>("Tag", "Color Strip")));
            }
            Triple<String, MitigationStrategy, List<Debug<?>>> invalidColor = BookValidation.isInvalidColor(strippedContent);
            if (invalidColor != null) {
                return invalidColor;
            }
            Triple<String, MitigationStrategy, List<Debug<?>>> extraFrequency = BookValidation.isExtraFrequency(pageContent);
            if (extraFrequency != null) {
                return extraFrequency;
            }
            Triple<String, MitigationStrategy, List<Debug<?>>> characterSpam = BookValidation.isCharacterSpam(pageContent);
            if (characterSpam != null) {
                return characterSpam;
            }
            Triple<String, MitigationStrategy, List<Debug<?>>> fieldIsReadable = BookValidation.checkFieldReadable(pageContent);
            if (fieldIsReadable != null) {
                return fieldIsReadable;
            }
            String noSpaces = pageContent.replace(" ", "");
            if (noSpaces.startsWith("{\"translate\"")) {
                for (String crashTranslation : MOJANG_CRASH_TRANSLATIONS) {
                    String translationJson = String.format("{\"translate\":\"%s\"}", crashTranslation);
                    if (!pageContent.equalsIgnoreCase(translationJson)) continue;
                    return new Triple("interacted with an invalid item", MitigationStrategy.KICK, Collections.singletonList(new Debug<String>("Tag", "Mojang crash translations")));
                }
                continue;
            }
            Triple<String, MitigationStrategy, List<Debug<?>>> invalidChars = BookValidation.tooManyInvalidChars(pageContent);
            if (invalidChars != null) {
                return invalidChars;
            }
            int contentLength = pageContent.getBytes(StandardCharsets.UTF_8).length;
            Triple<String, MitigationStrategy, List<Debug<?>>> invalidPageSize = BookValidation.isInvalidPageSize(contentLength);
            if (invalidPageSize != null) {
                return invalidPageSize;
            }
            totalBytes += (long)contentLength;
            int length = pageContent.length();
            int multiBytes = 0;
            if (contentLength != length) {
                for (char c : pageContent.toCharArray()) {
                    if (c <= '\u007f') continue;
                    ++multiBytes;
                }
            }
            allowedBytes += (long)(2560.0 * Math.min(1.0, Math.max(0.1, (double)length / 255.0)) * 0.98);
            if (multiBytes <= 1) continue;
            allowedBytes -= (long)multiBytes;
        }
        if (totalBytes > allowedBytes) {
            return new Triple("interacted with too large book", MitigationStrategy.KICK, Arrays.asList(new Debug<Long>("Total", totalBytes), new Debug<Long>("Max", allowedBytes)));
        }
        return null;
    }

    @Nullable
    private static Triple<String, MitigationStrategy, List<Debug<?>>> isInvalidPageSize(int contentLength) {
        if (contentLength > 1024) {
            return new Triple("interacted with an invalid item", MitigationStrategy.KICK, Collections.singletonList(new Debug<String>("Tag", "Page byte size")));
        }
        return null;
    }

    @Nullable
    private static Triple<String, MitigationStrategy, List<Debug<?>>> tooManyInvalidChars(String pageContent) {
        int oversizedChars = 0;
        for (int charIndex = 0; charIndex < pageContent.length(); ++charIndex) {
            char currentChar = pageContent.charAt(charIndex);
            if (String.valueOf(currentChar).getBytes().length <= 1 || ++oversizedChars <= 15) continue;
            return new Triple("interacted with an invalid item", MitigationStrategy.KICK, Collections.singletonList(new Debug<String>("Tag", "Big characters")));
        }
        return null;
    }

    @Nullable
    private static Triple<String, MitigationStrategy, List<Debug<?>>> checkFieldReadable(String pageContent) {
        if (FieldReader.isReadable(pageContent) && !pageContent.isEmpty() && !Sierra.getPlugin().getSierraConfigEngine().config().getBoolean("skip-book-readable-check", false)) {
            return new Triple("interacted with an invalid item", MitigationStrategy.MITIGATE, Collections.singletonList(new Debug<String>("Tag", "Not readable")));
        }
        return null;
    }

    @Nullable
    private static Triple<String, MitigationStrategy, List<Debug<?>>> isExtraFrequency(String pageContent) {
        if ((double)pageContent.split("extra").length > 8.0) {
            return new Triple("interacted with an invalid item", MitigationStrategy.KICK, Collections.singletonList(new Debug<String>("Tag", "Extra frequency")));
        }
        return null;
    }

    @Nullable
    private static Triple<String, MitigationStrategy, List<Debug<?>>> isCharacterSpam(String pageContent) {
        if (FormatUtils.detectCharacterSpam(pageContent, 10)) {
            return new Triple("interacted with a invalid item", MitigationStrategy.MITIGATE, Arrays.asList(new Debug<String>("Tag", "Character spam"), new Debug<Integer>("Max Chars", 10)));
        }
        return null;
    }

    @Nullable
    private static Triple<String, MitigationStrategy, List<Debug<?>>> isInvalidColor(String strippedContent) {
        if ((double)strippedContent.length() > 256.0) {
            return new Triple("interacted with an invalid item", MitigationStrategy.KICK, Collections.singletonList(new Debug<String>("Tag", "Color Code")));
        }
        return null;
    }

    @Nullable
    private Triple<String, MitigationStrategy, List<Debug<?>>> isDuplicatedContent(String pageContent) {
        if (pageContent.equalsIgnoreCase(this.lastContent)) {
            if (this.lastContentCount++ > 4) {
                return new Triple("interacted with an invalid item", MitigationStrategy.KICK, Arrays.asList(new Debug<String>("Tag", "Many equal pages"), new Debug<Integer>("Count", this.lastContentCount)));
            }
        } else {
            this.lastContentCount = 0;
        }
        this.lastContent = pageContent;
        return null;
    }

    private boolean invalidTitleOrAuthor(ItemStack itemStack) {
        if (itemStack.getNBT() != null) {
            String title = itemStack.getNBT().getStringTagValueOrNull("title");
            if (title != null && title.length() > 100) {
                return true;
            }
            String author = itemStack.getNBT().getStringTagValueOrNull("author");
            return author != null && author.length() > 16;
        }
        return false;
    }

    private List<String> getPages(ItemStack itemStack) {
        NBTList<NBTString> nbtList;
        ArrayList<String> pageList = new ArrayList<String>();
        if (itemStack.getNBT() != null && (nbtList = itemStack.getNBT().getStringListTagOrNull("pages")) != null) {
            for (NBTString tag : nbtList.getTags()) {
                pageList.add(tag.getValue());
            }
        }
        return pageList;
    }
}

