/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.check.impl.command;

import de.feelix.sierra.Sierra;
import de.feelix.sierra.check.SierraDetection;
import de.feelix.sierra.check.violation.Debug;
import de.feelix.sierra.check.violation.ViolationDocument;
import de.feelix.sierra.manager.packet.IngoingProcessor;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.utilities.CastUtil;
import de.feelix.sierraapi.check.CheckType;
import de.feelix.sierraapi.check.SierraCheckData;
import de.feelix.sierraapi.violation.MitigationStrategy;
import java.util.Arrays;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.protocol.packettype.PacketType;
import net.square.sierra.packetevents.api.protocol.packettype.PacketTypeCommon;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientChatCommand;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientChatMessage;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientNameItem;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientUpdateCommandBlock;

@SierraCheckData(checkType=CheckType.COMMAND_VALIDATION)
public class CommandValidation
extends SierraDetection
implements IngoingProcessor {
    private static final Pattern PLUGIN_EXCLUSION = Pattern.compile("/(\\S+:)");
    private static final Pattern EXPLOIT_PATTERN = Pattern.compile("\\$\\{.+}");
    public static final Pattern WORLDEDIT_PATTERN = Pattern.compile("for\\(.*?\\)\\{.*?}");
    private static final Pattern MVC_PATTERN = Pattern.compile("/mv \\((\\w\\?\\{\\d+})\\)%");
    private static final Pattern EXPLOIT_PATTERN2 = Pattern.compile("\\$\\{.*}");
    private double count = 0.0;
    private String lastCommand = "";
    private long sentLastMessageTwice = 0L;
    private long lastEntry = 0L;
    private int commandSpamBuffer = 0;

    public CommandValidation(PlayerData playerData) {
        super(playerData);
    }

    @Override
    public void handle(PacketReceiveEvent event, PlayerData playerData) {
        if (!this.configEngine().config().getBoolean("block-disallowed-commands", true)) {
            return;
        }
        PacketTypeCommon packetType = event.getPacketType();
        if (packetType.equals(PacketType.Play.Client.UPDATE_COMMAND_BLOCK)) {
            WrapperPlayClientUpdateCommandBlock commandBlockWrapper = CastUtil.getSupplier(() -> new WrapperPlayClientUpdateCommandBlock(event), playerData::exceptionDisconnect);
            this.checkDisallowedCommand(event, commandBlockWrapper.getCommand().toLowerCase().replaceAll("\\s+", " "));
        } else if (packetType.equals(PacketType.Play.Client.CHAT_MESSAGE)) {
            WrapperPlayClientChatMessage chatMessageWrapper = CastUtil.getSupplier(() -> new WrapperPlayClientChatMessage(event), playerData::exceptionDisconnect);
            this.handleChatMessage(event, chatMessageWrapper.getMessage().toLowerCase().replaceAll("\\s+", " "));
        } else if (packetType.equals(PacketType.Play.Client.NAME_ITEM)) {
            WrapperPlayClientNameItem nameItemWrapper = CastUtil.getSupplier(() -> new WrapperPlayClientNameItem(event), playerData::exceptionDisconnect);
            this.checkForLog4J(event, nameItemWrapper.getItemName().toLowerCase().replaceAll("\\s+", " "));
        } else if (packetType.equals(PacketType.Play.Client.CHAT_COMMAND)) {
            WrapperPlayClientChatCommand chatCommandWrapper = CastUtil.getSupplier(() -> new WrapperPlayClientChatCommand(event), playerData::exceptionDisconnect);
            this.handleChatMessage(event, chatCommandWrapper.getCommand().toLowerCase().replaceAll("\\s+", " "));
        }
    }

    private void handleChatMessage(PacketReceiveEvent event, String message) {
        if (this.isInvalidMultiverseCommand(message)) {
            this.dispatch(event, ViolationDocument.builder().description("used an forbidden command").mitigationStrategy(MitigationStrategy.MITIGATE).debugs(Collections.singletonList(new Debug<String>("Command", message))).build());
        }
        this.checkForDoubleCommands(event, message);
        this.checkDisallowedCommand(event, message);
        this.checkForLog4J(event, message);
        this.checkForPluginExploits(event, message);
    }

    private void checkForPluginExploits(PacketReceiveEvent event, String command) {
        command = command.replace("minecraft:", "").replace("/", "");
        if (System.currentTimeMillis() - this.lastEntry < 1000L) {
            ++this.commandSpamBuffer;
            if (this.commandSpamBuffer > 5) {
                this.dispatch(event, ViolationDocument.builder().description("is using commands too frequent").mitigationStrategy(this.commandSpamBuffer > 50 ? MitigationStrategy.KICK : MitigationStrategy.MITIGATE).debugs(Collections.singletonList(new Debug<Long>("Delay", System.currentTimeMillis() - this.lastEntry))).build());
            }
        } else {
            this.commandSpamBuffer = 0;
        }
        for (String placeholder : Arrays.asList("[pos]", "[time]")) {
            int count = this.countOccurrences(command, placeholder);
            if (count <= 3) continue;
            this.dispatch(event, ViolationDocument.builder().description("is using tags too frequent").mitigationStrategy(this.violations() > 100.0 ? MitigationStrategy.KICK : MitigationStrategy.MITIGATE).debugs(Collections.singletonList(new Debug<Integer>("Count", count))).build());
        }
        for (String string : command.split(" ")) {
            if (string.length() <= 80) continue;
            this.dispatch(event, ViolationDocument.builder().description("is using an invalid command").mitigationStrategy(MitigationStrategy.MITIGATE).debugs(Arrays.asList(new Debug<Integer>("Length", string.length()), new Debug<Integer>("Max", 80))).build());
        }
        this.lastEntry = System.currentTimeMillis();
    }

    private int countOccurrences(String haystack, String needle) {
        int count = 0;
        int idx = 0;
        while ((idx = haystack.indexOf(needle, idx)) != -1) {
            ++count;
            idx += needle.length();
        }
        return count;
    }

    private void checkDisallowedCommand(PacketReceiveEvent event, String commandLine) {
        for (String disallowedCommand : Sierra.getPlugin().getSierraConfigEngine().config().getStringList("disallowed-commands")) {
            if (!commandLine.contains(disallowedCommand) || !this.playerHasNoPermission()) continue;
            this.dispatch(event, ViolationDocument.builder().description("is using an invalid command").mitigationStrategy(MitigationStrategy.MITIGATE).debugs(Collections.singletonList(new Debug<String>("Command", commandLine))).build());
        }
        if (WORLDEDIT_PATTERN.matcher(commandLine).find()) {
            this.dispatch(event, ViolationDocument.builder().description("is using an invalid command").mitigationStrategy(MitigationStrategy.KICK).debugs(Collections.singletonList(new Debug<String>("Command", commandLine))).build());
        }
        if (MVC_PATTERN.matcher(commandLine).find()) {
            this.dispatch(event, ViolationDocument.builder().description("is using an invalid command").mitigationStrategy(MitigationStrategy.KICK).debugs(Collections.singletonList(new Debug<String>("Command", commandLine))).build());
        }
    }

    private void checkForLog4J(PacketReceiveEvent event, String message) {
        if (message.contains("${jndi:ldap") || message.contains("${jndi") || message.contains("ldap")) {
            this.dispatch(event, ViolationDocument.builder().description("is using an invalid command").mitigationStrategy(MitigationStrategy.KICK).debugs(Collections.singletonList(new Debug<String>("Command", message))).build());
        }
        if (EXPLOIT_PATTERN.matcher(message).matches() || EXPLOIT_PATTERN2.matcher(message).matches()) {
            this.dispatch(event, ViolationDocument.builder().description("is using an invalid command").mitigationStrategy(MitigationStrategy.KICK).debugs(Collections.singletonList(new Debug<String>("Command", message))).build());
        }
    }

    private void checkForDoubleCommands(PacketReceiveEvent event, String message) {
        for (String disallowedCommand : Sierra.getPlugin().getSierraConfigEngine().config().getStringList("disallowed-commands")) {
            String pluginCommand;
            if (message.contains(disallowedCommand) && this.playerHasNoPermission()) {
                this.dispatch(event, ViolationDocument.builder().description("is using an invalid command").mitigationStrategy(MitigationStrategy.MITIGATE).debugs(Collections.singletonList(new Debug<String>("Command", message))).build());
            }
            if (!(pluginCommand = this.replaceGroup(PLUGIN_EXCLUSION.pattern(), message)).contains(disallowedCommand) || !this.playerHasNoPermission()) continue;
            this.dispatch(event, ViolationDocument.builder().description("is using an invalid command").mitigationStrategy(MitigationStrategy.MITIGATE).debugs(Collections.singletonList(new Debug<String>("Command", pluginCommand))).build());
        }
        if (this.lastCommand.equalsIgnoreCase(message)) {
            if (System.currentTimeMillis() - this.sentLastMessageTwice < 1000L) {
                double d = this.count;
                this.count = d + 1.0;
                if (d > 5.0) {
                    this.dispatch(event, ViolationDocument.builder().description("is using commands too frequent").mitigationStrategy(MitigationStrategy.MITIGATE).debugs(Collections.singletonList(new Debug<Double>("Repeat", this.count))).build());
                }
            }
            this.sentLastMessageTwice = System.currentTimeMillis();
        } else {
            this.count = 0.0;
        }
        this.lastCommand = message;
    }

    private boolean playerHasNoPermission() {
        return !this.configEngine().config().getBoolean("enable-bypass-permission", false) || !this.playerData.hasBypassPermission();
    }

    private boolean isInvalidMultiverseCommand(String testString) {
        return testString.contains("mvh") && testString.contains(".+.+.+.+") && testString.endsWith(")%");
    }

    private String replaceGroup(String regex, String source) {
        Matcher m = Pattern.compile(regex).matcher(source);
        if (!m.find()) {
            return source;
        }
        return new StringBuilder(source).replace(m.start(1), m.end(1), "").toString();
    }
}

