/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.check.impl.creative;

import de.feelix.sierra.check.SierraDetection;
import de.feelix.sierra.check.impl.creative.ItemCheck;
import de.feelix.sierra.check.impl.creative.impl.BooksProtocol;
import de.feelix.sierra.check.impl.creative.impl.CreativeAnvil;
import de.feelix.sierra.check.impl.creative.impl.CreativeClientBookCrash;
import de.feelix.sierra.check.impl.creative.impl.CreativeMap;
import de.feelix.sierra.check.impl.creative.impl.CreativeSkull;
import de.feelix.sierra.check.impl.creative.impl.EnchantLimit;
import de.feelix.sierra.check.impl.creative.impl.FireworkSize;
import de.feelix.sierra.check.impl.creative.impl.InvalidPlainNbt;
import de.feelix.sierra.check.impl.creative.impl.PotionLimit;
import de.feelix.sierra.check.violation.Debug;
import de.feelix.sierra.check.violation.ViolationDocument;
import de.feelix.sierra.manager.packet.IngoingProcessor;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.utilities.CastUtil;
import de.feelix.sierra.utilities.Triple;
import de.feelix.sierraapi.check.CheckType;
import de.feelix.sierraapi.check.SierraCheckData;
import de.feelix.sierraapi.violation.MitigationStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.protocol.item.ItemStack;
import net.square.sierra.packetevents.api.protocol.nbt.NBTCompound;
import net.square.sierra.packetevents.api.protocol.nbt.NBTList;
import net.square.sierra.packetevents.api.protocol.packettype.PacketType;
import net.square.sierra.packetevents.api.protocol.packettype.PacketTypeCommon;
import net.square.sierra.packetevents.api.protocol.player.GameMode;
import net.square.sierra.packetevents.api.resources.ResourceLocation;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientClickWindow;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientCreativeInventoryAction;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientPlayerBlockPlacement;

@SierraCheckData(checkType=CheckType.CREATIVE)
public class CreativeCrasher
extends SierraDetection
implements IngoingProcessor {
    private static final int MAX_RECURSIONS = 30;
    private static final String ITEMS_KEY = "Items";
    private static final String TAG_KEY = "tag";
    private static final String BLOCK_ENTITY_TAG_KEY = "BlockEntityTag";
    private static final int MAX_ITEMS = 54;
    private final List<ItemCheck> checks = new ArrayList<ItemCheck>();
    private int recursionCount = 0;

    public CreativeCrasher(PlayerData playerData) {
        super(playerData);
        this.initializeChecks();
    }

    private void initializeChecks() {
        this.addCreativeChecks(new CreativeMap(), new CreativeClientBookCrash(), new PotionLimit(), new BooksProtocol(), new CreativeAnvil(), new FireworkSize(), new InvalidPlainNbt());
        if (this.configEngine().config().getInt("max-enchantment-level", 5) != -1) {
            this.addCreativeChecks(new EnchantLimit());
        }
        this.addCreativeChecks(new CreativeSkull());
    }

    @Override
    public void handle(PacketReceiveEvent event, PlayerData playerData) {
        if (!this.configEngine().config().getBoolean("prevent-creative-crasher", true) || playerData == null) {
            return;
        }
        ItemStack itemStack = this.getItemStackFromEvent(event, playerData);
        if (itemStack == null) {
            return;
        }
        NBTCompound compound = itemStack.getNBT();
        if (compound != null && compound.getTags().containsKey(BLOCK_ENTITY_TAG_KEY)) {
            this.recursionCount = 0;
            NBTCompound blockEntityTag = compound.getCompoundTagOrNull(BLOCK_ENTITY_TAG_KEY);
            this.recursion(event, playerData, itemStack, blockEntityTag);
        } else if (compound != null) {
            this.performItemChecks(event, itemStack, compound, playerData);
        }
    }

    private ItemStack getItemStackFromEvent(PacketReceiveEvent event, PlayerData playerData) {
        PacketTypeCommon packetType = event.getPacketType();
        if (packetType.equals(PacketType.Play.Client.CREATIVE_INVENTORY_ACTION)) {
            if (playerData.getGameMode() != GameMode.CREATIVE) {
                return null;
            }
            return CastUtil.getSupplier(() -> new WrapperPlayClientCreativeInventoryAction(event), playerData::exceptionDisconnect).getItemStack();
        }
        if (packetType.equals(PacketType.Play.Client.CLICK_WINDOW)) {
            WrapperPlayClientClickWindow clickWrapper = CastUtil.getSupplier(() -> new WrapperPlayClientClickWindow(event), playerData::exceptionDisconnect);
            return clickWrapper != null ? clickWrapper.getCarriedItemStack() : null;
        }
        if (packetType.equals(PacketType.Play.Client.PLAYER_BLOCK_PLACEMENT)) {
            WrapperPlayClientPlayerBlockPlacement blockPlacementWrapper = CastUtil.getSupplier(() -> new WrapperPlayClientPlayerBlockPlacement(event), playerData::exceptionDisconnect);
            return blockPlacementWrapper != null ? (ItemStack)blockPlacementWrapper.getItemStack().orElse(null) : null;
        }
        return null;
    }

    private void recursion(PacketReceiveEvent event, PlayerData data, ItemStack clickedItem, NBTCompound blockEntityTag) {
        if (this.exceededRecursionMax() || !blockEntityTag.getTags().containsKey(ITEMS_KEY)) {
            return;
        }
        NBTList<NBTCompound> items = blockEntityTag.getCompoundListTagOrNull(ITEMS_KEY);
        if (items == null) {
            return;
        }
        if (this.exceededMaxItems(items)) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.BAN).description("performed invalid item click").debugs(Arrays.asList(new Debug<Integer>(ITEMS_KEY, items.size()), new Debug<Integer>("Recursion", this.recursionCount), new Debug<ResourceLocation>("Item", clickedItem.getType().getName()))).build());
            return;
        }
        this.processItems(event, data, clickedItem, items);
    }

    private boolean exceededRecursionMax() {
        return ++this.recursionCount > 30;
    }

    private boolean exceededMaxItems(NBTList<NBTCompound> items) {
        return items.size() > 54;
    }

    private void processItems(PacketReceiveEvent event, PlayerData data, ItemStack clickedItem, NBTList<NBTCompound> items) {
        for (NBTCompound item : items.getTags()) {
            NBTCompound tag;
            if (!(item.getTags().containsKey(TAG_KEY) ? (tag = item.getCompoundTagOrNull(TAG_KEY)) == null || this.processTaggedItem(event, data, clickedItem, tag) : this.performItemChecks(event, clickedItem, item, data))) continue;
            return;
        }
    }

    private boolean processTaggedItem(PacketReceiveEvent event, PlayerData data, ItemStack clickedItem, NBTCompound tag) {
        if (this.performItemChecks(event, clickedItem, tag, data)) {
            return true;
        }
        if (tag.getTags().containsKey(BLOCK_ENTITY_TAG_KEY)) {
            NBTCompound recursionBlockEntityTag = tag.getCompoundTagOrNull(BLOCK_ENTITY_TAG_KEY);
            this.recursion(event, data, clickedItem, recursionBlockEntityTag);
        }
        return false;
    }

    private boolean performItemChecks(PacketReceiveEvent event, ItemStack item, NBTCompound tag, PlayerData data) {
        for (ItemCheck check : this.checks) {
            Triple<String, MitigationStrategy, List<Debug<?>>> crashDetails = check.handleCheck(event, item, tag, data);
            if (crashDetails == null) continue;
            List<Debug<?>> debugs = crashDetails.getThird();
            debugs.addAll(Arrays.asList(new Debug<ResourceLocation>("Item", item.getType().getName()), new Debug<Integer>("Recursion", this.recursionCount)));
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(crashDetails.getSecond()).description(crashDetails.getFirst()).debugs(debugs).build());
            return true;
        }
        return false;
    }

    private void addCreativeChecks(ItemCheck ... checks) {
        this.checks.addAll(Arrays.asList(checks));
    }
}

