/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.check.impl.creative.impl;

import de.feelix.sierra.check.impl.creative.ItemCheck;
import de.feelix.sierra.check.violation.Debug;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.manager.storage.SierraDataManager;
import de.feelix.sierra.utilities.Triple;
import de.feelix.sierraapi.violation.MitigationStrategy;
import java.util.Collections;
import java.util.List;
import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.protocol.item.ItemStack;
import net.square.sierra.packetevents.api.protocol.item.type.ItemTypes;
import net.square.sierra.packetevents.api.protocol.nbt.NBTCompound;
import net.square.sierra.packetevents.api.protocol.nbt.NBTNumber;

public class CreativeAnvil
implements ItemCheck {
    @Override
    public Triple<String, MitigationStrategy, List<Debug<?>>> handleCheck(PacketReceiveEvent event, ItemStack clickedStack, NBTCompound nbtCompound, PlayerData playerData) {
        if (!(clickedStack.getType() != ItemTypes.ANVIL || clickedStack.getLegacyData() >= 0 && clickedStack.getLegacyData() <= 2 || SierraDataManager.skipAnvilCheck)) {
            return new Triple("clicked on an invalid anvil", MitigationStrategy.BAN, Collections.singletonList(new Debug<Integer>("LegacyData", clickedStack.getLegacyData())));
        }
        if (nbtCompound.getTags().containsKey("id")) {
            String id = nbtCompound.getStringTagValueOrNull("id");
            if (id == null) {
                return null;
            }
            if (id.contains("anvil") && nbtCompound.getTags().containsKey("Damage")) {
                NBTNumber damage = nbtCompound.getNumberTagOrNull("Damage");
                if (damage == null) {
                    return null;
                }
                if (damage.getAsInt() > 3 || damage.getAsInt() < 0) {
                    return new Triple("clicked on an invalid anvil", MitigationStrategy.BAN, Collections.singletonList(new Debug<Integer>("Damage", damage.getAsInt())));
                }
            }
        }
        return null;
    }
}

