/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.check.impl.creative.impl;

import de.feelix.sierra.check.impl.creative.ItemCheck;
import de.feelix.sierra.check.violation.Debug;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.utilities.Triple;
import de.feelix.sierraapi.violation.MitigationStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.protocol.item.ItemStack;
import net.square.sierra.packetevents.api.protocol.nbt.NBTCompound;
import net.square.sierra.packetevents.api.protocol.nbt.NBTList;
import net.square.sierra.packetevents.api.protocol.nbt.NBTString;

public class CreativeClientBookCrash
implements ItemCheck {
    private static final Pattern PATTERN = Pattern.compile("\\s");

    @Override
    public Triple<String, MitigationStrategy, List<Debug<?>>> handleCheck(PacketReceiveEvent event, ItemStack clickedStack, NBTCompound nbtCompound, PlayerData playerData) {
        List<String> pages = this.getPages(nbtCompound);
        if (pages.isEmpty()) {
            return null;
        }
        for (String page : pages) {
            String withOutSpaces = PATTERN.matcher(page).replaceAll("");
            if (!withOutSpaces.toLowerCase().contains("{translate:translation.test.protocol}") && !withOutSpaces.contains("{translate:translation.test.invalid2}")) continue;
            return new Triple("interacted with an invalid translation", MitigationStrategy.KICK, Collections.emptyList());
        }
        return null;
    }

    private List<String> getPages(NBTCompound nbtCompound) {
        ArrayList<String> pageList = new ArrayList<String>();
        NBTList<NBTString> nbtList = nbtCompound.getStringListTagOrNull("pages");
        if (nbtList != null) {
            for (NBTString tag : nbtList.getTags()) {
                pageList.add(tag.getValue());
            }
        }
        return pageList;
    }
}

