/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.check.impl.creative.impl;

import de.feelix.sierra.check.impl.creative.ItemCheck;
import de.feelix.sierra.check.violation.Debug;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.utilities.Triple;
import de.feelix.sierraapi.violation.MitigationStrategy;
import java.util.Collections;
import java.util.List;
import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.protocol.item.ItemStack;
import net.square.sierra.packetevents.api.protocol.nbt.NBTByte;
import net.square.sierra.packetevents.api.protocol.nbt.NBTCompound;
import net.square.sierra.packetevents.api.protocol.nbt.NBTList;
import net.square.sierra.packetevents.api.protocol.nbt.NBTType;

public class CreativeMap
implements ItemCheck {
    @Override
    public Triple<String, MitigationStrategy, List<Debug<?>>> handleCheck(PacketReceiveEvent event, ItemStack clickedStack, NBTCompound nbtCompound, PlayerData playerData) {
        if (nbtCompound.getTags().containsKey("Decorations")) {
            NBTList<NBTCompound> decorations = nbtCompound.getCompoundListTagOrNull("Decorations");
            if (decorations == null) {
                return null;
            }
            for (int i = 0; i < decorations.size(); ++i) {
                NBTCompound decoration = decorations.getTag(i);
                if (!decoration.getTags().containsKey("type")) continue;
                NBTByte nbtByte = decoration.getTagOfTypeOrNull("type", NBTType.BYTE.getNBTClass());
                if (nbtByte == null) {
                    return new Triple("clicked on an invalid item", MitigationStrategy.BAN, Collections.singletonList(new Debug<String>("Deco Type", "null")));
                }
                if (nbtByte.getAsByte() >= 0) continue;
                return new Triple("clicked on an invalid item", MitigationStrategy.BAN, Collections.singletonList(new Debug<Byte>("Deco Byte", nbtByte.getAsByte())));
            }
        }
        return null;
    }
}

