/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.check.impl.creative.impl;

import de.feelix.sierra.check.impl.creative.ItemCheck;
import de.feelix.sierra.check.violation.Debug;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.manager.storage.SierraDataManager;
import de.feelix.sierra.utilities.Triple;
import de.feelix.sierraapi.violation.MitigationStrategy;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.square.sierra.google.gson.Gson;
import net.square.sierra.google.gson.JsonObject;
import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.protocol.item.ItemStack;
import net.square.sierra.packetevents.api.protocol.nbt.NBTCompound;
import net.square.sierra.packetevents.api.protocol.nbt.NBTList;

public class CreativeSkull
implements ItemCheck {
    @Override
    public Triple<String, MitigationStrategy, List<Debug<?>>> handleCheck(PacketReceiveEvent event, ItemStack clickedStack, NBTCompound nbtCompound, PlayerData playerData) {
        NBTCompound skullOwner;
        block20: {
            if (nbtCompound == null) {
                return null;
            }
            if (!nbtCompound.getTags().containsKey("SkullOwner")) {
                return null;
            }
            skullOwner = nbtCompound.getCompoundTagOrNull("SkullOwner");
            if (skullOwner == null) {
                return new Triple("clicked on skull with null owner", MitigationStrategy.KICK, Collections.emptyList());
            }
            if (skullOwner.getTags().containsKey("Id")) {
                try {
                    UUID uUID = UUID.fromString(Objects.requireNonNull(skullOwner.getStringTagValueOrNull("Id")));
                }
                catch (Exception e) {
                    if (SierraDataManager.skipSkullUUIDCheck) break block20;
                    return new Triple("clicked on skull with unparsable uuid", MitigationStrategy.KICK, Collections.singletonList(new Debug<String>("Exception", e.getMessage())));
                }
            }
        }
        if (skullOwner.getTags().containsKey("Properties")) {
            NBTCompound properties = skullOwner.getCompoundTagOrNull("Properties");
            if (properties == null) {
                return new Triple("clicked on skull with invalid properties", MitigationStrategy.KICK, Collections.emptyList());
            }
            NBTList<NBTCompound> textures = properties.getCompoundListTagOrNull("textures");
            if (textures == null) {
                return new Triple("clicked on skull with invalid textures", MitigationStrategy.KICK, Collections.emptyList());
            }
            for (int i = 0; i < textures.size(); ++i) {
                JsonObject jsonObject;
                String decoded;
                NBTCompound texture = textures.getTag(i);
                if (texture == null) {
                    return new Triple("clicked on skull with invalid texture tag", MitigationStrategy.KICK, Collections.emptyList());
                }
                if (!texture.getTags().containsKey("Value")) {
                    return new Triple("clicked on skull with invalid value tag", MitigationStrategy.KICK, Collections.emptyList());
                }
                String value = texture.getStringTagValueOrNull("Value");
                try {
                    decoded = new String(Base64.getDecoder().decode(value));
                }
                catch (Exception e) {
                    return new Triple("clicked on skull with invalid texture value", MitigationStrategy.KICK, Collections.singletonList(new Debug<String>("Exception", e.getMessage())));
                }
                try {
                    jsonObject = new Gson().fromJson(decoded, JsonObject.class);
                }
                catch (Exception e) {
                    return new Triple("clicked on skull with invalid undecidable object", MitigationStrategy.KICK, Collections.emptyList());
                }
                if (!jsonObject.has("textures")) {
                    return new Triple("clicked on skull with no textures field", MitigationStrategy.KICK, Collections.emptyList());
                }
                if (!(jsonObject = jsonObject.getAsJsonObject("textures")).has("SKIN")) {
                    return new Triple("clicked on skull with no skin field", MitigationStrategy.KICK, Collections.emptyList());
                }
                if (!(jsonObject = jsonObject.getAsJsonObject("SKIN")).has("url")) {
                    return new Triple("clicked on skull with no url field", MitigationStrategy.KICK, Collections.emptyList());
                }
                String url = jsonObject.get("url").getAsString();
                if (url.trim().isEmpty()) {
                    return new Triple("clicked on skull with invalid url", MitigationStrategy.KICK, Collections.emptyList());
                }
                if (url.startsWith("http://textures.minecraft.net/texture/") || url.startsWith("https://textures.minecraft.net/texture/")) continue;
                return new Triple("clicked on skull with invalid url", MitigationStrategy.KICK, Collections.singletonList(new Debug<String>("URL", url)));
            }
        }
        return null;
    }
}

