/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.check.impl.creative.impl;

import de.feelix.sierra.Sierra;
import de.feelix.sierra.check.impl.creative.ItemCheck;
import de.feelix.sierra.check.violation.Debug;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.utilities.Triple;
import de.feelix.sierraapi.violation.MitigationStrategy;
import java.util.Collections;
import java.util.List;
import net.square.sierra.packetevents.api.PacketEvents;
import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.protocol.item.ItemStack;
import net.square.sierra.packetevents.api.protocol.nbt.NBTCompound;
import net.square.sierra.packetevents.api.protocol.nbt.NBTList;
import net.square.sierra.packetevents.api.protocol.nbt.NBTNumber;
import net.square.sierra.packetevents.api.protocol.player.ClientVersion;

public class EnchantLimit
implements ItemCheck {
    private static final ClientVersion CLIENT_VERSION = PacketEvents.getAPI().getServerManager().getVersion().toClientVersion();

    @Override
    public Triple<String, MitigationStrategy, List<Debug<?>>> handleCheck(PacketReceiveEvent event, ItemStack clickedStack, NBTCompound nbtCompound, PlayerData playerData) {
        if (nbtCompound.getTags().containsKey(clickedStack.getEnchantmentsTagName(CLIENT_VERSION))) {
            NBTList<NBTCompound> enchantments = nbtCompound.getCompoundListTagOrNull(clickedStack.getEnchantmentsTagName(CLIENT_VERSION));
            if (enchantments == null) {
                return null;
            }
            for (int i = 0; i < enchantments.size(); ++i) {
                NBTCompound enchantment = enchantments.getTag(i);
                if (!enchantment.getTags().containsKey("lvl")) continue;
                NBTNumber number = enchantment.getNumberTagOrNull("lvl");
                if (number == null) {
                    return null;
                }
                if ((number.getAsInt() >= 0 || Sierra.getPlugin().getSierraConfigEngine().config().getBoolean("allow-negative-enchantments", false)) && number.getAsInt() <= Sierra.getPlugin().getSierraConfigEngine().config().getInt("max-enchantment-level", 5)) continue;
                return new Triple("interacted on an item with invalid level", MitigationStrategy.KICK, Collections.singletonList(new Debug<Integer>("Level", number.getAsInt())));
            }
        }
        return null;
    }
}

