/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.check.impl.creative.impl;

import de.feelix.sierra.check.impl.creative.ItemCheck;
import de.feelix.sierra.check.violation.Debug;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.utilities.CastUtil;
import de.feelix.sierra.utilities.Triple;
import de.feelix.sierraapi.violation.MitigationStrategy;
import java.util.Collections;
import java.util.List;
import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.protocol.item.ItemStack;
import net.square.sierra.packetevents.api.protocol.nbt.NBTCompound;
import net.square.sierra.packetevents.api.protocol.nbt.NBTList;
import net.square.sierra.packetevents.api.protocol.packettype.PacketType;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientClickWindow;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientPlayerBlockPlacement;

public class FireworkSize
implements ItemCheck {
    @Override
    public Triple<String, MitigationStrategy, List<Debug<?>>> handleCheck(PacketReceiveEvent event, ItemStack clickedStack, NBTCompound nbtCompound, PlayerData playerData) {
        if (event.getPacketType() == PacketType.Play.Client.PLAYER_BLOCK_PLACEMENT) {
            WrapperPlayClientPlayerBlockPlacement wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientPlayerBlockPlacement(event), playerData::exceptionDisconnect);
            if (wrapper.getItemStack().isPresent() && this.invalid(wrapper.getItemStack().get())) {
                return new Triple("interacted with invalid firework", MitigationStrategy.BAN, Collections.singletonList(new Debug<String>("Type", "Place")));
            }
        } else if (event.getPacketType() == PacketType.Play.Client.CLICK_WINDOW) {
            WrapperPlayClientClickWindow wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientClickWindow(event), playerData::exceptionDisconnect);
            if (wrapper.getCarriedItemStack() != null && this.invalid(wrapper.getCarriedItemStack())) {
                return new Triple("interacted with invalid firework", MitigationStrategy.BAN, Collections.singletonList(new Debug<String>("Type", "Click")));
            }
        }
        if (this.invalid(clickedStack)) {
            return new Triple("interacted with invalid firework", MitigationStrategy.BAN, Collections.emptyList());
        }
        return null;
    }

    private boolean invalid(ItemStack itemStack) {
        NBTCompound fireworkNBT;
        if (itemStack.getNBT() != null && (fireworkNBT = itemStack.getNBT().getCompoundTagOrNull("Fireworks")) != null) {
            NBTList<NBTCompound> explosionsNBT = fireworkNBT.getCompoundListTagOrNull("Explosions");
            if (explosionsNBT == null) {
                return false;
            }
            int maxExplosions = 25;
            return explosionsNBT.size() >= maxExplosions;
        }
        return false;
    }
}

