/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.check.impl.creative.impl;

import de.feelix.sierra.check.impl.creative.ItemCheck;
import de.feelix.sierra.check.violation.Debug;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.utilities.CastUtil;
import de.feelix.sierra.utilities.Triple;
import de.feelix.sierraapi.violation.MitigationStrategy;
import java.util.Collections;
import java.util.List;
import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.protocol.item.ItemStack;
import net.square.sierra.packetevents.api.protocol.nbt.NBTCompound;
import net.square.sierra.packetevents.api.protocol.nbt.NBTNumber;
import net.square.sierra.packetevents.api.protocol.packettype.PacketType;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientClickWindow;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientPlayerBlockPlacement;

public class InvalidPlainNbt
implements ItemCheck {
    private Triple<String, MitigationStrategy, List<Debug<?>>> invalidNbt(ItemStack itemStack) {
        NBTCompound tag = itemStack.getNBT();
        if (tag != null) {
            Triple<String, MitigationStrategy, List<Debug<?>>> crashDetails = this.checkForSpawner(tag);
            if (crashDetails != null) {
                return crashDetails;
            }
            return this.checkValidMap(tag);
        }
        return null;
    }

    private Triple<String, MitigationStrategy, List<Debug<?>>> checkValidMap(NBTCompound nbtTag) {
        NBTNumber range = nbtTag.getNumberTagOrNull("range");
        int maxMapRange = 15;
        if (range != null && (range.getAsInt() > maxMapRange || range.getAsInt() < 0)) {
            return new Triple("interacted with invalid map", MitigationStrategy.BAN, Collections.singletonList(new Debug<Integer>("Range", range.getAsInt())));
        }
        return null;
    }

    private Triple<String, MitigationStrategy, List<Debug<?>>> checkForSpawner(NBTCompound tag) {
        if (this.isPunishable(tag.getNumberTagOrNull("MaxNearbyEntities"), 127)) {
            return this.makePunishablePair("MaxNearbyEntities", tag.getNumberTagOrNull("MaxNearbyEntities").getAsInt());
        }
        if (this.isPunishable(tag.getNumberTagOrNull("Delay"), Short.MAX_VALUE)) {
            return this.makePunishablePair("Delay", tag.getNumberTagOrNull("Delay").getAsInt());
        }
        if (this.isPunishable(tag.getNumberTagOrNull("MinSpawnDelay"), Short.MAX_VALUE)) {
            return this.makePunishablePair("MinSpawnDelay", tag.getNumberTagOrNull("MinSpawnDelay").getAsInt());
        }
        if (this.isPunishable(tag.getNumberTagOrNull("SpawnRange"), 20)) {
            return this.makePunishablePair("SpawnRange", tag.getNumberTagOrNull("SpawnRange").getAsInt());
        }
        if (this.isPunishable(tag.getNumberTagOrNull("MaxSpawnDelay"), 1000)) {
            return this.makePunishablePair("MaxSpawnDelay", tag.getNumberTagOrNull("MaxSpawnDelay").getAsInt());
        }
        if (this.isPunishable(tag.getNumberTagOrNull("SpawnCount"), 30)) {
            return this.makePunishablePair("SpawnCount", tag.getNumberTagOrNull("SpawnCount").getAsInt());
        }
        if (this.isPunishable(tag.getNumberTagOrNull("RequiredPlayerRange"), 16)) {
            return this.makePunishablePair("RequiredPlayerRange", tag.getNumberTagOrNull("RequiredPlayerRange").getAsInt());
        }
        return null;
    }

    private boolean isPunishable(NBTNumber tag, int maxValue) {
        return tag != null && (tag.getAsInt() > maxValue || tag.getAsInt() < 0);
    }

    private Triple<String, MitigationStrategy, List<Debug<?>>> makePunishablePair(String property, int value) {
        return new Triple("interacted with an item with invalid property", MitigationStrategy.KICK, Collections.singletonList(new Debug<Integer>(property, value)));
    }

    @Override
    public Triple<String, MitigationStrategy, List<Debug<?>>> handleCheck(PacketReceiveEvent event, ItemStack clickedStack, NBTCompound nbtCompound, PlayerData playerData) {
        if (event.getPacketType() == PacketType.Play.Client.PLAYER_BLOCK_PLACEMENT) {
            WrapperPlayClientPlayerBlockPlacement wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientPlayerBlockPlacement(event), playerData::exceptionDisconnect);
            if (wrapper.getItemStack().isPresent()) {
                return this.invalidNbt(wrapper.getItemStack().get());
            }
        } else if (event.getPacketType() == PacketType.Play.Client.CLICK_WINDOW) {
            WrapperPlayClientClickWindow wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientClickWindow(event), playerData::exceptionDisconnect);
            return this.invalidNbt(wrapper.getCarriedItemStack());
        }
        return null;
    }
}

