/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.check.impl.creative.impl;

import de.feelix.sierra.check.impl.creative.ItemCheck;
import de.feelix.sierra.check.violation.Debug;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.utilities.Triple;
import de.feelix.sierraapi.violation.MitigationStrategy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.protocol.item.ItemStack;
import net.square.sierra.packetevents.api.protocol.nbt.NBTCompound;
import net.square.sierra.packetevents.api.protocol.nbt.NBTList;
import net.square.sierra.packetevents.api.protocol.nbt.NBTNumber;

public class PotionLimit
implements ItemCheck {
    @Override
    public Triple<String, MitigationStrategy, List<Debug<?>>> handleCheck(PacketReceiveEvent event, ItemStack clickedStack, NBTCompound nbtCompound, PlayerData playerData) {
        if (!nbtCompound.getTags().containsKey("CustomPotionEffects")) {
            return null;
        }
        NBTList<NBTCompound> potionEffects = nbtCompound.getCompoundListTagOrNull("CustomPotionEffects");
        if (potionEffects == null) {
            return null;
        }
        int maxPotionEffects = 5;
        if (potionEffects.size() >= maxPotionEffects) {
            return new Triple("interacted with too big potion", MitigationStrategy.KICK, Arrays.asList(new Debug<Integer>("Size", potionEffects.size()), new Debug<Integer>("Max", maxPotionEffects)));
        }
        for (int i = 0; i < potionEffects.size(); ++i) {
            NBTNumber nbtNumber;
            NBTCompound effect = potionEffects.getTag(i);
            if (effect.getTags().containsKey("Duration") && (nbtNumber = effect.getNumberTagOrNull("Duration")) != null) {
                int maxEffectDuration = 9600;
                if (nbtNumber.getAsInt() >= maxEffectDuration) {
                    return new Triple("interacted with too big potion", MitigationStrategy.KICK, Arrays.asList(new Debug<Integer>("Duration", nbtNumber.getAsInt()), new Debug<Integer>("Max", maxEffectDuration)));
                }
            }
            if (!effect.getTags().containsKey("Amplifier") || (nbtNumber = effect.getNumberTagOrNull("Amplifier")) == null) continue;
            if (nbtNumber.getAsInt() < 0) {
                return new Triple("interacted with invalid potion", MitigationStrategy.BAN, Collections.singletonList(new Debug<Integer>("Amplifier", nbtNumber.getAsInt())));
            }
            int maxPotionEffectAmplifier = 10;
            if (nbtNumber.getAsInt() <= maxPotionEffectAmplifier) continue;
            return new Triple("interacted with invalid potion", MitigationStrategy.KICK, Arrays.asList(new Debug<Integer>("Amplifier", nbtNumber.getAsInt()), new Debug<Integer>("Max", maxPotionEffectAmplifier)));
        }
        return null;
    }
}

