/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.check.impl.frequency;

import de.feelix.sierra.Sierra;
import de.feelix.sierra.check.SierraDetection;
import de.feelix.sierra.check.violation.Debug;
import de.feelix.sierra.check.violation.ViolationDocument;
import de.feelix.sierra.manager.init.impl.start.Ticker;
import de.feelix.sierra.manager.packet.IngoingProcessor;
import de.feelix.sierra.manager.packet.OutgoingProcessor;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.utilities.CastUtil;
import de.feelix.sierraapi.check.CheckType;
import de.feelix.sierraapi.check.SierraCheckData;
import de.feelix.sierraapi.violation.MitigationStrategy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.event.PacketSendEvent;
import net.square.sierra.packetevents.api.protocol.packettype.PacketType;
import net.square.sierra.packetevents.api.protocol.packettype.PacketTypeCommon;
import net.square.sierra.packetevents.api.protocol.player.ClientVersion;
import net.square.sierra.packetevents.api.protocol.player.DiggingAction;
import net.square.sierra.packetevents.api.protocol.player.GameMode;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientPlayerDigging;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientPlayerFlying;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientPluginMessage;
import net.square.sierra.packetevents.api.wrapper.play.server.WrapperPlayServerCloseWindow;
import net.square.sierra.packetevents.api.wrapper.play.server.WrapperPlayServerOpenWindow;
import org.bukkit.configuration.file.YamlConfiguration;

@SierraCheckData(checkType=CheckType.FREQUENCY)
public class FrequencyDetection
extends SierraDetection
implements IngoingProcessor,
OutgoingProcessor {
    private int lastBookEditTick = 0;
    private int lastDropItemTick = 0;
    private int lastCraftRequestTick = 0;
    private int dropCount = 0;
    private int containerId = -1;
    private long lastFlyingTime = 0L;
    private long balance = 0L;
    private static final long MAX_BAL = 0L;
    private static final long BAL_RESET = -50L;
    private static final long BAL_SUB_ON_TP = 50L;
    private final HashMap<PacketTypeCommon, Integer> packetCounts = new HashMap();

    public FrequencyDetection(PlayerData playerData) {
        super(playerData);
    }

    @Override
    public void handle(PacketReceiveEvent event, PlayerData playerData) {
        if (!this.configEngine().config().getBoolean("prevent-packet-frequency", true)) {
            return;
        }
        playerData.getTimingProcessor().getFrequencyTask().prepare();
        PacketTypeCommon packetType = event.getPacketType();
        if (!WrapperPlayClientPlayerFlying.isFlying(event.getPacketType())) {
            YamlConfiguration configuration = Sierra.getPlugin().getSierraConfigEngine().config();
            if (configuration.getStringList("excluded-packets-from-limit").contains(packetType.getName())) {
                return;
            }
            long current = System.currentTimeMillis();
            this.packetCounts.merge(packetType, 1, Integer::sum);
            int limit = this.retrieveLimitFromConfiguration(packetType);
            int packetCount = this.packetCounts.getOrDefault(packetType, 0);
            if (packetCount > limit) {
                this.dispatch(event, ViolationDocument.builder().description("is sending packets too frequent").mitigationStrategy(MitigationStrategy.KICK).debugs(Arrays.asList(new Debug<String>("Packet", packetType.getName()), new Debug<Integer>("Limit", limit), new Debug<Integer>("Count", packetCount), new Debug<Long>("Alive", playerData.getPingProcessor().getPing()), new Debug<Long>("Transaction", playerData.getTransactionProcessor().getTransactionPing()), new Debug<String>("Version", playerData.getClientVersion().getReleaseName()), new Debug<String>("Delay", System.currentTimeMillis() - current + "ms"))).build());
                return;
            }
        } else {
            this.packetCounts.clear();
        }
        if (packetType.equals(PacketType.Play.Client.EDIT_BOOK)) {
            this.handleEditBook(event);
        } else if (packetType.equals(PacketType.Play.Client.PLUGIN_MESSAGE)) {
            this.handlePluginMessage(event, playerData);
        } else if (packetType.equals(PacketType.Play.Client.CRAFT_RECIPE_REQUEST)) {
            this.handleCraftRecipeRequest(event);
        } else if (packetType.equals(PacketType.Play.Client.PLAYER_DIGGING)) {
            this.handlePlayerDigging(event, playerData);
        } else if (WrapperPlayClientPlayerFlying.isFlying(event.getPacketType())) {
            this.handleFlyingDelay(event, playerData);
        }
        playerData.getTimingProcessor().getFrequencyTask().end();
    }

    private void handleFlyingDelay(PacketReceiveEvent event, PlayerData data) {
        boolean passedThreshold;
        if (!this.configEngine().config().getBoolean("prevent-timer-cheats", true)) {
            return;
        }
        if (!event.getUser().getClientVersion().isOlderThan(ClientVersion.V_1_9)) {
            return;
        }
        long timeMillis = System.currentTimeMillis();
        boolean hasTeleported = timeMillis - this.playerData.getTeleportProcessor().getLastTeleportTime() < 1000L;
        boolean bl = passedThreshold = timeMillis - data.getJoinTime() > 1000L && !hasTeleported;
        if (this.lastFlyingTime != 0L && passedThreshold) {
            long now = System.currentTimeMillis();
            this.balance += 50L;
            this.balance -= now - this.lastFlyingTime;
            if (this.balance > 0L) {
                this.dispatch(event, ViolationDocument.builder().description("is moving too frequent").mitigationStrategy(this.violations() > 75.0 ? MitigationStrategy.KICK : MitigationStrategy.MITIGATE).debugs(Arrays.asList(new Debug<Long>("Balance", this.balance), new Debug<String>("Version", this.playerData.getClientVersion().getReleaseName()), new Debug<Long>("Ping", this.playerData.getPingProcessor().getPing()), new Debug<Long>("Transaction", this.playerData.getTransactionProcessor().getTransactionPing()))).build());
                this.balance = -50L;
            }
        }
        this.lastFlyingTime = timeMillis;
    }

    private int retrieveLimitFromConfiguration(PacketTypeCommon packetType) {
        int limit = this.configEngine().config().getInt("generic-packet-frequency-default", 50);
        for (String string : this.configEngine().config().getStringList("generic-packet-frequency-limit")) {
            String[] parts = string.split(":");
            if (!parts[0].equals(packetType.getName())) continue;
            limit = Integer.parseInt(parts[1]);
            break;
        }
        return limit;
    }

    private void handleEditBook(PacketReceiveEvent event) {
        if (this.isSpamming(this.lastBookEditTick)) {
            this.dispatch(event, ViolationDocument.builder().description("is editing books too frequent").mitigationStrategy(MitigationStrategy.KICK).debugs(Collections.singletonList(new Debug<String>("Tag", "BookEdit"))).build());
        }
    }

    private void handlePluginMessage(PacketReceiveEvent event, PlayerData playerData) {
        WrapperPlayClientPluginMessage wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientPluginMessage(event), playerData::exceptionDisconnect);
        String channelName = wrapper.getChannelName();
        if ((channelName.contains("MC|BEdit") || channelName.contains("MC|BSign")) && this.isSpamming(this.lastBookEditTick)) {
            this.dispatch(event, ViolationDocument.builder().description("is sending payloads too frequent").mitigationStrategy(MitigationStrategy.KICK).debugs(Collections.singletonList(new Debug<String>("Tag", "Payload"))).build());
        }
    }

    private void handleCraftRecipeRequest(PacketReceiveEvent event) {
        int currentTick = Ticker.getInstance().getCurrentTick();
        if (this.lastCraftRequestTick + 10 > currentTick) {
            this.dispatch(event, ViolationDocument.builder().description("is requesting recipes too frequent").mitigationStrategy(MitigationStrategy.MITIGATE).debugs(Collections.singletonList(new Debug<String>("Tag", "RecipeRequest"))).build());
            event.getUser().sendPacket(new WrapperPlayServerCloseWindow(this.containerId));
        } else {
            this.lastCraftRequestTick = currentTick;
        }
    }

    private void handlePlayerDigging(PacketReceiveEvent event, PlayerData playerData) {
        WrapperPlayClientPlayerDigging wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientPlayerDigging(event), playerData::exceptionDisconnect);
        if (wrapper.getAction() == DiggingAction.DROP_ITEM) {
            int currentTick = Ticker.getInstance().getCurrentTick();
            if (playerData.getGameMode() != GameMode.SPECTATOR) {
                if (this.lastDropItemTick != currentTick) {
                    this.dropCount = 0;
                    this.lastDropItemTick = currentTick;
                } else {
                    ++this.dropCount;
                    if (this.dropCount >= 20) {
                        this.dispatch(event, ViolationDocument.builder().description("is digging too frequent").mitigationStrategy(MitigationStrategy.KICK).debugs(Collections.singletonList(new Debug<String>("Tag", "Digging"))).build());
                    }
                }
            }
        }
    }

    private boolean isSpamming(int lastActionTick) {
        boolean isSpamming;
        int currentTick = Ticker.getInstance().getCurrentTick();
        boolean bl = isSpamming = lastActionTick + 20 > currentTick;
        if (!isSpamming) {
            this.lastBookEditTick = currentTick;
        }
        return isSpamming;
    }

    @Override
    public void handle(PacketSendEvent event, PlayerData playerData) {
        if (event.getPacketType() == PacketType.Play.Server.PLAYER_POSITION_AND_LOOK || event.getPacketType() == PacketType.Play.Server.ENTITY_VELOCITY) {
            this.balance -= 50L;
        } else if (event.getPacketType() == PacketType.Play.Server.OPEN_WINDOW) {
            WrapperPlayServerOpenWindow window = CastUtil.getSupplier(() -> new WrapperPlayServerOpenWindow(event), playerData::exceptionDisconnect);
            this.containerId = window.getContainerId();
        }
    }
}

