/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.check.impl.move;

import de.feelix.sierra.check.SierraDetection;
import de.feelix.sierra.check.violation.Debug;
import de.feelix.sierra.check.violation.ViolationDocument;
import de.feelix.sierra.manager.packet.IngoingProcessor;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.manager.storage.SierraDataManager;
import de.feelix.sierra.utilities.CastUtil;
import de.feelix.sierra.utilities.FormatUtils;
import de.feelix.sierraapi.check.CheckType;
import de.feelix.sierraapi.check.SierraCheckData;
import de.feelix.sierraapi.violation.MitigationStrategy;
import java.util.Arrays;
import java.util.Collections;
import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.protocol.packettype.PacketType;
import net.square.sierra.packetevents.api.protocol.packettype.PacketTypeCommon;
import net.square.sierra.packetevents.api.protocol.player.GameMode;
import net.square.sierra.packetevents.api.protocol.world.Location;
import net.square.sierra.packetevents.api.util.Vector3d;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientPlayerFlying;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientVehicleMove;

@SierraCheckData(checkType=CheckType.MOVEMENT_VALIDATION)
public class MovementValidation
extends SierraDetection
implements IngoingProcessor {
    private double lastChunkId = -1.0;
    private long lastTick = -1L;
    private int buffer = 0;
    private Location lastLocation;
    private int deltaBuffer = 0;
    private static final double HARD_CODED_BORDER = 2.9999999E7;
    private static final double SPECIAL_VALUE = 9.223372E18;
    long timerBalanceRealTime = 0L;
    long knownPlayerClockTime = (long)((double)System.nanoTime() - 6.0E10);
    long lastMovementPlayerClock = (long)((double)System.nanoTime() - 6.0E10);
    long clockDrift = 120000000L;
    long limitAbuseOverPing = 1000L;
    boolean hasGottenMovementAfterTransaction = false;

    public MovementValidation(PlayerData playerData) {
        super(playerData);
    }

    @Override
    public void handle(PacketReceiveEvent event, PlayerData data) {
        if (!this.configEngine().config().getBoolean("prevent-protocol-move", true)) {
            return;
        }
        data.getTimingProcessor().getMovementTask().prepare();
        this.handleLatencyAbuse(event, data);
        if (WrapperPlayClientPlayerFlying.isFlying(event.getPacketType())) {
            this.handleFlyingPacket(event, data);
        } else if (event.getPacketType() == PacketType.Play.Client.VEHICLE_MOVE) {
            this.handleVehicleMove(event, data);
        }
        data.getTimingProcessor().getMovementTask().end();
    }

    private void handleFlyingPacket(PacketReceiveEvent event, PlayerData playerData) {
        WrapperPlayClientPlayerFlying wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientPlayerFlying(event), playerData::exceptionDisconnect);
        if (wrapper.hasRotationChanged()) {
            this.checkInvalidRotation(wrapper, event);
        }
        if (!wrapper.hasPositionChanged()) {
            return;
        }
        Location location = wrapper.getLocation();
        playerData.setLastLocation(location);
        Vector3d position = location.getPosition();
        double chunkId = this.computeChunkId(position);
        if (this.lastLocation != null) {
            this.checkDelta(position, event);
        }
        this.handleChunkTravel(chunkId, event);
        this.lastChunkId = chunkId;
        this.checkForBorder(position, event);
        this.checkValue(event, location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        this.lastLocation = location;
    }

    private void handleLatencyAbuse(PacketReceiveEvent event, PlayerData data) {
        if (!this.configEngine().config().getBoolean("prevent-timer-cheats", true)) {
            return;
        }
        if (this.hasGottenMovementAfterTransaction && this.checkForTransaction(event.getPacketType())) {
            this.knownPlayerClockTime = this.lastMovementPlayerClock;
            this.lastMovementPlayerClock = data.getTransactionProcessor().getPlayerClockAtLeast();
            this.hasGottenMovementAfterTransaction = false;
        }
        if (!this.shouldCountPacketForTimer(event.getPacketType())) {
            return;
        }
        this.hasGottenMovementAfterTransaction = true;
        this.timerBalanceRealTime += 50000000L;
        this.doCheck(event);
    }

    public void doCheck(PacketReceiveEvent event) {
        boolean failsAdjusted;
        double transactionPing = this.playerData.getTransactionProcessor().getTransactionPing();
        boolean needsAdjustment = this.limitAbuseOverPing != -1L && transactionPing >= (double)this.limitAbuseOverPing;
        boolean wouldFailNormal = this.timerBalanceRealTime > System.nanoTime();
        boolean bl = failsAdjusted = needsAdjustment && (double)this.timerBalanceRealTime + (transactionPing * 1000000.0 - (double)this.clockDrift - 5.0E7) > (double)System.nanoTime();
        if (wouldFailNormal || failsAdjusted) {
            if (wouldFailNormal) {
                long delay = System.nanoTime() - this.timerBalanceRealTime;
                double calculated = FormatUtils.calculateResult(delay);
                this.dispatch(event, ViolationDocument.builder().description("is moving invalid").mitigationStrategy(this.violations() > 45.0 ? MitigationStrategy.KICK : MitigationStrategy.MITIGATE).debugs(Collections.singletonList(new Debug<String>("Ticks", String.format("%.5f ticks ahead", Math.abs(calculated))))).build());
            }
            this.timerBalanceRealTime -= 50000000L;
        }
        this.timerBalanceRealTime = Math.max(this.timerBalanceRealTime, this.lastMovementPlayerClock - this.clockDrift);
    }

    public boolean checkForTransaction(PacketTypeCommon packetType) {
        return packetType == PacketType.Play.Client.PONG || packetType == PacketType.Play.Client.WINDOW_CONFIRMATION;
    }

    public boolean shouldCountPacketForTimer(PacketTypeCommon packetType) {
        return WrapperPlayClientPlayerFlying.isFlying(packetType);
    }

    private void handleVehicleMove(PacketReceiveEvent event, PlayerData data) {
        WrapperPlayClientVehicleMove wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientVehicleMove(event), data::exceptionDisconnect);
        Vector3d location = wrapper.getPosition();
        this.checkValue(event, location.getX(), location.getY(), location.getZ(), wrapper.getYaw(), wrapper.getPitch());
    }

    private void checkValue(PacketReceiveEvent event, double x, double y, double z, float yaw, float pitch) {
        Location position;
        if (this.invalidValue(x, y, z)) {
            this.dispatch(event, ViolationDocument.builder().description("is moving invalid").mitigationStrategy(MitigationStrategy.KICK).debugs(Arrays.asList(new Debug<Double>("X", x), new Debug<Double>("Y", y), new Debug<Double>("Z", z), new Debug<String>("Tag", "Extreme Double"))).build());
        }
        if (this.isInvalidLocation(position = new Location(x, y, z, yaw, pitch))) {
            this.dispatch(event, ViolationDocument.builder().description("is sending weird values").mitigationStrategy(MitigationStrategy.KICK).debugs(Arrays.asList(new Debug<String>("Location", position.toString()), new Debug<String>("Tag", "Position"))).build());
        }
        if (this.invalidValue(yaw, pitch)) {
            this.dispatch(event, ViolationDocument.builder().description("is rotating invalid").mitigationStrategy(MitigationStrategy.KICK).debugs(Arrays.asList(new Debug<Float>("Yaw", Float.valueOf(yaw)), new Debug<Float>("Pitch", Float.valueOf(pitch)), new Debug<String>("Tag", "Extreme Float"))).build());
        }
    }

    private boolean isInvalidLocation(Location pos) {
        return Double.isNaN(pos.getX()) || Double.isNaN(pos.getY()) || Double.isNaN(pos.getZ()) || Double.isInfinite(pos.getX()) || Double.isInfinite(pos.getY()) || Double.isInfinite(pos.getZ()) || Float.isNaN(pos.getYaw()) || Float.isNaN(pos.getPitch()) || Float.isInfinite(pos.getYaw()) || Float.isInfinite(pos.getPitch());
    }

    private void checkInvalidRotation(WrapperPlayClientPlayerFlying wrapper, PacketReceiveEvent event) {
        float pitch = wrapper.getLocation().getPitch();
        float yaw = wrapper.getLocation().getYaw();
        if ((double)Math.abs(pitch) > 90.01 || this.isOutOfRange(yaw) || this.isOutOfRange(pitch) || (double)yaw == 9.223372E18 || (double)pitch == 9.223372E18) {
            this.dispatch(event, ViolationDocument.builder().description("is rotating invalid").mitigationStrategy(MitigationStrategy.KICK).debugs(Arrays.asList(new Debug<Float>("Yaw", Float.valueOf(yaw)), new Debug<Float>("Pitch", Float.valueOf(pitch)))).build());
        }
    }

    private void checkDelta(Vector3d position, PacketReceiveEvent event) {
        boolean passedThreshold;
        double deltaX = Math.abs(position.getX() - this.lastLocation.getX());
        double deltaY = Math.abs(position.getY() - this.lastLocation.getY());
        double deltaZ = Math.abs(position.getZ() - this.lastLocation.getZ());
        double deltaXZ = Math.hypot(deltaX, deltaZ);
        long timeMillis = System.currentTimeMillis();
        boolean hasTeleported = timeMillis - this.playerData.getTeleportProcessor().getLastTeleportTime() < 2000L;
        boolean bl = passedThreshold = timeMillis - this.playerData.getJoinTime() > 1000L && !hasTeleported;
        if (passedThreshold && deltaXZ > 7.0 && this.playerData.getGameMode() == GameMode.SURVIVAL) {
            if (++this.deltaBuffer > 10) {
                this.dispatch(event, ViolationDocument.builder().description("is moving invalid").mitigationStrategy(MitigationStrategy.KICK).debugs(Arrays.asList(new Debug<Double>("DeltaXZ", deltaXZ), new Debug<Integer>("Buffer", this.deltaBuffer), new Debug<String>("GameMode", this.playerData.getGameMode().name()))).build());
            }
        } else {
            this.deltaBuffer = Math.max(0, this.deltaBuffer - 1);
        }
        if (this.invalidDeltaValue(deltaX, deltaY, deltaZ) && !SierraDataManager.skipDeltaPositionCheck) {
            this.dispatch(event, ViolationDocument.builder().description("is moving invalid").mitigationStrategy(MitigationStrategy.KICK).debugs(Arrays.asList(new Debug<Double>("DeltaX", deltaX), new Debug<Double>("DeltaY", deltaY), new Debug<Double>("DeltaZ", deltaZ), new Debug<String>("GameMode", this.playerData.getGameMode().name()))).build());
        }
    }

    private void handleChunkTravel(double chunkId, PacketReceiveEvent event) {
        long tick = System.currentTimeMillis();
        if (chunkId == this.lastChunkId) {
            return;
        }
        long travelTime = tick - this.lastTick;
        this.processBufferAndViolation(travelTime, event);
        this.lastTick = tick;
    }

    private void processBufferAndViolation(long travelTime, PacketReceiveEvent event) {
        if (travelTime < 20L) {
            if (++this.buffer > 5) {
                this.dispatch(event, ViolationDocument.builder().description("is moving invalid").mitigationStrategy(MitigationStrategy.KICK).debugs(Arrays.asList(new Debug<Integer>("Chunks", this.buffer), new Debug<Long>("Time", travelTime / (long)this.buffer), new Debug<String>("GameMode", this.playerData.getGameMode().name()))).build());
            }
        } else {
            this.buffer = Math.max(0, this.buffer - 1);
        }
    }

    private void checkForBorder(Vector3d position, PacketReceiveEvent event) {
        if (Math.abs(position.getX()) > 2.9999999E7 || Math.abs(position.getY()) > 2.9999999E7 || Math.abs(position.getZ()) > 2.9999999E7) {
            this.dispatch(event, ViolationDocument.builder().description("is moving invalid").mitigationStrategy(MitigationStrategy.BAN).debugs(Collections.singletonList(new Debug<String>("Tag", "out of border"))).build());
        }
    }

    private boolean isOutOfRange(float value) {
        return (double)value < -80000.0 || (double)value > 80000.0;
    }

    private boolean invalidValue(double ... values) {
        for (double v : values) {
            if (!Double.isNaN(v) && !Double.isInfinite(v)) continue;
            return true;
        }
        return false;
    }

    private boolean invalidValue(float ... values) {
        for (float v : values) {
            if (!Float.isInfinite(v)) continue;
            return true;
        }
        return false;
    }

    private boolean invalidDeltaValue(double ... deltas) {
        for (double delta : deltas) {
            if (!(delta >= 10.0) || delta % 1.0 != 0.0 || !(delta > 1000.0)) continue;
            return true;
        }
        return false;
    }

    private double computeChunkId(Vector3d position) {
        return Math.floor(position.getX() / 32.0) + Math.floor(position.getZ() / 32.0);
    }
}

