/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.check.impl.post;

import de.feelix.sierra.check.SierraDetection;
import de.feelix.sierra.check.violation.Debug;
import de.feelix.sierra.check.violation.ViolationDocument;
import de.feelix.sierra.manager.packet.IngoingProcessor;
import de.feelix.sierra.manager.packet.OutgoingProcessor;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.utilities.EvictingQueue;
import de.feelix.sierraapi.check.CheckType;
import de.feelix.sierraapi.check.SierraCheckData;
import de.feelix.sierraapi.violation.MitigationStrategy;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.square.sierra.packetevents.api.PacketEvents;
import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.event.PacketSendEvent;
import net.square.sierra.packetevents.api.manager.server.ServerVersion;
import net.square.sierra.packetevents.api.protocol.packettype.PacketType;
import net.square.sierra.packetevents.api.protocol.packettype.PacketTypeCommon;
import net.square.sierra.packetevents.api.protocol.player.ClientVersion;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientEntityAction;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientPlayerFlying;
import net.square.sierra.packetevents.api.wrapper.play.server.WrapperPlayServerEntityAnimation;
import org.bukkit.entity.Player;

@SierraCheckData(checkType=CheckType.POST)
public class PostCheck
extends SierraDetection
implements IngoingProcessor,
OutgoingProcessor {
    private int exemptFromSwingingCheck = Integer.MIN_VALUE;
    private final ArrayDeque<PacketTypeCommon> postQueue = new ArrayDeque();
    private final List<String> flags = new EvictingQueue<String>(10);
    private boolean hasSentFlyingPacket = false;

    public PostCheck(PlayerData playerData) {
        super(playerData);
    }

    private void handleFlyingPacket(PacketReceiveEvent event) {
        if (!this.flags.isEmpty() && this.configEngine().config().getBoolean("prevent-post-packets", true) && event.getUser().getClientVersion().isOlderThan(ClientVersion.V_1_9)) {
            boolean passedThreshold;
            long timeMillis = System.currentTimeMillis();
            boolean hasTeleported = timeMillis - this.playerData.getTeleportProcessor().getLastTeleportTime() < 1000L;
            boolean bl = passedThreshold = timeMillis - this.playerData.getJoinTime() > 1000L && !hasTeleported;
            if (passedThreshold) {
                for (String flag : this.flags) {
                    this.dispatch(event, ViolationDocument.builder().mitigationStrategy(this.violations() > 50.0 ? MitigationStrategy.KICK : MitigationStrategy.MITIGATE).description("send packet post").debugs(Collections.singletonList(new Debug<String>("Packet", flag))).build());
                }
            }
            this.flags.clear();
        }
        this.postQueue.clear();
        this.hasSentFlyingPacket = true;
    }

    private void handleTransactionPacket() {
        if (this.hasSentFlyingPacket && !this.postQueue.isEmpty()) {
            this.flags.add(this.formatFlag(this.postQueue.getFirst()));
        }
        this.postQueue.clear();
        this.hasSentFlyingPacket = false;
    }

    private void handleOtherPackets(PacketTypeCommon packetType, PacketReceiveEvent event) {
        if (this.shouldQueuePostCheck(packetType, event)) {
            this.postQueue.add(packetType);
        }
    }

    private boolean shouldQueuePostCheck(PacketTypeCommon packetType, PacketReceiveEvent event) {
        return this.hasSentFlyingPacket && (packetType.equals(PacketType.Play.Client.PLAYER_ABILITIES) || packetType.equals(PacketType.Play.Client.INTERACT_ENTITY) || packetType.equals(PacketType.Play.Client.PLAYER_BLOCK_PLACEMENT) || packetType.equals(PacketType.Play.Client.USE_ITEM) || packetType.equals(PacketType.Play.Client.PLAYER_DIGGING) || packetType.equals(PacketType.Play.Client.CLICK_WINDOW) && this.playerData.getClientVersion().isOlderThan(ClientVersion.V_1_13) || packetType.equals(PacketType.Play.Client.ANIMATION) && this.shouldHandleAnimation() || packetType.equals(PacketType.Play.Client.ENTITY_ACTION) && this.shouldHandleEntityAction(event));
    }

    private boolean shouldHandleEntityAction(PacketReceiveEvent event) {
        WrapperPlayClientEntityAction entityAction = new WrapperPlayClientEntityAction(event);
        return this.playerData.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) || entityAction.getAction() != WrapperPlayClientEntityAction.Action.START_FLYING_WITH_ELYTRA && !this.isRidingEntityInNewVersion();
    }

    private boolean isRidingEntityInNewVersion() {
        return this.playerData.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_19_3) && ((Player)this.playerData.getBukkitPlayer()).getVehicle() != null;
    }

    private boolean isOlderServerVersion() {
        return PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_8_8);
    }

    private boolean shouldHandleAnimation() {
        return (this.playerData.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) || this.isOlderServerVersion()) && this.playerData.getClientVersion().isOlderThan(ClientVersion.V_1_13) && this.exemptFromSwingingCheck < this.playerData.getTransactionProcessor().lastTransactionReceived.get();
    }

    private String formatFlag(PacketTypeCommon packetType) {
        return packetType.toString().toLowerCase(Locale.ROOT).replace("_", " ");
    }

    @Override
    public void handle(PacketReceiveEvent event, PlayerData playerData) {
        PacketTypeCommon packetType = event.getPacketType();
        if (WrapperPlayClientPlayerFlying.isFlying(packetType)) {
            this.handleFlyingPacket(event);
        } else if (this.isTransaction(packetType)) {
            this.handleTransactionPacket();
        } else {
            this.handleOtherPackets(packetType, event);
        }
    }

    public boolean isTransaction(PacketTypeCommon packetType) {
        return packetType == PacketType.Play.Client.PONG || packetType == PacketType.Play.Client.WINDOW_CONFIRMATION;
    }

    private boolean isSwingAnimation(WrapperPlayServerEntityAnimation animation) {
        return animation.getType() == WrapperPlayServerEntityAnimation.EntityAnimationType.SWING_MAIN_ARM || animation.getType() == WrapperPlayServerEntityAnimation.EntityAnimationType.SWING_OFF_HAND;
    }

    @Override
    public void handle(PacketSendEvent event, PlayerData playerData) {
        WrapperPlayServerEntityAnimation animation;
        if (event.getPacketType() == PacketType.Play.Server.ENTITY_ANIMATION && (animation = new WrapperPlayServerEntityAnimation(event)).getEntityId() == playerData.entityId() && this.isSwingAnimation(animation)) {
            this.exemptFromSwingingCheck = playerData.getTransactionProcessor().lastTransactionSent.get();
        }
    }
}

