/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.check.impl.protocol;

import de.feelix.sierra.Sierra;
import de.feelix.sierra.check.SierraDetection;
import de.feelix.sierra.check.impl.command.CommandValidation;
import de.feelix.sierra.check.violation.Debug;
import de.feelix.sierra.check.violation.ViolationDocument;
import de.feelix.sierra.manager.packet.IngoingProcessor;
import de.feelix.sierra.manager.packet.OutgoingProcessor;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.manager.storage.SierraDataManager;
import de.feelix.sierra.manager.storage.menu.MenuType;
import de.feelix.sierra.utilities.CastUtil;
import de.feelix.sierra.utilities.FieldReader;
import de.feelix.sierra.utilities.FormatUtils;
import de.feelix.sierra.utilities.attributes.AttributeMapper;
import de.feelix.sierra.utilities.types.BannerType;
import de.feelix.sierra.utilities.types.ShulkerBoxType;
import de.feelix.sierraapi.check.CheckType;
import de.feelix.sierraapi.check.SierraCheckData;
import de.feelix.sierraapi.violation.MitigationStrategy;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.square.sierra.cryptomorin.xseries.XMaterial;
import net.square.sierra.packetevents.api.PacketEvents;
import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.event.PacketSendEvent;
import net.square.sierra.packetevents.api.event.ProtocolPacketEvent;
import net.square.sierra.packetevents.api.manager.server.ServerVersion;
import net.square.sierra.packetevents.api.netty.buffer.ByteBufHelper;
import net.square.sierra.packetevents.api.protocol.ConnectionState;
import net.square.sierra.packetevents.api.protocol.item.ItemStack;
import net.square.sierra.packetevents.api.protocol.item.type.ItemType;
import net.square.sierra.packetevents.api.protocol.item.type.ItemTypes;
import net.square.sierra.packetevents.api.protocol.nbt.NBTByteArray;
import net.square.sierra.packetevents.api.protocol.nbt.NBTCompound;
import net.square.sierra.packetevents.api.protocol.nbt.NBTInt;
import net.square.sierra.packetevents.api.protocol.nbt.NBTIntArray;
import net.square.sierra.packetevents.api.protocol.nbt.NBTList;
import net.square.sierra.packetevents.api.protocol.nbt.NBTLongArray;
import net.square.sierra.packetevents.api.protocol.nbt.NBTNumber;
import net.square.sierra.packetevents.api.protocol.nbt.NBTString;
import net.square.sierra.packetevents.api.protocol.nbt.NBTType;
import net.square.sierra.packetevents.api.protocol.packettype.PacketType;
import net.square.sierra.packetevents.api.protocol.player.ClientVersion;
import net.square.sierra.packetevents.api.protocol.player.GameMode;
import net.square.sierra.packetevents.api.protocol.world.BlockFace;
import net.square.sierra.packetevents.api.util.Vector3d;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientChatMessage;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientClickWindow;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientClickWindowButton;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientCreativeInventoryAction;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientEntityAction;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientHeldItemChange;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientInteractEntity;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientNameItem;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientPlayerBlockPlacement;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientPlayerDigging;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientPluginMessage;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientSettings;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientSteerVehicle;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientTabComplete;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientUpdateSign;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientUseItem;
import net.square.sierra.packetevents.api.wrapper.play.server.WrapperPlayServerOpenWindow;
import net.square.sierra.packetevents.api.wrapper.play.server.WrapperPlayServerSetExperience;
import net.square.sierra.packetevents.api.wrapper.play.server.WrapperPlayServerWindowItems;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

@SierraCheckData(checkType=CheckType.PROTOCOL_VALIDATION)
public class ProtocolValidation
extends SierraDetection
implements IngoingProcessor,
OutgoingProcessor {
    private MenuType type = MenuType.UNKNOWN;
    private int lecternId = -1;
    private int lastSlot = -1;
    private long lastBookUse = 0L;
    private boolean hasOpenAnvil = false;
    private static final Pattern EXPLOIT_PATTERN = Pattern.compile("\\$\\{.+}");
    private int containerType = -1;
    private int containerId = -1;
    private static final String WURSTCLIENT_URL = "www.wurstclient.net";
    private static final int MAX_BYTE_SIZE = 262144;
    private static final int MAX_BANNER_LAYERS = 15;
    private static final int MAX_PATTERN_LENGTH = 50;
    private static final int MIN_VALID_COLOR = 0;
    private static final int MAX_SIGN_LENGTH = 45;
    private static final int MAX_VALID_COLOR = 255;
    private final AtomicInteger listContent = new AtomicInteger(0);

    public ProtocolValidation(PlayerData playerData) {
        super(playerData);
    }

    @Override
    public void handle(PacketReceiveEvent event, PlayerData playerData) {
        int maxBytes;
        if (!this.configEngine().config().getBoolean("prevent-protocol-packet", true)) {
            return;
        }
        if (event.getConnectionState() != ConnectionState.PLAY) {
            return;
        }
        int capacity = ByteBufHelper.capacity(event.getByteBuf());
        if (capacity > (maxBytes = 64000 * (playerData.getClientVersion().isOlderThan(ClientVersion.V_1_8) ? 2 : 1))) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("sends too big packet").debugs(Arrays.asList(new Debug<Integer>("Bytes", capacity), new Debug<Integer>("Max Bytes", maxBytes))).build());
        }
        int readableBytes = ByteBufHelper.readableBytes(event.getByteBuf());
        int maxBytesPerSecond = 64000 * (playerData.getClientVersion().isOlderThan(ClientVersion.V_1_8) ? 2 : 1);
        playerData.setBytesSent(playerData.getBytesSent() + (double)readableBytes);
        if (playerData.getBytesSent() > (double)maxBytesPerSecond) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("sends too big packet in a second").debugs(Arrays.asList(new Debug<Double>("Bytes", playerData.getBytesSent()), new Debug<Integer>("Max Bytes", maxBytesPerSecond))).build());
        }
        this.handleAnvilInventory(event);
        this.handleClientSettings(event, playerData);
        this.handleCreativeInventoryAction(event, playerData);
        this.handleEntityAction(event);
        this.handleSpectate(event);
        this.handleClickWindowButton(event);
        this.handleChatMessage(event);
        this.handleHeldItemChange(event);
        this.handleTabComplete(event, playerData);
        this.handleUpdateSign(event, playerData);
        this.handlePlayerBlockPlacement(event, playerData);
        this.handleSteerVehicle(event);
        this.handleInteractEntity(event);
        this.handleNameItem(event);
        this.handlePlayerDigging(event, playerData);
        this.handleUseItem(event, playerData);
        this.handleClickWindow(event, playerData);
        this.handlePluginMessage(event, playerData);
    }

    private void handleAnvilInventory(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.PLUGIN_MESSAGE) {
            WrapperPlayClientPluginMessage wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientPluginMessage(event), this.playerData::exceptionDisconnect);
            String channelName = wrapper.getChannelName();
            if (channelName.equalsIgnoreCase("MC|ItemName") && !this.hasOpenAnvil) {
                this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send anvil payload with closed inventory").debugs(Collections.emptyList()).build());
            }
        } else if (event.getPacketType() == PacketType.Play.Client.CLOSE_WINDOW && this.hasOpenAnvil) {
            this.hasOpenAnvil = false;
        }
    }

    private void handleClientSettings(PacketReceiveEvent event, PlayerData playerData) {
        if (event.getPacketType() == PacketType.Play.Client.CLIENT_SETTINGS) {
            WrapperPlayClientSettings wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientSettings(event), playerData::exceptionDisconnect);
            if (wrapper == null) {
                return;
            }
            this.adjustViewDistance(wrapper, event);
            this.checkLocale(wrapper, event);
        }
    }

    private void adjustViewDistance(WrapperPlayClientSettings wrapper, PacketReceiveEvent event) {
        if (wrapper.getViewDistance() < 2) {
            Logger logger = Sierra.getPlugin().getLogger();
            logger.log(Level.INFO, String.format("Adjusting %s's view distance from %d to 2", event.getUser().getName(), wrapper.getViewDistance()));
            wrapper.setViewDistance(2);
        }
    }

    private void checkLocale(WrapperPlayClientSettings wrapper, PacketReceiveEvent event) {
        if (wrapper.getLocale() == null) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send null value in packet").debugs(Collections.singletonList(new Debug<String>("Tag", "ClientSettings"))).build());
        }
        if (EXPLOIT_PATTERN.matcher(wrapper.getLocale()).matches()) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.MITIGATE).description("send exploit in locale").debugs(Collections.singletonList(new Debug<String>("Locale", wrapper.getLocale()))).build());
        }
    }

    private void handleCreativeInventoryAction(PacketReceiveEvent event, PlayerData playerData) {
        if (event.getPacketType() == PacketType.Play.Client.CREATIVE_INVENTORY_ACTION) {
            WrapperPlayClientCreativeInventoryAction wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientCreativeInventoryAction(event), playerData::exceptionDisconnect);
            ItemStack itemStack = wrapper.getItemStack();
            this.checkItemStack(event, itemStack);
        }
    }

    private void handleEntityAction(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.ENTITY_ACTION) {
            WrapperPlayClientEntityAction wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientEntityAction(event), this.playerData::exceptionDisconnect);
            this.checkEntityAction(wrapper, event);
        }
    }

    private void checkEntityAction(WrapperPlayClientEntityAction wrapper, PacketReceiveEvent event) {
        if (wrapper.getEntityId() < 0) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.BAN).description("send invalid entity id").debugs(Collections.singletonList(new Debug<Integer>("Id", wrapper.getEntityId()))).build());
        }
    }

    private void handleSpectate(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.SPECTATE && this.playerData.getGameMode() != GameMode.SPECTATOR) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.BAN).description("spoofed his game-mode").debugs(Collections.singletonList(new Debug<String>("GameMode", GameMode.SPECTATOR.name()))).build());
        }
    }

    private void handleClickWindowButton(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.CLICK_WINDOW_BUTTON) {
            WrapperPlayClientClickWindowButton wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientClickWindowButton(event), this.playerData::exceptionDisconnect);
            if (wrapper.getButtonId() < 0 || wrapper.getWindowId() < 0) {
                this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.BAN).description("clicked on invalid button").debugs(Arrays.asList(new Debug<Integer>("WindowId", wrapper.getWindowId()), new Debug<Integer>("ButtonId", wrapper.getButtonId()))).build());
            }
        }
    }

    private void handleChatMessage(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.CHAT_MESSAGE) {
            WrapperPlayClientChatMessage wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientChatMessage(event), this.playerData::exceptionDisconnect);
            if (wrapper.getMessage().contains("${")) {
                this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send log4j exploit").debugs(Collections.singletonList(new Debug<String>("Message", wrapper.getMessage()))).build());
            }
        }
    }

    private void handleHeldItemChange(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.HELD_ITEM_CHANGE) {
            WrapperPlayClientHeldItemChange wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientHeldItemChange(event), this.playerData::exceptionDisconnect);
            this.checkHeldItemChange(wrapper, event);
        }
    }

    private void checkHeldItemChange(WrapperPlayClientHeldItemChange wrapper, PacketReceiveEvent event) {
        Player player;
        int slot = wrapper.getSlot();
        if (slot > 36 || slot < 0) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.BAN).description("send invalid hot-bar slot").debugs(Collections.singletonList(new Debug<Integer>("Slot", slot))).build());
        }
        if ((player = (Player)event.getPlayer()) == null) {
            return;
        }
        int length = player.getInventory().getContents().length;
        if (wrapper.getSlot() < 0 || wrapper.getSlot() >= length) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.BAN).description("send invalid hot-bar slot").debugs(Arrays.asList(new Debug<Integer>("Slot", slot), new Debug<Integer>("Max", length))).build());
        }
        if (slot == this.lastSlot) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.MITIGATE).description("send hot-bar slot twice").debugs(Arrays.asList(new Debug<Integer>("Slot", slot), new Debug<Integer>("Last", this.lastSlot))).build());
        }
        this.lastSlot = slot;
    }

    private void handleTabComplete(PacketReceiveEvent event, PlayerData playerData) {
        if (event.getPacketType() == PacketType.Play.Client.TAB_COMPLETE) {
            WrapperPlayClientTabComplete wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientTabComplete(event), playerData::exceptionDisconnect);
            this.checkTabComplete(wrapper, event);
        }
    }

    private void checkTabComplete(WrapperPlayClientTabComplete wrapper, PacketReceiveEvent event) {
        int index;
        if (wrapper.getText() == null) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.BAN).description("send null value in tab-complete").debugs(Collections.singletonList(new Debug<String>("Tag", "Null"))).build());
        }
        String text = wrapper.getText();
        int length = text.length();
        if (CommandValidation.WORLDEDIT_PATTERN.matcher(text).matches()) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.MITIGATE).description("send invalid tab-complete").debugs(Arrays.asList(new Debug<String>("Tag", "WorldEdit"), new Debug<String>("Text", text))).build());
        }
        if (this.areBracketsTooFrequent(text, 15) || CommandValidation.WORLDEDIT_PATTERN.matcher(text).matches()) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send invalid tab-complete").debugs(Arrays.asList(new Debug<String>("Tag", "WorldEdit-Brackets"), new Debug<String>("Text", text))).build());
        }
        if (length > 256) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.MITIGATE).description("send invalid tab-complete").debugs(Arrays.asList(new Debug<String>("Tag", "Length"), new Debug<Integer>("Length", length))).build());
        }
        if ((text.equals("/") || text.trim().isEmpty()) && PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_13)) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.MITIGATE).description("send invalid tab-complete").debugs(Collections.singletonList(new Debug<String>("Tag", "Trim"))).build());
        }
        if (text.length() > 64 && ((index = text.indexOf(32)) == -1 || index >= 64)) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send invalid tab-complete").debugs(Collections.singletonList(new Debug<Integer>("Length", length))).build());
        }
    }

    private void handleUpdateSign(PacketReceiveEvent event, PlayerData playerData) {
        if (event.getPacketType() == PacketType.Play.Client.UPDATE_SIGN) {
            WrapperPlayClientUpdateSign wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientUpdateSign(event), playerData::exceptionDisconnect);
            if (wrapper == null) {
                return;
            }
            this.checkUpdateSign(wrapper, event, playerData);
        }
    }

    private void checkUpdateSign(WrapperPlayClientUpdateSign wrapper, PacketReceiveEvent event, PlayerData playerData) {
        double distanceFromLastLocation = wrapper.getBlockPosition().toVector3d().distanceSquared(playerData.getLastLocation().getPosition());
        if (distanceFromLastLocation > 64.0) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send sign update out of distance").debugs(Collections.singletonList(new Debug<Double>("Distance", distanceFromLastLocation))).build());
        }
        for (String textLine : wrapper.getTextLines()) {
            if (textLine.toLowerCase().contains("run_command")) {
                this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send raw json in sign update").debugs(Collections.emptyList()).build());
            }
            if (textLine.length() <= 45) continue;
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.BAN).description("send to big sign-update").debugs(Collections.singletonList(new Debug<Integer>("Length", textLine.length()))).build());
        }
    }

    private void handlePluginMessage(PacketReceiveEvent event, PlayerData playerData) {
        if (event.getPacketType() == PacketType.Play.Client.PLUGIN_MESSAGE) {
            WrapperPlayClientPluginMessage wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientPluginMessage(event), playerData::exceptionDisconnect);
            this.checkPluginMessage(wrapper, event, playerData);
        }
    }

    private void checkPluginMessage(WrapperPlayClientPluginMessage wrapper, PacketReceiveEvent event, PlayerData playerData) {
        String channelName = wrapper.getChannelName();
        if (this.isBookChannel(channelName) && System.currentTimeMillis() - this.lastBookUse > 60000L) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.MITIGATE).description("send book sign without book use").debugs(Collections.emptyList()).build());
        }
        if (channelName.contains("${")) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send protocol channel in plugin message").debugs(Collections.singletonList(new Debug<String>("Channel", channelName))).build());
        }
        this.checkPayload(wrapper, event, playerData);
    }

    private boolean isBookChannel(String channelName) {
        return channelName.equalsIgnoreCase("MC|BEdit") || channelName.equalsIgnoreCase("MC|BSign") || channelName.equalsIgnoreCase("MC|BOpen") || channelName.equalsIgnoreCase("minecraft:bedit") || channelName.equalsIgnoreCase("minecraft:bsign");
    }

    private void checkPayload(WrapperPlayClientPluginMessage wrapper, PacketReceiveEvent event, PlayerData playerData) {
        String payload = new String(wrapper.getData(), StandardCharsets.UTF_8);
        if (payload.equalsIgnoreCase("N")) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(this.violations() > 3.0 ? MitigationStrategy.BAN : MitigationStrategy.MITIGATE).description("send liquid-bounce console spammer").debugs(Collections.emptyList()).build());
        }
        this.checkBookInHand(event, payload);
        this.handleChannels(event, payload, playerData, wrapper.getChannelName());
    }

    private void checkBookInHand(PacketReceiveEvent event, String payload) {
        Player player;
        XMaterial xMaterial;
        if ((payload.contains("MC|BEdit") || payload.contains("MC|BSign") || payload.contains("MC|BOpen")) && (xMaterial = XMaterial.matchXMaterial((player = (Player)event.getPlayer()).getItemInHand())) != XMaterial.WRITABLE_BOOK && xMaterial != XMaterial.WRITTEN_BOOK && xMaterial != XMaterial.BOOK) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send book packet without book in hand").debugs(Collections.emptyList()).build());
        }
    }

    private void handleChannels(PacketReceiveEvent event, String payload, PlayerData playerData, String channelName) {
        String[] channels = payload.split("\u0000");
        if (channelName.equals("REGISTER")) {
            this.handleRegisterChannels(event, playerData, channels);
        } else if (channelName.equals("UNREGISTER")) {
            this.handleUnregisterChannels(playerData, channels);
        }
    }

    private void handleRegisterChannels(PacketReceiveEvent event, PlayerData playerData, String[] channels) {
        if (playerData.getChannels().size() + channels.length > 124 || channels.length > 124) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.BAN).description("send to big channel in payload").debugs(Collections.singletonList(new Debug<Integer>("Length", channels.length))).build());
        } else {
            for (String channel : channels) {
                playerData.getChannels().add(channel);
            }
        }
    }

    private void handleUnregisterChannels(PlayerData playerData, String[] channels) {
        for (String channel : channels) {
            playerData.getChannels().remove(channel);
        }
    }

    private void handlePlayerBlockPlacement(PacketReceiveEvent event, PlayerData playerData) {
        if (event.getPacketType() == PacketType.Play.Client.PLAYER_BLOCK_PLACEMENT) {
            WrapperPlayClientPlayerBlockPlacement wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientPlayerBlockPlacement(event), playerData::exceptionDisconnect);
            if (wrapper == null) {
                return;
            }
            this.checkBlockPlacement(wrapper, event);
        }
    }

    private void checkBlockPlacement(WrapperPlayClientPlayerBlockPlacement wrapper, PacketReceiveEvent event) {
        Vector3d blockPosition = wrapper.getBlockPosition().toVector3d();
        double distanced = blockPosition.distanceSquared(this.playerData.getLastLocation().getPosition());
        if (distanced > 50.0 && wrapper.getFace() != BlockFace.OTHER) {
            this.dispatch(event, ViolationDocument.builder().description("placed a block out of distance").debugs(Arrays.asList(new Debug<Double>("Distance", distanced), new Debug<String>("Version", this.playerData.getClientVersion().getReleaseName()), new Debug<Long>("Alive", this.playerData.getPingProcessor().getPing()), new Debug<Long>("Transaction", this.playerData.getTransactionProcessor().getTransactionPing()))).mitigationStrategy(MitigationStrategy.KICK).build());
        }
        boolean isSequenceNegative = wrapper.getSequence() < 0;
        boolean isNewerThanV119 = event.getUser().getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_19);
        ServerVersion currentVersion = PacketEvents.getAPI().getServerManager().getVersion();
        boolean isVersionV119OrNewer = currentVersion.isNewerThanOrEquals(ServerVersion.V_1_19);
        if (isSequenceNegative && isNewerThanV119 && isVersionV119OrNewer) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.BAN).description("send invalid sequence in block place").debugs(Collections.singletonList(new Debug<Integer>("Sequence", wrapper.getSequence()))).build());
        }
        if (wrapper.getItemStack().isPresent()) {
            ItemStack itemStack = wrapper.getItemStack().get();
            this.checkBookUse(itemStack);
            this.checkItemStack(event, itemStack);
        }
    }

    private void checkBookUse(ItemStack itemStack) {
        if (itemStack.getType() == ItemTypes.WRITABLE_BOOK || itemStack.getType() == ItemTypes.WRITTEN_BOOK || itemStack.getType() == ItemTypes.BOOK) {
            this.lastBookUse = System.currentTimeMillis();
        }
    }

    private void handleSteerVehicle(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.STEER_VEHICLE) {
            WrapperPlayClientSteerVehicle wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientSteerVehicle(event), this.playerData::exceptionDisconnect);
            this.checkSteerVehicle(wrapper, event);
        }
    }

    private void checkSteerVehicle(WrapperPlayClientSteerVehicle wrapper, PacketReceiveEvent event) {
        float forward = wrapper.getForward();
        float sideways = wrapper.getSideways();
        if (forward > 0.98f || forward < -0.98f) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send invalid steer vehicle").debugs(Collections.singletonList(new Debug<Float>("Forward", Float.valueOf(forward)))).build());
        }
        if (sideways > 0.98f || sideways < -0.98f) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send invalid steer vehicle").debugs(Collections.singletonList(new Debug<Float>("Sideways", Float.valueOf(sideways)))).build());
        }
    }

    private void handleInteractEntity(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.INTERACT_ENTITY) {
            WrapperPlayClientInteractEntity wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientInteractEntity(event), this.playerData::exceptionDisconnect);
            this.checkInteractEntity(wrapper, event);
        }
    }

    private void checkInteractEntity(WrapperPlayClientInteractEntity wrapper, PacketReceiveEvent event) {
        int entityId = event.getUser().getEntityId();
        if (wrapper.getEntityId() < 0 || entityId == wrapper.getEntityId()) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send invalid interact").debugs(Arrays.asList(new Debug<Integer>("Id", wrapper.getEntityId()), new Debug<Boolean>("Own", entityId == wrapper.getEntityId()))).build());
        }
    }

    private void handleNameItem(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.NAME_ITEM) {
            WrapperPlayClientNameItem wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientNameItem(event), this.playerData::exceptionDisconnect);
            this.checkNameItem(wrapper, event);
        }
    }

    private void checkNameItem(WrapperPlayClientNameItem wrapper, PacketReceiveEvent event) {
        int length;
        if (wrapper.getItemName().contains("${")) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send log4j exploit in item name").debugs(Collections.singletonList(new Debug<String>("Message", wrapper.getItemName()))).build());
        }
        if ((length = wrapper.getItemName().length()) > 0 && FieldReader.isReadable(wrapper.getItemName())) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send unreadable item name").debugs(Collections.singletonList(new Debug<String>("Name", wrapper.getItemName()))).build());
        }
        if (length > 50) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send too big item name").debugs(Collections.singletonList(new Debug<Integer>("Length", length))).build());
        }
    }

    private void handlePlayerDigging(PacketReceiveEvent event, PlayerData playerData) {
        ClientVersion playerVersion = event.getUser().getClientVersion();
        boolean isClientVersion19OrNewer = playerVersion.isNewerThanOrEquals(ClientVersion.V_1_19);
        ServerVersion currentVersion = PacketEvents.getAPI().getServerManager().getVersion();
        boolean isVersion19OrNewer = currentVersion.isNewerThanOrEquals(ServerVersion.V_1_19);
        if (event.getPacketType() == PacketType.Play.Client.PLAYER_DIGGING && isClientVersion19OrNewer && isVersion19OrNewer) {
            WrapperPlayClientPlayerDigging dig = CastUtil.getSupplier(() -> new WrapperPlayClientPlayerDigging(event), playerData::exceptionDisconnect);
            this.checkPlayerDigging(dig, event);
        }
    }

    private void checkPlayerDigging(WrapperPlayClientPlayerDigging dig, PacketReceiveEvent event) {
        boolean isSequenceNegative = dig.getSequence() < 0;
        boolean isNewerVersion = event.getUser().getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_19);
        ServerVersion currentVersion = PacketEvents.getAPI().getServerManager().getVersion();
        boolean isVersion19OrNewer = currentVersion.isNewerThanOrEquals(ServerVersion.V_1_19);
        if (isSequenceNegative && isNewerVersion && isVersion19OrNewer) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.BAN).description("send invalid dig sequence").debugs(Collections.emptyList()).build());
        }
    }

    private void handleUseItem(PacketReceiveEvent event, PlayerData playerData) {
        ClientVersion playerVersion = event.getUser().getClientVersion();
        boolean isClientVersionAtLeastV1_19 = playerVersion.isNewerThanOrEquals(ClientVersion.V_1_19);
        ServerVersion currentVersion = PacketEvents.getAPI().getServerManager().getVersion();
        boolean isVersionAtLeastV1_19 = currentVersion.isNewerThanOrEquals(ServerVersion.V_1_19);
        if (event.getPacketType() == PacketType.Play.Client.USE_ITEM && isClientVersionAtLeastV1_19 && isVersionAtLeastV1_19) {
            WrapperPlayClientUseItem use = CastUtil.getSupplier(() -> new WrapperPlayClientUseItem(event), playerData::exceptionDisconnect);
            if (use.getSequence() < 0) {
                this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.BAN).description("send invalid use item sequence").debugs(Collections.emptyList()).build());
            }
        }
    }

    private void handleClickWindow(PacketReceiveEvent event, PlayerData playerData) {
        if (event.getPacketType() == PacketType.Play.Client.CLICK_WINDOW) {
            WrapperPlayClientClickWindow wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientClickWindow(event), playerData::exceptionDisconnect);
            if (wrapper == null) {
                return;
            }
            this.checkClickWindow(wrapper, event);
        }
    }

    private void checkClickWindow(WrapperPlayClientClickWindow wrapper, PacketReceiveEvent event) {
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_14)) {
            int clickType = wrapper.getWindowClickType().ordinal();
            int button = wrapper.getButton();
            int windowId = wrapper.getWindowId();
            if (this.type == MenuType.LECTERN && windowId > 0 && windowId == this.lecternId) {
                this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send invalid window click").debugs(Arrays.asList(new Debug<Integer>("ClickType", clickType), new Debug<Integer>("Button", button))).build());
            }
        }
        ItemStack carriedItemStack = wrapper.getCarriedItemStack();
        this.checkButtonClickPosition(event, wrapper);
        this.checkItemStack(event, carriedItemStack);
        this.checkForInvalidSlot(event, wrapper);
        this.checkInvalidClick(wrapper, event);
    }

    private void checkItemStack(PacketReceiveEvent event, ItemStack itemStack) {
        if (itemStack == null || itemStack.getNBT() == null) {
            return;
        }
        this.checkItemStackTag(event, itemStack);
        this.checkGenericBookPages(event, itemStack);
        this.checkGenericNBTLimit(event, itemStack);
        this.checkLanguageExploit(event, itemStack);
        this.checkAttributes(event, itemStack);
        this.checkInvalidNbt(event, itemStack);
        this.checkForInvalidBanner(event, itemStack);
        this.checkForInvalidArmorStand(event, itemStack);
        this.checkForInvalidContainer(event, itemStack);
        this.checkForInvalidShulker(event, itemStack);
        this.checkNbtTags(event, itemStack);
    }

    private void checkGenericBookPages(PacketReceiveEvent event, ItemStack itemStack) {
        int totalLength;
        if (itemStack == null || itemStack.getNBT() == null) {
            return;
        }
        NBTList<NBTString> pages = itemStack.getNBT().getStringListTagOrNull("pages");
        if (pages == null) {
            return;
        }
        if (pages.getTags().size() > 50) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send book with too many pages").debugs(Collections.singletonList(new Debug<Integer>("Pages", pages.getTags().size()))).build());
        }
        if ((totalLength = ProtocolValidation.calculateTotalLength(pages)) > 12800) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send book with too big content").debugs(Arrays.asList(new Debug<Integer>("Length", totalLength), new Debug<Integer>("Max", 12800))).build());
        }
    }

    private static int calculateTotalLength(NBTList<NBTString> pages) {
        int totalLength = 0;
        for (NBTString tag : pages.getTags()) {
            totalLength += tag.getValue().length();
        }
        return totalLength;
    }

    private void checkLanguageExploit(PacketReceiveEvent event, ItemStack itemStack) {
        if (itemStack == null || itemStack.getNBT() == null) {
            return;
        }
        String mapped = FormatUtils.mapToString(itemStack.getNBT().getTags());
        if (mapped.contains("translate") || mapped.contains("options.snooper.desc") || FormatUtils.countOccurrences(mapped, "translate") > 20) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.MITIGATE).description("send raw translate request").debugs(Arrays.asList(new Debug<Boolean>("Contains", mapped.contains("translate")), new Debug<Boolean>("Snooper", mapped.contains("options.snooper.desc")), new Debug<Integer>("Count", FormatUtils.countOccurrences(mapped, "translate")), new Debug<Integer>("Max Count", 20))).build());
            itemStack.setNBT(new NBTCompound());
        }
    }

    private void checkAttributes(ProtocolPacketEvent event, ItemStack itemStack) {
        if (!this.hasAttributeModifiers(itemStack)) {
            return;
        }
        List<NBTCompound> tags = this.getAttributeModifiers(itemStack);
        boolean vanillaMapping = this.useVanillaAttributeMapping();
        for (NBTCompound tag : tags) {
            AttributeMapper attributeMapper = this.getAttributeMapper(tag);
            if (attributeMapper == null) continue;
            this.handleAttributeViolation(event, vanillaMapping, attributeMapper, tag);
        }
    }

    private AttributeMapper getAttributeMapper(NBTCompound tag) {
        return AttributeMapper.getAttributeMapper(tag.getStringTagOrNull("AttributeName").getValue());
    }

    private boolean hasAttributeModifiers(ItemStack itemStack) {
        return itemStack.getNBT() != null && itemStack.getNBT().getCompoundListTagOrNull("AttributeModifiers") != null;
    }

    private List<NBTCompound> getAttributeModifiers(ItemStack itemStack) {
        return itemStack.getNBT().getCompoundListTagOrNull("AttributeModifiers").getTags();
    }

    public void checkGenericNBTLimit(PacketReceiveEvent event, ItemStack itemStack) {
        int limit;
        if (!this.configEngine().config().getBoolean("generic-nbt-limit", true)) {
            return;
        }
        if (itemStack == null || itemStack.getNBT() == null) {
            return;
        }
        int length = FormatUtils.mapToString(itemStack.getNBT().getTags()).length();
        int n = limit = this.playerData.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_16) ? 30000 : 25000;
        if (length > limit) {
            this.dispatch(event, ViolationDocument.builder().description("send item-stack with too big nbt tag").mitigationStrategy(MitigationStrategy.MITIGATE).debugs(Arrays.asList(new Debug<Integer>("Length", length), new Debug<Integer>("Limit", limit))).build());
        }
    }

    private void handleAttributeViolation(ProtocolPacketEvent event, boolean vanillaMapping, AttributeMapper attributeMapper, NBTCompound tag) {
        if (tag == null) {
            return;
        }
        NBTNumber numberTagOrNull = tag.getNumberTagOrNull("Amount");
        if (numberTagOrNull == null) {
            return;
        }
        double amount = numberTagOrNull.getAsDouble();
        if (this.isAmountInvalid(vanillaMapping, attributeMapper, amount)) {
            this.dispatch(event, ViolationDocument.builder().description("send invalid attribute modifier").mitigationStrategy(MitigationStrategy.KICK).debugs(Collections.singletonList(new Debug<Double>("Amount", amount))).build());
        } else if (!vanillaMapping && this.isSierraModifierInvalid(amount)) {
            this.dispatch(event, ViolationDocument.builder().description("send invalid sierra-attribute modifier").mitigationStrategy(MitigationStrategy.KICK).debugs(Collections.singletonList(new Debug<Double>("Amount", amount))).build());
        } else if (FormatUtils.checkDoublePrecision(amount)) {
            this.dispatch(event, ViolationDocument.builder().description("send invalid attribute modifier").mitigationStrategy(MitigationStrategy.KICK).debugs(Collections.singletonList(new Debug<String>("Tag", "Precision"))).build());
        }
    }

    private boolean useVanillaAttributeMapping() {
        return this.configEngine().config().getBoolean("use-vanilla-attribute-mapping", true);
    }

    private boolean isAmountInvalid(boolean vanillaMapping, AttributeMapper attributeMapper, double amount) {
        return vanillaMapping && (amount > attributeMapper.getMax() || amount < attributeMapper.getMin());
    }

    private boolean isSierraModifierInvalid(double amount) {
        return Math.abs(amount) > 5.0;
    }

    private void checkInvalidNbt(PacketReceiveEvent event, ItemStack itemStack) {
        if (itemStack == null || itemStack.getNBT() == null) {
            return;
        }
        NBTCompound nbt = itemStack.getNBT();
        NBTList<NBTCompound> items = nbt.getTagListOfTypeOrNull("Items", NBTCompound.class);
        if (items != null) {
            if (items.size() > 64) {
                this.dispatch(event, ViolationDocument.builder().description("send to big item-list").mitigationStrategy(MitigationStrategy.MITIGATE).debugs(Collections.singletonList(new Debug<Integer>("Size", items.size()))).build());
            }
            for (NBTCompound tag : items.getTags()) {
                this.checkItemTag(tag, event);
            }
        }
        this.checkProjectileTags(nbt, event);
        this.checkCustomModelData(nbt, event);
    }

    private void checkItemTag(NBTCompound tag, PacketReceiveEvent event) {
        String value;
        NBTString id = tag.getStringTagOrNull("id");
        if (id != null && ((value = id.getValue()).equalsIgnoreCase("minecraft:air") || value.equalsIgnoreCase("minecraft:bundle"))) {
            this.dispatch(event, ViolationDocument.builder().description("send invalid item-stack id").mitigationStrategy(MitigationStrategy.MITIGATE).debugs(Collections.singletonList(new Debug<String>("Id", value))).build());
        }
    }

    private void checkProjectileTags(NBTCompound nbt, PacketReceiveEvent event) {
        NBTList<NBTCompound> chargedProjectiles = nbt.getTagListOfTypeOrNull("ChargedProjectiles", NBTCompound.class);
        if (chargedProjectiles != null) {
            for (NBTCompound tag : chargedProjectiles.getTags()) {
                NBTCompound tag1 = tag.getCompoundTagOrNull("tag");
                if (tag1 == null || tag1.getStringTagOrNull("Potion") == null || !tag1.getStringTagOrNull("Potion").getValue().endsWith("empty")) continue;
                this.dispatch(event, ViolationDocument.builder().description("send invalid projectile tag").mitigationStrategy(MitigationStrategy.MITIGATE).debugs(Collections.singletonList(new Debug<String>("Tag", "empty"))).build());
            }
        }
    }

    private void checkCustomModelData(NBTCompound nbt, PacketReceiveEvent event) {
        int asInt;
        NBTInt customModelData = nbt.getTagOfTypeOrNull("CustomModelData", NBTInt.class);
        ServerVersion currentVersion = PacketEvents.getAPI().getServerManager().getVersion();
        boolean isVersion1_14OrNewer = currentVersion.isNewerThanOrEquals(ServerVersion.V_1_14);
        if (customModelData != null && isVersion1_14OrNewer && ((asInt = customModelData.getAsInt()) == Integer.MIN_VALUE || asInt == Integer.MAX_VALUE || asInt < 0) && !SierraDataManager.skipModelCheck) {
            this.dispatch(event, ViolationDocument.builder().description("send invalid custom-model data").mitigationStrategy(MitigationStrategy.MITIGATE).debugs(Collections.singletonList(new Debug<Integer>("Data", asInt))).build());
        }
    }

    private void checkForInvalidSlot(PacketReceiveEvent event, WrapperPlayClientClickWindow wrapper) {
        boolean isSlotNegative;
        int max;
        int slot = wrapper.getSlot();
        boolean invalid = slot > (max = 89);
        boolean bl = isSlotNegative = slot < 0;
        if (isSlotNegative && slot != -999 && slot != -1) {
            invalid = true;
        }
        if (invalid) {
            this.dispatch(event, ViolationDocument.builder().description("send invalid slot packet").mitigationStrategy(MitigationStrategy.MITIGATE).debugs(Arrays.asList(new Debug<Integer>("Slot", slot), new Debug<Integer>("Max", max))).build());
        }
    }

    public boolean areBracketsTooFrequent(String input, int threshold) {
        return input.chars().filter(c -> c == 91 || c == 93).count() > (long)threshold;
    }

    private void checkButtonClickPosition(PacketReceiveEvent event, WrapperPlayClientClickWindow wrapper) {
        int button;
        int clickType = wrapper.getWindowClickType().ordinal();
        boolean flag = this.isInvalidButtonClick(clickType, button = wrapper.getButton());
        if (flag) {
            this.dispatch(event, ViolationDocument.builder().description("send invalid button click position").mitigationStrategy(MitigationStrategy.MITIGATE).debugs(Arrays.asList(new Debug<Integer>("ClickType", clickType), new Debug<Integer>("Button", button), new Debug<String>("Container", (String)(wrapper.getWindowId() == this.containerId ? Integer.valueOf(this.containerType) : "Empty")))).build());
        }
    }

    private boolean isInvalidButtonClick(int clickType, int button) {
        switch (clickType) {
            case 0: 
            case 1: 
            case 4: {
                return button != 0 && button != 1;
            }
            case 2: {
                return (button > 8 || button < 0) && button != 40;
            }
            case 3: {
                return button != 2;
            }
            case 5: {
                return button == 3 || button == 7 || button > 10 || button < 0;
            }
            case 6: {
                return button != 0;
            }
        }
        return false;
    }

    private void checkForInvalidShulker(PacketReceiveEvent event, ItemStack itemStack) {
        String string;
        int length;
        if (itemStack == null || itemStack.getNBT() == null) {
            return;
        }
        if (this.isShulkerBox(itemStack) && (length = (string = FormatUtils.mapToString(itemStack.getNBT().getTags())).getBytes(StandardCharsets.UTF_8).length) > 10000) {
            this.dispatch(event, ViolationDocument.builder().description("send to big shulker box").mitigationStrategy(MitigationStrategy.KICK).debugs(Arrays.asList(new Debug<Integer>("Size", length), new Debug<Integer>("Max", 10000))).build());
        }
    }

    private boolean isShulkerBox(ItemStack itemStack) {
        try {
            ShulkerBoxType.valueOf(itemStack.getType().toString());
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private void checkForInvalidContainer(PacketReceiveEvent event, ItemStack itemStack) {
        if (this.isContainerItem(itemStack)) {
            String string = FormatUtils.mapToString(itemStack.getNBT().getTags());
            this.checkForInvalidSizeAndPresence(event, string);
        }
    }

    private boolean isContainerItem(ItemStack itemStack) {
        return itemStack.getType() == ItemTypes.CHEST || itemStack.getType() == ItemTypes.HOPPER || itemStack.getType() == ItemTypes.HOPPER_MINECART || itemStack.getType() == ItemTypes.CHEST_MINECART;
    }

    private void checkForInvalidSizeAndPresence(PacketReceiveEvent event, String string) {
        if (string.getBytes(StandardCharsets.UTF_8).length > 262144) {
            this.dispatch(event, ViolationDocument.builder().description("send to big container").mitigationStrategy(MitigationStrategy.KICK).debugs(Arrays.asList(new Debug<Integer>("Size", string.getBytes(StandardCharsets.UTF_8).length), new Debug<Integer>("Max", 262144))).build());
        }
        if (string.contains(WURSTCLIENT_URL)) {
            this.dispatch(event, ViolationDocument.builder().description("send invalid container").mitigationStrategy(MitigationStrategy.BAN).debugs(Collections.singletonList(new Debug<String>("Tag", "WurstClient"))).build());
        }
    }

    private void checkNbtTags(PacketReceiveEvent event, ItemStack itemStack) {
        if (itemStack.getNBT() != null) {
            itemStack.getNBT().getTags().forEach((s, nbt) -> {
                NBTType<?> nbtType = nbt.getType();
                if (nbtType.equals(NBTType.LIST)) {
                    this.checkList((String)s, event, itemStack);
                } else if (nbtType.equals(NBTType.INT_ARRAY)) {
                    this.checkIntArray((String)s, event, itemStack);
                } else if (nbtType.equals(NBTType.LONG_ARRAY)) {
                    this.checkLongArray((String)s, event, itemStack);
                } else if (nbtType.equals(NBTType.BYTE_ARRAY)) {
                    this.checkByteArray((String)s, event, itemStack);
                }
            });
        }
        this.listContent.set(0);
    }

    private void checkList(String s, PacketReceiveEvent event, ItemStack itemStack) {
        NBTList<NBTCompound> tagOrNull = itemStack.getNBT().getCompoundListTagOrNull(s);
        if (tagOrNull != null) {
            if (tagOrNull.getTags().size() > 50) {
                this.dispatch(event, ViolationDocument.builder().description("send invalid nbt list size").mitigationStrategy(MitigationStrategy.KICK).debugs(Arrays.asList(new Debug<Integer>("Size", tagOrNull.getTags().size()), new Debug<Integer>("Max", 50))).build());
            }
            for (NBTCompound tag : tagOrNull.getTags()) {
                if (tag != null && !tag.toString().equalsIgnoreCase("null") && tag.toString().length() <= 900) continue;
                this.dispatch(event, ViolationDocument.builder().description("send invalid nbt list").mitigationStrategy(MitigationStrategy.KICK).debugs(Arrays.asList(new Debug<Integer>("Size", tagOrNull.getTags().size()), new Debug<String>("Tag", "Null/Length"))).build());
            }
        }
        if (this.listContent.incrementAndGet() > 10) {
            this.dispatch(event, ViolationDocument.builder().description("send too many invalid nbt list").mitigationStrategy(MitigationStrategy.KICK).debugs(Collections.singletonList(new Debug<Integer>("Content", this.listContent.get()))).build());
        }
    }

    private void checkIntArray(String key, PacketReceiveEvent event, ItemStack itemStack) {
        NBTList<NBTIntArray> tagListOfTypeOrNull = itemStack.getNBT().getTagListOfTypeOrNull(key, NBTIntArray.class);
        if (tagListOfTypeOrNull != null) {
            if (tagListOfTypeOrNull.size() > 50) {
                this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send invalid int array").debugs(Collections.singletonList(new Debug<String>("Tag", "Size"))).build());
            }
            for (NBTIntArray tag : tagListOfTypeOrNull.getTags()) {
                if (tag.getValue().length > 150) {
                    this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send invalid int array").debugs(Collections.singletonList(new Debug<String>("Tag", "Length"))).build());
                }
                for (int i : tag.getValue()) {
                    if (i != Integer.MAX_VALUE && i != Integer.MIN_VALUE) continue;
                    this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send invalid int array").debugs(Collections.singletonList(new Debug<String>("Tag", "MAX"))).build());
                }
            }
        }
    }

    private void checkLongArray(String key, PacketReceiveEvent event, ItemStack itemStack) {
        NBTList<NBTLongArray> tagListOfTypeOrNull = itemStack.getNBT().getTagListOfTypeOrNull(key, NBTLongArray.class);
        if (tagListOfTypeOrNull != null) {
            if (tagListOfTypeOrNull.size() > 50) {
                this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send invalid long array").debugs(Collections.singletonList(new Debug<String>("Tag", "Size"))).build());
            }
            for (NBTLongArray tag : tagListOfTypeOrNull.getTags()) {
                if (tag.getValue().length > 150) {
                    this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send invalid long array").debugs(Collections.singletonList(new Debug<String>("Tag", "Length"))).build());
                }
                for (long i : tag.getValue()) {
                    if (i != Long.MAX_VALUE && i != Long.MIN_VALUE) continue;
                    this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send invalid long array").debugs(Collections.singletonList(new Debug<String>("Tag", "Max"))).build());
                }
            }
        }
    }

    private void checkByteArray(String key, PacketReceiveEvent event, ItemStack itemStack) {
        NBTList<NBTByteArray> tagListOfTypeOrNull = itemStack.getNBT().getTagListOfTypeOrNull(key, NBTByteArray.class);
        if (tagListOfTypeOrNull != null) {
            if (tagListOfTypeOrNull.size() > 50) {
                this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send invalid byte array").debugs(Collections.singletonList(new Debug<String>("Tag", "Size"))).build());
            }
            for (NBTByteArray tag : tagListOfTypeOrNull.getTags()) {
                if (tag.getValue().length > 150) {
                    this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send invalid byte array").debugs(Collections.singletonList(new Debug<String>("Tag", "Length"))).build());
                }
                for (byte i : tag.getValue()) {
                    if (i != 127 && i != -128) continue;
                    this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send invalid byte array").debugs(Collections.singletonList(new Debug<String>("Tag", "Max"))).build());
                }
            }
        }
    }

    private void checkForInvalidArmorStand(PacketReceiveEvent event, ItemStack itemStack) {
        if (itemStack.getType() != ItemTypes.ARMOR_STAND || itemStack.getNBT() == null) {
            return;
        }
        NBTCompound entityTag = itemStack.getNBT().getCompoundTagOrNull("EntityTag");
        if (entityTag == null) {
            return;
        }
        this.checkInvalidPoses(event, entityTag);
        this.checkInvalidCustomName(event, entityTag);
        this.checkInvalidSkullOwner(event, entityTag);
        this.checkInvalidRotation(event, entityTag);
    }

    private void checkInvalidPoses(PacketReceiveEvent event, NBTCompound entityTag) {
        NBTCompound pose = entityTag.getCompoundTagOrNull("Pose");
        if (pose != null) {
            this.invalidPoseAngles(event, pose, "Head");
            this.invalidPoseAngles(event, pose, "Body");
            this.invalidPoseAngles(event, pose, "LeftArm");
            this.invalidPoseAngles(event, pose, "RightArm");
            this.invalidPoseAngles(event, pose, "LeftLeg");
            this.invalidPoseAngles(event, pose, "RightLeg");
        }
    }

    private void checkInvalidCustomName(PacketReceiveEvent event, NBTCompound entityTag) {
        NBTString customName = entityTag.getStringTagOrNull("CustomName");
        if (customName != null && customName.getValue().length() > 70) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.MITIGATE).description("send invalid armor stand name").debugs(Collections.singletonList(new Debug<Integer>("Length", customName.getValue().length()))).build());
        }
    }

    private void checkInvalidSkullOwner(PacketReceiveEvent event, NBTCompound entityTag) {
        NBTList<NBTCompound> equipment = entityTag.getCompoundListTagOrNull("Equipment");
        if (equipment != null) {
            for (NBTCompound tag : equipment.getTags()) {
                this.checkSkullOwner(event, tag);
            }
        }
    }

    private void checkInvalidRotation(PacketReceiveEvent event, NBTCompound entityTag) {
        NBTList<NBTNumber> rotation = entityTag.getNumberListTagOrNull("Rotation");
        if (rotation != null) {
            for (NBTNumber tag : rotation.getTags()) {
                float armorStandRotation = tag.getAsFloat();
                if (!(armorStandRotation < 0.0f) && !(armorStandRotation > 360.0f)) continue;
                this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send invalid armor stand rotation").debugs(Collections.singletonList(new Debug<Float>("Rotation", Float.valueOf(armorStandRotation)))).build());
            }
        }
    }

    private void checkSkullOwner(PacketReceiveEvent event, NBTCompound item) {
        String name;
        NBTString skullOwner;
        NBTCompound tag;
        if ("skull".equals(item.getStringTagValueOrNull("id")) && (tag = item.getCompoundTagOrNull("tag")) != null && (skullOwner = tag.getStringTagOrNull("SkullOwner")) != null && ((name = skullOwner.getValue()).length() < 3 || name.length() > 16 || !name.matches("^[a-zA-Z0-9_\\-.]{3,16}$"))) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send invalid skull name").debugs(Collections.singletonList(new Debug<String>("Name", name))).build());
        }
    }

    private void invalidPoseAngles(PacketReceiveEvent event, NBTCompound pose, String limb) {
        NBTList<NBTNumber> angles = pose.getTagListOfTypeOrNull(limb, NBTNumber.class);
        if (angles != null) {
            for (NBTNumber tag : angles.getTags()) {
                double value = tag.getAsDouble();
                if (!(value < -360.0) && !(value > 360.0)) continue;
                this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send invalid armor stand limb rotation").debugs(Arrays.asList(new Debug<Double>("Rotation", value), new Debug<String>("Limb", limb))).build());
            }
        }
    }

    private void checkForInvalidBanner(PacketReceiveEvent event, ItemStack itemStack) {
        if (!this.isBanner(itemStack) || itemStack.getNBT() == null) {
            return;
        }
        NBTCompound blockEntityTag = itemStack.getNBT().getCompoundTagOrNull("BlockEntityTag");
        if (blockEntityTag == null) {
            return;
        }
        NBTList<NBTCompound> tagOrNull = blockEntityTag.getCompoundListTagOrNull("Patterns");
        if (tagOrNull == null) {
            return;
        }
        List<NBTCompound> tags = tagOrNull.getTags();
        if (tags.size() > 15) {
            this.dispatch(event, ViolationDocument.builder().description("send invalid banner layers").mitigationStrategy(MitigationStrategy.MITIGATE).debugs(Arrays.asList(new Debug<Integer>("Size", tags.size()), new Debug<Integer>("Max", 15))).build());
            return;
        }
        for (NBTCompound tag : tags) {
            this.validatePattern(event, tag.getStringTagOrNull("Pattern"));
            this.validateColor(event, tag.getNumberTagOrNull("Color"));
        }
    }

    private void validatePattern(PacketReceiveEvent event, NBTString pattern) {
        if (pattern == null || pattern.getValue() == null) {
            this.dispatch(event, ViolationDocument.builder().description("send invalid banner pattern").mitigationStrategy(MitigationStrategy.MITIGATE).debugs(Collections.singletonList(new Debug<String>("Tag", "Null"))).build());
            return;
        }
        if (pattern.getValue().length() > 50) {
            this.dispatch(event, ViolationDocument.builder().description("send invalid banner pattern length").mitigationStrategy(MitigationStrategy.MITIGATE).debugs(Arrays.asList(new Debug<Integer>("Length", pattern.getValue().length()), new Debug<Integer>("Max", 50))).build());
        }
    }

    private void validateColor(PacketReceiveEvent event, NBTNumber color) {
        if (color == null) {
            this.dispatch(event, ViolationDocument.builder().description("send invalid banner color").mitigationStrategy(MitigationStrategy.MITIGATE).debugs(Collections.singletonList(new Debug<String>("Tag", "null"))).build());
            return;
        }
        try {
            int rgb = color.getAsInt();
            if (rgb < 0 || rgb > 255) {
                this.dispatch(event, ViolationDocument.builder().description("send invalid banner color").mitigationStrategy(MitigationStrategy.MITIGATE).debugs(Collections.singletonList(new Debug<Integer>("Color", rgb))).build());
            }
        }
        catch (Exception exception) {
            this.dispatch(event, ViolationDocument.builder().description("send invalid banner color").mitigationStrategy(MitigationStrategy.MITIGATE).debugs(Collections.singletonList(new Debug<String>("Exception", exception.getMessage()))).build());
        }
    }

    private boolean isBanner(ItemStack itemStack) {
        try {
            BannerType.valueOf(itemStack.getType().toString());
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public void handle(PacketSendEvent event, PlayerData playerData) {
        if (!this.configEngine().config().getBoolean("prevent-protocol-packet", true)) {
            return;
        }
        if (event.getPacketType() == PacketType.Play.Server.SET_EXPERIENCE) {
            WrapperPlayServerSetExperience wrapper = CastUtil.getSupplier(() -> new WrapperPlayServerSetExperience(event), playerData::exceptionDisconnect);
            this.checkSetExperience(wrapper, event);
        } else if (event.getPacketType() == PacketType.Play.Server.WINDOW_ITEMS) {
            WrapperPlayServerWindowItems wrapper = CastUtil.getSupplier(() -> new WrapperPlayServerWindowItems(event), playerData::exceptionDisconnect);
            this.checkWindowItems(wrapper, event);
        } else if (event.getPacketType() == PacketType.Play.Server.OPEN_WINDOW) {
            WrapperPlayServerOpenWindow window = CastUtil.getSupplier(() -> new WrapperPlayServerOpenWindow(event), playerData::exceptionDisconnect);
            this.checkOpenWindow(window);
        }
    }

    private void checkSetExperience(WrapperPlayServerSetExperience wrapper, PacketSendEvent event) {
        boolean skipNegativeCheck;
        boolean isLevelNegative = wrapper.getLevel() < 0;
        boolean totalExperienceNegative = wrapper.getTotalExperience() < 0;
        YamlConfiguration configEngine = Sierra.getPlugin().getSierraConfigEngine().config();
        boolean skipNegativeExperienceCheck = configEngine.getBoolean("skip-negative-experience-check", false);
        boolean bl = skipNegativeCheck = wrapper.getExperienceBar() < 0.0f && !skipNegativeExperienceCheck;
        if (isLevelNegative || skipNegativeCheck || totalExperienceNegative) {
            this.dispatch(event, ViolationDocument.builder().description("send invalid experience request").mitigationStrategy(MitigationStrategy.KICK).debugs(Arrays.asList(new Debug<Integer>("Level", wrapper.getLevel()), new Debug<Float>("Experience Bar", Float.valueOf(wrapper.getExperienceBar())), new Debug<Integer>("Total", wrapper.getTotalExperience()))).build());
        }
    }

    private void checkWindowItems(WrapperPlayServerWindowItems wrapper, PacketSendEvent event) {
        for (ItemStack item : wrapper.getItems()) {
            if (item.getNBT() == null) continue;
            this.checkAttributes(event, item);
        }
    }

    private void checkOpenWindow(WrapperPlayServerOpenWindow window) {
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_14)) {
            if (window.getType() == MenuType.ANVIL.getId()) {
                this.hasOpenAnvil = true;
            }
        } else if (window.getLegacyType().contains("anvil")) {
            this.hasOpenAnvil = true;
        }
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_14)) {
            this.type = MenuType.getMenuType(window.getType());
            if (this.type == MenuType.LECTERN) {
                this.lecternId = window.getContainerId();
            }
        }
        this.containerType = window.getType();
        this.containerId = window.getContainerId();
    }

    private void checkItemStackTag(PacketReceiveEvent event, ItemStack itemStack) {
        int encodedLength;
        if (itemStack == null || itemStack.getNBT() == null) {
            return;
        }
        ItemType itemStackType = itemStack.getType();
        NBTCompound compound = itemStack.getNBT();
        String formattedTags = FormatUtils.mapToString(compound.getTags());
        if (itemStackType == ItemTypes.WRITTEN_BOOK || itemStackType == ItemTypes.WRITABLE_BOOK) {
            String title;
            String author;
            if (compound.getStringTagOrNull("author") != null && (author = compound.getStringTagOrNull("author").getValue()).length() > 20) {
                this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.KICK).description("send tag with invalid author").debugs(Arrays.asList(new Debug<String>("Author", author), new Debug<Integer>("Length", author.length()))).build());
            }
            if (compound.getStringTagOrNull("title") != null && (title = compound.getStringTagOrNull("title").getValue()).length() > 32) {
                this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.MITIGATE).description("send tag with invalid title").debugs(Arrays.asList(new Debug<String>("Title", title), new Debug<Integer>("Length", title.length()))).build());
            }
            if (formattedTags.contains(":[{extra:[{")) {
                this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.MITIGATE).description("send tag with invalid extra").debugs(Arrays.asList(new Debug<String>("Tag", "Extra"), new Debug<String>("Extra", "Array"))).build());
            }
        }
        if (itemStackType == ItemTypes.FIREWORK_ROCKET && formattedTags.length() > 300) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.MITIGATE).description("send firework-tag with invalid length").debugs(Collections.singletonList(new Debug<Integer>("Length", formattedTags.length()))).build());
        }
        if (itemStackType == ItemTypes.FIREWORK_STAR && formattedTags.length() > 800) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.MITIGATE).description("send firework-tag with invalid length").debugs(Arrays.asList(new Debug<Integer>("Length", formattedTags.length()), new Debug<String>("Tag", "Star"))).build());
        }
        if (itemStackType != ItemTypes.CHEST && itemStackType != ItemTypes.HOPPER && !this.isShulkerBox(itemStack) && (encodedLength = formattedTags.getBytes(StandardCharsets.UTF_8).length) > 10000) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.MITIGATE).description("send tag with invalid encoded-length").debugs(Collections.singletonList(new Debug<Integer>("Length", encodedLength))).build());
        }
        AtomicInteger listAmount = new AtomicInteger(0);
        compound.getTags().forEach((s, nbt) -> {
            if (compound.getTagListOfTypeOrNull((String)s, nbt.getType().getNBTClass()) != null) {
                int size;
                NBTList<?> list = compound.getTagListOfTypeOrNull((String)s, nbt.getType().getNBTClass());
                listAmount.set(listAmount.get() + 1);
                if (listAmount.get() > 10) {
                    this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.MITIGATE).description("send tag with too many lists").debugs(Collections.singletonList(new Debug<Integer>("Lists", listAmount.get()))).build());
                }
                if ((size = list.size()) > 20) {
                    this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.MITIGATE).description("send tag with big list").debugs(Arrays.asList(new Debug<Integer>("Size", size), new Debug<String>("Tag", (String)s))).build());
                    compound.removeTag((String)s);
                }
                for (int i = 0; i < list.size(); ++i) {
                    String content = String.valueOf(list.getTag(i));
                    if (content == null || content.equalsIgnoreCase("null")) {
                        this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.MITIGATE).description("send tag with invalid list content").debugs(Arrays.asList(new Debug<Integer>("Size", size), new Debug<String>("Tag", (String)s), new Debug<Integer>("Index", i))).build());
                    }
                    if (content.length() <= 90) continue;
                    this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.MITIGATE).description("send tag with invalid list content").debugs(Arrays.asList(new Debug<Integer>("Size", size), new Debug<String>("Tag", (String)s), new Debug<Integer>("Index", i), new Debug<Integer>("Content", content.length()))).build());
                }
            }
        });
        if (compound.getTags().size() > 20) {
            this.dispatch(event, ViolationDocument.builder().mitigationStrategy(MitigationStrategy.MITIGATE).description("send tag with too many keys").debugs(Collections.singletonList(new Debug<Integer>("Tags", compound.getTags().size()))).build());
        }
    }

    private void checkInvalidClick(WrapperPlayClientClickWindow wrapper, PacketReceiveEvent event) {
        int clickType = wrapper.getWindowClickType().ordinal();
        int button = wrapper.getButton();
        int windowId = wrapper.getWindowId();
        int slot = wrapper.getSlot();
        if (button < 0 || windowId < 0) {
            this.dispatch(event, ViolationDocument.builder().description("send invalid window click").mitigationStrategy(MitigationStrategy.KICK).debugs(Arrays.asList(new Debug<Integer>("Button", button), new Debug<Integer>("Window", windowId), new Debug<Integer>("Slot", slot))).build());
        }
        if ((clickType == 1 || clickType == 2) && windowId >= 0 && button < 0) {
            this.dispatch(event, ViolationDocument.builder().description("send invalid window click").mitigationStrategy(MitigationStrategy.KICK).debugs(Arrays.asList(new Debug<Integer>("Button", button), new Debug<Integer>("Window", windowId), new Debug<Integer>("ClickType", clickType), new Debug<Integer>("Slot", slot))).build());
        } else if (windowId >= 0 && clickType == 2 && slot < 0) {
            this.dispatch(event, ViolationDocument.builder().description("send invalid window click").mitigationStrategy(MitigationStrategy.KICK).debugs(Arrays.asList(new Debug<Integer>("Button", button), new Debug<Integer>("Window", windowId), new Debug<Integer>("ClickType", clickType), new Debug<Integer>("Slot", slot))).build());
        }
    }
}

