/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.command;

import de.feelix.sierra.Sierra;
import de.feelix.sierra.command.CommandHelper;
import de.feelix.sierra.command.api.BukkitAbstractCommand;
import de.feelix.sierra.command.api.SierraArguments;
import de.feelix.sierra.command.api.SierraLabel;
import de.feelix.sierra.command.impl.AlertsCommand;
import de.feelix.sierra.command.impl.HistoryCommand;
import de.feelix.sierra.command.impl.InfoCommand;
import de.feelix.sierra.command.impl.MitigationCommand;
import de.feelix.sierra.command.impl.MonitorCommand;
import de.feelix.sierra.command.impl.ReloadCommand;
import de.feelix.sierra.command.impl.VersionCommand;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.utilities.FormatUtils;
import de.feelix.sierraapi.annotation.NotNull;
import de.feelix.sierraapi.annotation.Nullable;
import de.feelix.sierraapi.commands.ISierraCommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.square.sierra.packetevents.api.PacketEvents;
import net.square.sierra.packetevents.api.protocol.player.User;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;

public class SierraCommand
implements CommandExecutor,
TabExecutor {
    private static final Map<String, ISierraCommand> COMMANDS = new HashMap<String, ISierraCommand>();
    private static final String MESSAGE_FORMAT = "%s {offset-color}%s\u00a77: \u00a7f%s";
    private static final String MESSAGE_PREFIX = Sierra.PREFIX + " \u00a7fSubcommands \u00a77(/sierra)";

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        User user = PacketEvents.getAPI().getPlayerManager().getUser(player);
        PlayerData playerData = (PlayerData)Sierra.getPlugin().getSierraDataManager().getPlayerData(user).get();
        if (playerData == null || !sender.hasPermission("sierra.command")) {
            this.sendVersionOutputToUser(user);
            return true;
        }
        CompletableFuture.runAsync(() -> this.handleCommandAsync(sender, command, label, args, user, playerData));
        return true;
    }

    private void sendVersionOutputToUser(User user) {
        CommandHelper.sendVersionOutput(user);
    }

    private void handleCommandAsync(CommandSender sender, Command command, String label, String[] args, User user, PlayerData playerData) {
        if (args.length > 0) {
            this.handleWithArg(sender, command, label, args, user, playerData);
        } else {
            this.sendMainCommandSyntax(sender);
        }
    }

    private void handleWithArg(CommandSender sender, Command command, String label, String[] args, User user, PlayerData playerData) {
        ISierraCommand iSierraCommand = COMMANDS.get(args[0]);
        if (iSierraCommand != null) {
            this.processSierraCommand(sender, user, playerData, command, label, args, iSierraCommand);
        } else {
            this.sendMainCommandSyntax(sender);
        }
    }

    private void processSierraCommand(CommandSender sender, User user, PlayerData playerData, Command command, String label, String[] args, ISierraCommand iSierraCommand) {
        if (iSierraCommand.permission() != null && !sender.hasPermission(iSierraCommand.permission())) {
            CommandHelper.sendVersionOutput(user);
            return;
        }
        iSierraCommand.process(user, playerData, new BukkitAbstractCommand(command), new SierraLabel(label), new SierraArguments(args));
    }

    private void sendMainCommandSyntax(CommandSender commandSender) {
        commandSender.sendMessage(MESSAGE_PREFIX);
        HashMap<String, ISierraCommand> sierraCommandList = new HashMap<String, ISierraCommand>();
        COMMANDS.forEach((s, iSierraCommand) -> {
            if (commandSender.hasPermission("sierra.command") && (iSierraCommand.permission() == null || commandSender.hasPermission(iSierraCommand.permission()))) {
                sierraCommandList.put((String)s, (ISierraCommand)iSierraCommand);
            }
        });
        sierraCommandList.forEach((s, iSierraCommand) -> {
            String description = iSierraCommand.description();
            commandSender.sendMessage(String.format(MESSAGE_FORMAT.replace("{offset-color}", Sierra.getPlugin().getSierraConfigEngine().messages().getString("layout.offset-color", "\u00a7b")), Sierra.PREFIX, s, description));
        });
        commandSender.sendMessage(String.format("%s \u00a77Use <tab> so see %s completions", Sierra.PREFIX, FormatUtils.numberToText(sierraCommandList.size())));
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @Nullable String alias, String[] args) {
        if (!command.getName().equalsIgnoreCase("sierra") || !sender.hasPermission("sierra.command")) {
            return null;
        }
        return this.getGeneratedKeys(sender, args);
    }

    private List<String> getGeneratedKeys(CommandSender commandSender, String[] args) {
        ArrayList keys = new ArrayList();
        COMMANDS.forEach((s, iSierraCommand) -> keys.addAll(this.getKeysForCommand((ISierraCommand)iSierraCommand, commandSender, args.length, args)));
        return keys.isEmpty() ? this.getOnlinePlayerNames() : keys;
    }

    private List<String> getKeysForCommand(ISierraCommand iSierraCommand, CommandSender commandSender, int length, String[] args) {
        boolean isEligible = iSierraCommand.permission() == null || commandSender.hasPermission(iSierraCommand.permission());
        return isEligible ? iSierraCommand.fromId(length, args) : Collections.emptyList();
    }

    private List<String> getOnlinePlayerNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            list.add(player.getName());
        }
        return list;
    }

    static {
        COMMANDS.put("reload", new ReloadCommand());
        COMMANDS.put("alerts", new AlertsCommand());
        COMMANDS.put("mitigation", new MitigationCommand());
        COMMANDS.put("info", new InfoCommand());
        COMMANDS.put("version", new VersionCommand());
        COMMANDS.put("monitor", new MonitorCommand());
        COMMANDS.put("history", new HistoryCommand());
    }
}

