/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.command.impl;

import de.feelix.sierra.utilities.message.ConfigValue;
import de.feelix.sierraapi.commands.IBukkitAbstractCommand;
import de.feelix.sierraapi.commands.ISierraArguments;
import de.feelix.sierraapi.commands.ISierraCommand;
import de.feelix.sierraapi.commands.ISierraLabel;
import de.feelix.sierraapi.user.impl.SierraUser;
import java.util.Collections;
import java.util.List;
import net.square.sierra.packetevents.api.protocol.player.User;

public class AlertsCommand
implements ISierraCommand {
    @Override
    public void process(User user, SierraUser sierraUser, IBukkitAbstractCommand abstractCommand, ISierraLabel sierraLabel, ISierraArguments sierraArguments) {
        this.toggleAlertMessages(user, sierraUser);
    }

    private void toggleAlertMessages(User user, SierraUser sierraUser) {
        if (sierraUser.alertSettings().enabled()) {
            this.sendMessage(user, true);
            sierraUser.alertSettings().toggle(false);
        } else {
            this.sendMessage(user, false);
            sierraUser.alertSettings().toggle(true);
        }
    }

    private void sendMessage(User user, boolean isDisabled) {
        user.sendMessage(new ConfigValue("commands.alerts.toggle", "{prefix} &fYou have {status} &fthe alerts messages", true).replacePrefix().replace("{status}", isDisabled ? "&cdisabled" : "&aenabled").colorize().message());
    }

    @Override
    public List<String> fromId(int id, String[] args) {
        if (id == 1) {
            return Collections.singletonList("alerts");
        }
        return Collections.emptyList();
    }

    @Override
    public String description() {
        return "Toggles the alerts";
    }

    @Override
    public String permission() {
        return "sierra.command.alerts";
    }
}

