/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.command.impl;

import de.feelix.sierra.Sierra;
import de.feelix.sierra.manager.storage.history.HistoryDocument;
import de.feelix.sierra.utilities.FormatUtils;
import de.feelix.sierra.utilities.message.ConfigValue;
import de.feelix.sierra.utilities.pagination.Pagination;
import de.feelix.sierraapi.commands.IBukkitAbstractCommand;
import de.feelix.sierraapi.commands.ISierraArguments;
import de.feelix.sierraapi.commands.ISierraCommand;
import de.feelix.sierraapi.commands.ISierraLabel;
import de.feelix.sierraapi.history.History;
import de.feelix.sierraapi.user.impl.SierraUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.square.sierra.kyori.adventure.text.Component;
import net.square.sierra.kyori.adventure.text.TextComponent;
import net.square.sierra.kyori.adventure.text.event.ClickEvent;
import net.square.sierra.kyori.adventure.text.event.HoverEvent;
import net.square.sierra.packetevents.api.adventure.serializer.legacy.LegacyComponentSerializer;
import net.square.sierra.packetevents.api.protocol.player.User;

public class HistoryCommand
implements ISierraCommand {
    @Override
    public void process(User user, SierraUser sierraUser, IBukkitAbstractCommand abstractCommand, ISierraLabel sierraLabel, ISierraArguments sierraArguments) {
        if (!this.validateArguments(sierraArguments)) {
            this.sendHelpSyntax(user);
            return;
        }
        Pagination<History> pagination = this.setupPagination();
        int page = this.correctPage(FormatUtils.toInt(sierraArguments.getArguments().get(1)), pagination.totalPages());
        List<History> historyDocumentList = pagination.itemsForPage(page);
        this.sendPaginationMessage(user, page, pagination);
        if (historyDocumentList.isEmpty()) {
            user.sendMessage(new ConfigValue("commands.history.empty", "{prefix} &cNo history available", true).replacePrefix().colorize().message());
            return;
        }
        this.sendHistoryMessages(user, historyDocumentList);
    }

    private void sendPaginationMessage(User user, int currentPage, Pagination<History> pagination) {
        boolean hasNextPage = pagination.totalPages() > currentPage;
        boolean hasPreviousPage = currentPage > 1;
        TextComponent component = (TextComponent)((TextComponent)((TextComponent)((TextComponent)LegacyComponentSerializer.legacy('&').deserialize(new ConfigValue("commands.history.header", "{prefix} &fShowing entries: &7(page &b{current} &7of &b{total} &7- &3{entries} &7entries)", true).replacePrefix().replace("{current}", String.valueOf(currentPage)).replace("{total}", String.valueOf(pagination.totalPages())).replace("{entries}", String.valueOf(pagination.getEntries().size())).colorize().message()).append(Component.text(" "))).append(((TextComponent)LegacyComponentSerializer.legacy('&').deserialize(hasPreviousPage ? "\u00a7a\u00ab" : "\u00a77\u00ab").hoverEvent(HoverEvent.showText(Component.text(hasPreviousPage ? "View previous page" : "No previous page available")))).clickEvent(ClickEvent.clickEvent(ClickEvent.Action.RUN_COMMAND, hasPreviousPage ? "/sierra history " + (currentPage - 1) : "/sierra history 1")))).append(Component.text(" "))).append(((TextComponent)LegacyComponentSerializer.legacy('&').deserialize(hasNextPage ? "\u00a7a\u00bb" : "\u00a77\u00bb").hoverEvent(HoverEvent.showText(Component.text(hasNextPage ? "View next page" : "No next page available")))).clickEvent(ClickEvent.clickEvent(ClickEvent.Action.RUN_COMMAND, hasNextPage ? "/sierra history " + (currentPage + 1) : "/sierra history " + currentPage)));
        user.sendMessage(component);
    }

    private void sendHistoryMessages(User user, List<History> historyDocumentList) {
        for (History historyDocument : historyDocumentList) {
            user.sendMessage((Component)LegacyComponentSerializer.legacy('&').deserialize(this.createHistoryMessage((HistoryDocument)historyDocument)).hoverEvent(HoverEvent.showText(Component.text(new ConfigValue("commands.history.hover", "{prefix} &7Info: &b{description}", true).replacePrefix().replace("{description}", historyDocument.description()).colorize().message()))));
        }
    }

    private boolean validateArguments(ISierraArguments sierraArguments) {
        return sierraArguments.getArguments().size() > 1;
    }

    private Pagination<History> setupPagination() {
        ArrayList<History> list = new ArrayList<History>(Sierra.getPlugin().getSierraDataManager().getHistories());
        list.sort(Comparator.comparing(History::timestamp).reversed());
        return new Pagination<History>(list, 5);
    }

    private int correctPage(int page, int totalPages) {
        if (page > totalPages || page < 0) {
            return 1;
        }
        return page;
    }

    private String createHistoryMessage(HistoryDocument historyDocument) {
        return new ConfigValue("commands.history.entry", "&7{timestamp} &3{username}&8/&b{version} &7({ping}ms) -> &b{mitigationStrategy}", true).replacePrefix().replace("{timestamp}", historyDocument.formatTimestamp()).replace("{username}", historyDocument.username()).replace("{ping}", String.valueOf(historyDocument.ping())).replace("{version}", historyDocument.clientVersion().toLowerCase().replace("v_", "").replace("_", ".")).replace("{mitigationStrategy}", historyDocument.mitigationStrategy().historyMessage()).replace("{description}", historyDocument.shortenDescription()).colorize().message();
    }

    private void sendHelpSyntax(User user) {
        user.sendMessage(new ConfigValue("commands.history.protocol", "{prefix} &cInvalid usage, try /sierra history <page>", true).replacePrefix().colorize().message());
    }

    @Override
    public List<String> fromId(int id, String[] args) {
        if (id == 1) {
            return Collections.singletonList("history");
        }
        if (id == 2 && args[0].equalsIgnoreCase("history")) {
            return Collections.singletonList("1");
        }
        return Collections.emptyList();
    }

    @Override
    public String description() {
        return "History of player`s punishments";
    }

    @Override
    public String permission() {
        return "sierra.command.history";
    }
}

