/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.command.impl;

import de.feelix.sierra.utilities.message.ConfigValue;
import de.feelix.sierraapi.check.impl.SierraCheck;
import de.feelix.sierraapi.commands.IBukkitAbstractCommand;
import de.feelix.sierraapi.commands.ISierraArguments;
import de.feelix.sierraapi.commands.ISierraCommand;
import de.feelix.sierraapi.commands.ISierraLabel;
import de.feelix.sierraapi.user.impl.SierraUser;
import java.util.Collections;
import java.util.List;
import net.square.sierra.packetevents.api.protocol.player.User;

public class InfoCommand
implements ISierraCommand {
    @Override
    public void process(User user, SierraUser sierraUser, IBukkitAbstractCommand abstractCommand, ISierraLabel sierraLabel, ISierraArguments sierraArguments) {
        if (!this.validateArguments(sierraArguments)) {
            this.sendHelpSyntax(user);
            return;
        }
        String playerName = sierraArguments.getArguments().get(1);
        this.sendPlayerInfoMessages(user, playerName, sierraUser);
    }

    private void sendPlayerInfoMessages(User user, String playerName, SierraUser sierraUser) {
        user.sendMessage(new ConfigValue("commands.info.header", "{prefix} &7Information for &b{playerName}&7:", true).replacePrefix().replace("{playerName}", playerName).colorize().message());
        this.sendUserData(user, sierraUser);
        this.sendCheckInformation(user, sierraUser);
    }

    private void sendUserData(User user, SierraUser sierraUser) {
        user.sendMessage(new ConfigValue("commands.info.information", "{prefix} &7Version: &b{clientVersion}{n}{prefix} &7Client: &b{brand}&7/&b{locale}{n}{prefix} &7Ping: &b{ping}ms{n}{prefix} &7Game mode: &b{gameMode}{n}{prefix} &7Ticks existed: &b{ticksExisted}{n}{prefix} &b&lCheck information", true).replacePrefix().replace("{clientVersion}", sierraUser.version()).replace("{brand}", sierraUser.brand()).replace("{locale}", sierraUser.locale()).replace("{ping}", String.valueOf(sierraUser.ping())).replace("{gameMode}", sierraUser.gameMode().name()).replace("{ticksExisted}", sierraUser.ticksExisted() + " ticks").colorize().stripped().message());
    }

    private void sendCheckInformation(User user, SierraUser sierraUser) {
        long count = this.getPlayerDetectionCount(sierraUser);
        if (count == 0L) {
            user.sendMessage(new ConfigValue("commands.info.no-detections", "{prefix} &cNo detections", true).replacePrefix().colorize().message());
            return;
        }
        for (SierraCheck sierraCheck : sierraUser.checkRepository().availableChecks()) {
            if (!(sierraCheck.violations() > 0.0)) continue;
            user.sendMessage(new ConfigValue("commands.info.check-info", "{prefix}  &8- &7{checkType}: &b{violations}", true).replacePrefix().replace("{checkType}", sierraCheck.checkType().getFriendlyName()).replace("{violations}", String.valueOf(sierraCheck.violations())).colorize().message());
        }
    }

    private long getPlayerDetectionCount(SierraUser sierraUser) {
        long count = 0L;
        for (SierraCheck check : sierraUser.checkRepository().availableChecks()) {
            if (!(check.violations() > 0.0)) continue;
            ++count;
        }
        return count;
    }

    private void sendHelpSyntax(User user) {
        user.sendMessage(new ConfigValue("commands.info.protocol", "{prefix} &cInvalid usage, try /sierra info <name>", true).replacePrefix().colorize().message());
    }

    private boolean validateArguments(ISierraArguments sierraArguments) {
        return sierraArguments.getArguments().size() > 1;
    }

    @Override
    public List<String> fromId(int id, String[] args) {
        if (id == 1) {
            return Collections.singletonList("info");
        }
        if (id == 2 && args[0].equalsIgnoreCase("info")) {
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Override
    public String description() {
        return "Get info about player";
    }

    @Override
    public String permission() {
        return "sierra.command.info";
    }
}

