/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.command.impl;

import de.feelix.sierra.Sierra;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.utilities.message.ConfigValue;
import de.feelix.sierraapi.commands.IBukkitAbstractCommand;
import de.feelix.sierraapi.commands.ISierraArguments;
import de.feelix.sierraapi.commands.ISierraCommand;
import de.feelix.sierraapi.commands.ISierraLabel;
import de.feelix.sierraapi.timing.Timing;
import de.feelix.sierraapi.timing.TimingHandler;
import de.feelix.sierraapi.user.impl.SierraUser;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import net.square.sierra.packetevents.api.protocol.player.User;

public class MonitorCommand
implements ISierraCommand {
    @Override
    public void process(User user, SierraUser sierraUser, IBukkitAbstractCommand abstractCommand, ISierraLabel sierraLabel, ISierraArguments sierraArguments) {
        user.sendMessage(new ConfigValue("commands.monitor.header", "{prefix} &fPerformance monitor &7(Your data)", true).replacePrefix().colorize().message());
        WeakReference<PlayerData> playerData = Sierra.getPlugin().getSierraDataManager().getPlayerData(user);
        if (playerData == null || playerData.get() == null) {
            user.sendMessage(new ConfigValue("commands.monitor.nothing-found", "{prefix} &cNo data found!", true).replacePrefix().colorize().message());
            return;
        }
        this.printMonitor(user, sierraUser);
    }

    private void printMonitor(User user, SierraUser sierraUser) {
        TimingHandler timingProcessor = sierraUser.timingHandler();
        user.sendMessage(new ConfigValue("commands.monitor.packets-header", "{prefix} &b&lPackets:", true).replacePrefix().colorize().message());
        this.sendTiming(timingProcessor.getPacketReceiveTask(), "Ingoing Packets", user);
        this.sendTiming(timingProcessor.getPacketSendTask(), "Outgoing Packets", user);
        user.sendMessage(new ConfigValue("commands.monitor.environment-header", "{prefix} &b&lEnvironment:", true).replacePrefix().colorize().message());
        this.sendTiming(timingProcessor.getMovementTask(), "Movement Task", user);
        this.sendTiming(timingProcessor.getFrequencyTask(), "Frequency Task", user);
    }

    private void sendTiming(Timing packetReceiveTiming, String title, User user) {
        user.sendMessage(new ConfigValue("commands.monitor.entry", "{prefix}  &8- &f{title} &7({delay}ms)", true).replacePrefix().replace("{title}", title).replace("{delay}", String.format("%.5f", packetReceiveTiming.delay())).colorize().message());
    }

    @Override
    public List<String> fromId(int id, String[] args) {
        if (id == 1) {
            return Collections.singletonList("monitor");
        }
        return Collections.emptyList();
    }

    @Override
    public String description() {
        return "Performance analysis";
    }

    @Override
    public String permission() {
        return "sierra.command.monitor";
    }
}

