/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.compatibility;

import de.feelix.sierra.Sierra;
import de.feelix.sierra.compatibility.Descriptor;
import de.feelix.sierra.compatibility.impl.BetterRTPDescriptor;
import de.feelix.sierra.compatibility.impl.DeluxeMenusDescriptor;
import de.feelix.sierra.compatibility.impl.FastAsyncWorldEditDescriptor;
import de.feelix.sierra.compatibility.impl.InfiniteParkourDescriptor;
import de.feelix.sierra.compatibility.impl.InsaneAnnouncerDescriptor;
import de.feelix.sierra.compatibility.impl.ProtocolLibDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class CompatibilityHandler {
    private final List<Descriptor> descriptors = new ArrayList<Descriptor>();

    public CompatibilityHandler() {
        this.descriptors.add(new ProtocolLibDescriptor());
        this.descriptors.add(new FastAsyncWorldEditDescriptor());
        this.descriptors.add(new DeluxeMenusDescriptor());
        this.descriptors.add(new BetterRTPDescriptor());
        this.descriptors.add(new InfiniteParkourDescriptor());
        this.descriptors.add(new InsaneAnnouncerDescriptor());
    }

    public void processDescriptors() {
        Sierra.getPlugin().getLogger().info("Looking for compatibility issues...");
        this.descriptors.forEach(this::checkDescriptorAndLogResults);
    }

    private void checkDescriptorAndLogResults(Descriptor descriptor) {
        if (descriptor.compatibilityProblematic()) {
            this.logIssues(descriptor);
            Logger logger = Sierra.getPlugin().getLogger();
            if (descriptor.fixProblems()) {
                logger.info("We were able to fix the error");
            } else {
                logger.severe("The error could not be fixed");
            }
        }
    }

    private void logIssues(Descriptor descriptor) {
        Sierra.getPlugin().getLogger().info("Found a problem with: " + descriptor.pluginName());
        descriptor.knownProblems().forEach(problem -> Sierra.getPlugin().getLogger().info(" - " + problem));
    }
}

