/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.listener;

import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.manager.storage.SierraDataManager;
import de.feelix.sierra.manager.storage.logger.LogTag;
import de.feelix.sierra.utilities.CastUtil;
import de.feelix.sierra.utilities.FormatUtils;
import net.square.sierra.packetevents.api.event.PacketListenerAbstract;
import net.square.sierra.packetevents.api.event.PacketListenerPriority;
import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.event.ProtocolPacketEvent;
import net.square.sierra.packetevents.api.netty.buffer.ByteBufHelper;
import net.square.sierra.packetevents.api.netty.buffer.UnpooledByteBufAllocationHelper;
import net.square.sierra.packetevents.api.protocol.item.ItemStack;
import net.square.sierra.packetevents.api.protocol.packettype.PacketType;
import net.square.sierra.packetevents.api.wrapper.PacketWrapper;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientClickWindow;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientCreativeInventoryAction;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientPlayerBlockPlacement;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientPluginMessage;

public class PacketLoggerListener
extends PacketListenerAbstract {
    public PacketLoggerListener() {
        super(PacketListenerPriority.MONITOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        PlayerData playerData = this.getPlayerData(event);
        if (playerData == null) {
            return;
        }
        if (playerData.isReceivedPunishment() || event.isCancelled() || playerData.isExempt()) {
            return;
        }
        if (event.getPacketType() == PacketType.Play.Client.PLAYER_BLOCK_PLACEMENT) {
            WrapperPlayClientPlayerBlockPlacement wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientPlayerBlockPlacement(event), playerData::exceptionDisconnect);
            wrapper.getItemStack().ifPresent(itemStack -> {
                if (itemStack.getNBT() != null) {
                    playerData.getSierraLogger().log(LogTag.BLOCK_PLACE, FormatUtils.mapToString(itemStack.getNBT().getTags()));
                }
            });
            return;
        } else if (event.getPacketType() == PacketType.Play.Client.PLUGIN_MESSAGE) {
            WrapperPlayClientPluginMessage wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientPluginMessage(event), playerData::exceptionDisconnect);
            String payload = wrapper.getChannelName();
            if (!payload.contains("MC|BEdit") && !payload.contains("MC|BSign") && !payload.contains("MC|BOpen")) return;
            Object buffer = null;
            try {
                buffer = UnpooledByteBufAllocationHelper.buffer();
                ByteBufHelper.writeBytes(buffer, wrapper.getData());
                PacketWrapper<?> universalWrapper = PacketWrapper.createUniversalPacketWrapper(buffer);
                try {
                    ItemStack itemStack2 = universalWrapper.readItemStack();
                    if (itemStack2.getNBT() == null) return;
                    playerData.getSierraLogger().log(LogTag.PAYLOAD, FormatUtils.mapToString(itemStack2.getNBT().getTags()));
                    return;
                }
                catch (Exception exception) {
                    playerData.getSierraLogger().log(LogTag.EXCEP_PAYLOAD, exception.getMessage());
                }
                return;
            }
            finally {
                ByteBufHelper.release(buffer);
            }
        } else if (event.getPacketType() == PacketType.Play.Client.CREATIVE_INVENTORY_ACTION) {
            WrapperPlayClientCreativeInventoryAction wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientCreativeInventoryAction(event), playerData::exceptionDisconnect);
            ItemStack itemStack3 = wrapper.getItemStack();
            if (itemStack3 == null || itemStack3.getNBT() == null) return;
            playerData.getSierraLogger().log(LogTag.CREATIVE, FormatUtils.mapToString(itemStack3.getNBT().getTags()));
            return;
        } else {
            if (event.getPacketType() != PacketType.Play.Client.CLICK_WINDOW) return;
            WrapperPlayClientClickWindow wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientClickWindow(event), playerData::exceptionDisconnect);
            ItemStack itemStack4 = wrapper.getCarriedItemStack();
            if (itemStack4 == null || itemStack4.getNBT() == null) return;
            playerData.getSierraLogger().log(LogTag.WINDOW_CLICK, FormatUtils.mapToString(itemStack4.getNBT().getTags()));
        }
    }

    private PlayerData getPlayerData(ProtocolPacketEvent event) {
        return (PlayerData)SierraDataManager.getInstance().getPlayerData(event.getUser()).get();
    }
}

