/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.listener;

import de.feelix.sierra.Sierra;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.manager.storage.SierraDataManager;
import net.square.sierra.packetevents.api.event.PacketListenerAbstract;
import net.square.sierra.packetevents.api.event.PacketListenerPriority;
import net.square.sierra.packetevents.api.event.PacketSendEvent;
import net.square.sierra.packetevents.api.event.ProtocolPacketEvent;
import net.square.sierra.packetevents.api.protocol.ConnectionState;

public class PacketSendListener
extends PacketListenerAbstract {
    public PacketSendListener() {
        super(PacketListenerPriority.HIGHEST);
    }

    @Override
    public void onPacketSend(PacketSendEvent event) {
        if (event.getConnectionState() != ConnectionState.PLAY) {
            return;
        }
        PlayerData playerData = this.getPlayerData(event);
        if (playerData == null || this.handleExemptOrBlockedPlayer(playerData, event)) {
            return;
        }
        if (this.bypassPermission(playerData)) {
            event.setCancelled(false);
            return;
        }
        playerData.getTimingProcessor().getPacketSendTask().prepare();
        playerData.getTeleportProcessor().handle(event);
        playerData.getTransactionProcessor().handleTransactionSend(event);
        playerData.getGameModeProcessor().process(event);
        playerData.getPingProcessor().handlePacketSend(event);
        playerData.getCheckManager().processAvailableChecksSend(event);
        playerData.getTimingProcessor().getPacketSendTask().end();
    }

    private boolean bypassPermission(PlayerData playerData) {
        return Sierra.getPlugin().getSierraConfigEngine().config().getBoolean("enable-bypass-permission", false) && playerData.isBypassPermission();
    }

    private boolean handleExemptOrBlockedPlayer(PlayerData playerData, ProtocolPacketEvent event) {
        if (playerData.isExempt()) {
            event.setCancelled(false);
            return true;
        }
        if (playerData.isReceivedPunishment()) {
            event.setCancelled(true);
            return true;
        }
        return false;
    }

    private PlayerData getPlayerData(ProtocolPacketEvent event) {
        return (PlayerData)SierraDataManager.getInstance().getPlayerData(event.getUser()).get();
    }
}

