/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.listener.bukkit;

import de.feelix.sierra.Sierra;
import de.feelix.sierra.utilities.BlockEntry;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.square.sierra.google.common.cache.Cache;
import net.square.sierra.google.common.cache.CacheBuilder;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockRedstoneEvent;

public class BlockRedstoneListener
implements Listener {
    private final Cache<Block, BlockEntry> cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build();
    private final int limit = Sierra.getPlugin().getConfig().getInt("redstone-tick-limit", 60);

    @EventHandler
    public void handle(BlockRedstoneEvent event) {
        Block block = event.getBlock();
        BlockEntry detected = this.detectBlock(block);
        if (detected.intValue() > this.limit) {
            event.setNewCurrent(0);
            this.warnAndAdjustValue(detected, block);
        }
    }

    private BlockEntry detectBlock(Block block) {
        BlockEntry detected = this.cache.getIfPresent(block);
        if (detected == null) {
            detected = new BlockEntry(1);
            this.cache.put(block, detected);
        } else {
            detected.add(1);
        }
        return detected;
    }

    private void warnAndAdjustValue(BlockEntry detected, Block block) {
        if (detected.intValue() == this.limit + 1) {
            Logger logger = Sierra.getPlugin().getLogger();
            logger.warning("Prevented redstone loop");
            this.logBlockLocation(block, logger);
            detected.setValue(this.limit + 2);
        }
    }

    private void logBlockLocation(Block block, Logger logger) {
        String format = "At: %.2f, %.2f, %.2f";
        Location location = block.getLocation();
        logger.warning(String.format(format, location.getX(), location.getY(), location.getZ()));
    }
}

