/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.manager.config;

import de.feelix.sierra.Sierra;
import de.feelix.sierra.utilities.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.configuration.file.YamlConfiguration;

public class SierraConfigEngine {
    private static final Map<String, YamlConfiguration> cache = new ConcurrentHashMap<String, YamlConfiguration>();

    public SierraConfigEngine() {
        YamlConfiguration mainConfig = this.config();
        YamlConfiguration messages = this.messages();
    }

    public YamlConfiguration config() {
        return this.getFileFromCache("sierra.yml");
    }

    public YamlConfiguration messages() {
        return this.getFileFromCache("messages.yml");
    }

    private YamlConfiguration getFileFromCache(String name) {
        YamlConfiguration configuration = cache.get(name);
        return configuration != null ? configuration : this.getFileFromName(name);
    }

    private YamlConfiguration getFileFromName(String name) {
        YamlConfiguration yamlConfiguration;
        File sierraFile;
        String pathName = "plugins/Sierra/" + name;
        File sierraFolder = new File("plugins/Sierra/");
        if (!sierraFolder.exists() && !sierraFolder.mkdir()) {
            Sierra.getPlugin().getLogger().severe("Cant create folder!");
        }
        if (!(sierraFile = new File(pathName)).exists()) {
            try {
                if (!sierraFile.createNewFile()) {
                    Sierra.getPlugin().getLogger().severe("Cant create file!");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                FileUtil.saveInputStreamToFile(Objects.requireNonNull(Sierra.getPlugin().getResource(name)), pathName);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            InputStream inputStream = Files.newInputStream(sierraFile.toPath(), new OpenOption[0]);
            InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        cache.put(name, yamlConfiguration);
        return yamlConfiguration;
    }

    public void invalidateCache() {
        cache.clear();
    }
}

