/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.manager.event;

import de.feelix.sierraapi.events.EventBus;
import de.feelix.sierraapi.events.EventSubscriber;
import de.feelix.sierraapi.events.api.SierraAbstractEvent;
import de.feelix.sierraapi.events.priority.ListenerPriority;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class AbstractEventBus
implements EventBus {
    private final Map<Class<?>, List<EventSubscriber<?>>> subscribers = new HashMap();

    @Override
    public <T extends SierraAbstractEvent> void subscribe(Class<T> eventType, Consumer<T> event) {
        this.subscribe(eventType, event, ListenerPriority.DEFAULT);
    }

    @Override
    public <T extends SierraAbstractEvent> void subscribe(Class<T> eventType, Consumer<T> event, ListenerPriority priority) {
        this.subscribers.computeIfAbsent(eventType, k -> new ArrayList()).add(new EventSubscriber<T>(event, priority.getScore()));
    }

    @Override
    public <T extends SierraAbstractEvent> void publish(T event) {
        List<EventSubscriber<?>> eventSubscribers = this.subscribers.get(event.getClass());
        if (eventSubscribers == null) {
            return;
        }
        this.dispatchEventToSubscribers(event, eventSubscribers);
    }

    @Override
    public <T extends SierraAbstractEvent> void dispatchEventToSubscribers(T event, List<EventSubscriber<?>> eventSubscribers) {
        eventSubscribers.sort(Comparator.comparingInt(EventSubscriber::getPriority));
        for (EventSubscriber<?> eventSubscriber : eventSubscribers) {
            eventSubscriber.getConsumer().accept(event);
        }
    }
}

