/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.manager.init;

import de.feelix.sierra.manager.init.Initable;
import de.feelix.sierra.manager.init.impl.load.InitPacketEvents;
import de.feelix.sierra.manager.init.impl.start.InitBStats;
import de.feelix.sierra.manager.init.impl.start.InitCommand;
import de.feelix.sierra.manager.init.impl.start.InitEnvironment;
import de.feelix.sierra.manager.init.impl.start.InitPacketListeners;
import de.feelix.sierra.manager.init.impl.start.InitUpdateChecker;
import de.feelix.sierra.manager.init.impl.start.Ticker;
import de.feelix.sierra.manager.init.impl.stop.DisablePacketEvents;
import java.util.ArrayList;
import java.util.List;

public class InitManager {
    private final List<Initable> initializersOnLoad = new ArrayList<Initable>();
    private final List<Initable> initializersOnStart = new ArrayList<Initable>();
    private final List<Initable> initializersOnStop = new ArrayList<Initable>();

    public InitManager() {
        this.initializersOnLoad.add(new InitPacketEvents());
        this.initializersOnStart.add(new InitPacketListeners());
        this.initializersOnStart.add(new InitBStats());
        this.initializersOnStart.add(new InitCommand());
        this.initializersOnStart.add(new Ticker());
        this.initializersOnStart.add(new InitEnvironment());
        this.initializersOnStart.add(new InitUpdateChecker());
        this.initializersOnStop.add(new DisablePacketEvents());
    }

    public void load() {
        for (Initable initable : this.initializersOnLoad) {
            initable.start();
        }
    }

    public void start() {
        for (Initable initable : this.initializersOnStart) {
            initable.start();
        }
    }

    public void stop() {
        for (Initable initable : this.initializersOnStop) {
            initable.start();
        }
    }
}

