/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.manager.init.impl.start;

import de.feelix.sierra.Sierra;
import de.feelix.sierra.manager.init.Initable;
import java.util.logging.Logger;
import net.square.sierra.packetevents.api.util.folia.FoliaScheduler;
import org.bukkit.plugin.Plugin;

public class InitUpdateChecker
implements Initable {
    @Override
    public void start() {
        FoliaScheduler.getAsyncScheduler().runNow((Plugin)Sierra.getPlugin(), o -> {
            Sierra.getPlugin().getUpdateChecker().refreshNewVersion();
            this.checkForUpdate();
            Sierra.getPlugin().getUpdateChecker().startScheduler();
        });
    }

    private void checkForUpdate() {
        FoliaScheduler.getAsyncScheduler().runNow((Plugin)Sierra.getPlugin(), o -> {
            String latestReleaseVersion;
            String localVersion = Sierra.getPlugin().getDescription().getVersion();
            if (!localVersion.equalsIgnoreCase(latestReleaseVersion = Sierra.getPlugin().getUpdateChecker().getLatestReleaseVersion()) && !this.isVersionInvalid()) {
                this.logOutdatedVersionMessage(localVersion, latestReleaseVersion);
            }
        });
    }

    private void logOutdatedVersionMessage(String localVersion, String latestReleaseVersion) {
        Logger logger = Sierra.getPlugin().getLogger();
        logger.warning("You are using an outdated version of Sierra!");
        logger.warning("Please update Sierra to the latest version!");
        String format = "Your version: %s, latest is: %s";
        logger.warning(String.format(format, localVersion, latestReleaseVersion));
    }

    private boolean isVersionInvalid() {
        return Sierra.getPlugin().getUpdateChecker().getLatestReleaseVersion().equalsIgnoreCase("UNKNOWN");
    }
}

