/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.manager.init.impl.start;

import de.feelix.sierra.Sierra;
import de.feelix.sierra.manager.init.Initable;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.manager.storage.SierraDataManager;
import de.feelix.sierraapi.check.impl.SierraCheck;
import lombok.Generated;
import net.square.sierra.packetevents.api.protocol.player.GameMode;
import net.square.sierra.packetevents.api.util.folia.FoliaScheduler;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Ticker
implements Initable {
    private static Ticker instance;
    private int currentTick;

    @Override
    public void start() {
        instance = this;
        this.scheduleTickTask();
        this.scheduleByteResetTask();
        this.schedulePlayerDataPollTask();
    }

    private void scheduleTickTask() {
        FoliaScheduler.getAsyncScheduler().runAtFixedRate((Plugin)Sierra.getPlugin(), o -> ++this.currentTick, 1L, 1L);
    }

    private void scheduleByteResetTask() {
        FoliaScheduler.getAsyncScheduler().runAtFixedRate((Plugin)Sierra.getPlugin(), o -> {
            for (PlayerData value : SierraDataManager.getInstance().getPlayerData().values()) {
                value.setBytesSent(0.0);
            }
        }, 0L, 20L);
    }

    private void schedulePlayerDataPollTask() {
        FoliaScheduler.getAsyncScheduler().runAtFixedRate((Plugin)Sierra.getPlugin(), o -> {
            for (PlayerData value : SierraDataManager.getInstance().getPlayerData().values()) {
                Player player;
                if (this.isUserValid(value) && (player = Bukkit.getPlayer((String)value.getUser().getName())) != null) {
                    value.setGameMode(GameMode.valueOf(player.getGameMode().name()));
                    value.pollData(player);
                }
                this.handleCheckViolations(value);
            }
        }, 0L, 1L);
    }

    private boolean isUserValid(PlayerData playerData) {
        return playerData.getUser() != null && playerData.getUser().getName() != null;
    }

    private void handleCheckViolations(PlayerData playerData) {
        for (SierraCheck sierraCheck : playerData.getCheckManager().availableChecks()) {
            boolean timeSinceLastDetection;
            boolean bl = timeSinceLastDetection = System.currentTimeMillis() - sierraCheck.lastDetection() > 4000L;
            if (!(sierraCheck.violations() > 0.0) || !timeSinceLastDetection) continue;
            sierraCheck.setViolations(sierraCheck.violations() - 1.0);
        }
    }

    @Generated
    public int getCurrentTick() {
        return this.currentTick;
    }

    @Generated
    public static Ticker getInstance() {
        return instance;
    }
}

