/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.manager.storage;

import de.feelix.sierra.Sierra;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

public class AddressStorage {
    private final Map<String, LocalDateTime> ipAddresses = new HashMap<String, LocalDateTime>();

    public void addIPAddress(String ipAddress) {
        if (ipAddress.equalsIgnoreCase("127.0.0.1")) {
            return;
        }
        this.ipAddresses.put(ipAddress, LocalDateTime.now());
    }

    public boolean invalid(String ipAddress) {
        LocalDateTime addedTime = this.ipAddresses.get(ipAddress);
        if (addedTime == null) {
            return false;
        }
        if (this.isOlderThanFifteenMinutes(addedTime)) {
            this.removeIPAddress(ipAddress);
            return false;
        }
        return true;
    }

    private boolean isOlderThanFifteenMinutes(LocalDateTime addedTime) {
        Duration duration = Duration.between(addedTime, LocalDateTime.now());
        return duration.toMinutes() > (long)Sierra.getPlugin().getSierraConfigEngine().config().getInt("connection-block-time", 15);
    }

    private void removeIPAddress(String ipAddress) {
        this.ipAddresses.remove(ipAddress);
    }
}

