/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.manager.storage;

import de.feelix.sierra.Sierra;
import de.feelix.sierra.check.CheckManager;
import de.feelix.sierra.manager.storage.SierraDataManager;
import de.feelix.sierra.manager.storage.alert.AbstractAlertSetting;
import de.feelix.sierra.manager.storage.logger.SierraLogger;
import de.feelix.sierra.manager.storage.processor.BrandProcessor;
import de.feelix.sierra.manager.storage.processor.GameModeProcessor;
import de.feelix.sierra.manager.storage.processor.PingProcessor;
import de.feelix.sierra.manager.storage.processor.TeleportProcessor;
import de.feelix.sierra.manager.storage.processor.TimingProcessor;
import de.feelix.sierra.manager.storage.processor.TransactionProcessor;
import de.feelix.sierra.utilities.FormatUtils;
import de.feelix.sierra.utilities.message.ConfigValue;
import de.feelix.sierraapi.check.CheckRepository;
import de.feelix.sierraapi.timing.TimingHandler;
import de.feelix.sierraapi.user.impl.SierraUser;
import de.feelix.sierraapi.user.settings.AlertSettings;
import de.feelix.sierraapi.violation.MitigationStrategy;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import net.square.sierra.packetevents.api.event.ProtocolPacketEvent;
import net.square.sierra.packetevents.api.protocol.player.ClientVersion;
import net.square.sierra.packetevents.api.protocol.player.GameMode;
import net.square.sierra.packetevents.api.protocol.player.User;
import net.square.sierra.packetevents.api.protocol.world.Location;
import net.square.sierra.packetevents.api.util.folia.FoliaScheduler;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlayerData
implements SierraUser {
    private Object bukkitPlayer;
    private User user;
    private GameMode gameMode;
    private Location lastLocation;
    private ClientVersion clientVersion;
    private String brand = "vanilla";
    private String locale = "unset";
    private final Set<String> channels = new HashSet<String>();
    private final long joinTime = System.currentTimeMillis();
    private boolean receivedPunishment = false;
    private boolean exempt = false;
    private boolean nameChecked = false;
    private boolean bypassPermission = false;
    private double bytesSent = 0.0;
    private final AlertSettings alertSettings = new AbstractAlertSetting();
    private final AlertSettings mitigationSettings = new AbstractAlertSetting();
    private SierraLogger sierraLogger;
    private final CheckManager checkManager = new CheckManager(this);
    private final BrandProcessor brandProcessor = new BrandProcessor(this);
    private final GameModeProcessor gameModeProcessor = new GameModeProcessor(this);
    private final PingProcessor pingProcessor = new PingProcessor(this);
    private final TeleportProcessor teleportProcessor = new TeleportProcessor(this);
    private final TransactionProcessor transactionProcessor = new TransactionProcessor(this);
    private final TimingHandler timingProcessor = new TimingProcessor(this);

    public PlayerData(User user) {
        this.user = user;
        this.clientVersion = user.getClientVersion();
        this.sierraLogger = new SierraLogger("INVALID");
    }

    public void pollData(Player bukkitPlayer) {
        this.bukkitPlayer = bukkitPlayer;
        this.bypassPermission = bukkitPlayer.hasPermission("sierra.bypass");
        if (this.sierraLogger.getPlayerName().equalsIgnoreCase("INVALID")) {
            this.sierraLogger.close();
            this.sierraLogger = new SierraLogger(bukkitPlayer.getName());
        }
        this.sendTransaction();
    }

    public void sendTransaction() {
        this.transactionProcessor.sendTransaction(true);
    }

    public void exceptionDisconnect(Exception exception) {
        if (this.receivedPunishment) {
            return;
        }
        Sierra.getPlugin().getLogger().warning("We disconnect " + this.username() + " for security purpose");
        Sierra.getPlugin().getLogger().warning("Exception: " + exception.getMessage());
        this.punish(MitigationStrategy.KICK);
    }

    public void punish(MitigationStrategy mitigationStrategy) {
        this.setReceivedPunishment(true);
        if (mitigationStrategy == MitigationStrategy.BAN && Sierra.getPlugin().getPunishmentConfig().isBan()) {
            this.ban();
        }
        this.kick();
    }

    private void ban() {
        SierraDataManager.increaseBanValue();
        FoliaScheduler.getGlobalRegionScheduler().run((Plugin)Sierra.getPlugin(), o -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)new ConfigValue("punish-command", "ban {username} Crashing", false).replace("{username}", this.user.getName()).message()));
    }

    public void addRealTimeTask(int transaction, Runnable runnable) {
        this.transactionProcessor.addRealTimeTask(transaction, false, runnable);
    }

    public int getTicksExisted() {
        return FormatUtils.convertMillisToTicks(System.currentTimeMillis() - this.joinTime);
    }

    public boolean hasBypassPermission() {
        return this.bypassPermission;
    }

    public void cancelEvent(ProtocolPacketEvent event) {
        event.cleanUp();
        event.setCancelled(true);
    }

    @Override
    public String username() {
        return this.user != null ? this.user.getName() : "Undefined";
    }

    @Override
    public String brand() {
        return this.brand;
    }

    @Override
    public String locale() {
        return this.locale;
    }

    @Override
    public int entityId() {
        return this.user != null ? this.user.getEntityId() : -1;
    }

    @Override
    public int ping() {
        return (int)this.getPingProcessor().getPing();
    }

    @Override
    public int ticksExisted() {
        return this.getTicksExisted();
    }

    @Override
    public UUID uuid() {
        return this.user != null ? this.user.getUUID() : UUID.randomUUID();
    }

    @Override
    public long existSince() {
        return System.currentTimeMillis() - this.joinTime;
    }

    @Override
    public String version() {
        return this.user.getClientVersion().name().replace("V_", "").replace("_", ".");
    }

    @Override
    public boolean kick() {
        if (this.user != null) {
            SierraDataManager.increaseKickValue();
            this.user.closeConnection();
            return true;
        }
        return false;
    }

    @Override
    public boolean isExempt() {
        return this.exempt;
    }

    @Override
    public GameMode gameMode() {
        return this.getGameMode();
    }

    @Override
    public boolean setExempt(boolean b) {
        this.exempt = b;
        return this.exempt;
    }

    @Override
    public AlertSettings alertSettings() {
        return this.alertSettings;
    }

    @Override
    public AlertSettings mitigationSettings() {
        return this.mitigationSettings;
    }

    @Override
    public CheckRepository checkRepository() {
        return this.checkManager;
    }

    @Override
    public TimingHandler timingHandler() {
        return this.getTimingProcessor();
    }

    @Generated
    public Object getBukkitPlayer() {
        return this.bukkitPlayer;
    }

    @Generated
    public User getUser() {
        return this.user;
    }

    @Generated
    public GameMode getGameMode() {
        return this.gameMode;
    }

    @Generated
    public Location getLastLocation() {
        return this.lastLocation;
    }

    @Generated
    public ClientVersion getClientVersion() {
        return this.clientVersion;
    }

    @Generated
    public String getBrand() {
        return this.brand;
    }

    @Generated
    public String getLocale() {
        return this.locale;
    }

    @Generated
    public Set<String> getChannels() {
        return this.channels;
    }

    @Generated
    public long getJoinTime() {
        return this.joinTime;
    }

    @Generated
    public boolean isReceivedPunishment() {
        return this.receivedPunishment;
    }

    @Generated
    public boolean isNameChecked() {
        return this.nameChecked;
    }

    @Generated
    public boolean isBypassPermission() {
        return this.bypassPermission;
    }

    @Generated
    public double getBytesSent() {
        return this.bytesSent;
    }

    @Generated
    public AlertSettings getAlertSettings() {
        return this.alertSettings;
    }

    @Generated
    public AlertSettings getMitigationSettings() {
        return this.mitigationSettings;
    }

    @Generated
    public SierraLogger getSierraLogger() {
        return this.sierraLogger;
    }

    @Generated
    public CheckManager getCheckManager() {
        return this.checkManager;
    }

    @Generated
    public BrandProcessor getBrandProcessor() {
        return this.brandProcessor;
    }

    @Generated
    public GameModeProcessor getGameModeProcessor() {
        return this.gameModeProcessor;
    }

    @Generated
    public PingProcessor getPingProcessor() {
        return this.pingProcessor;
    }

    @Generated
    public TeleportProcessor getTeleportProcessor() {
        return this.teleportProcessor;
    }

    @Generated
    public TransactionProcessor getTransactionProcessor() {
        return this.transactionProcessor;
    }

    @Generated
    public TimingHandler getTimingProcessor() {
        return this.timingProcessor;
    }

    @Generated
    public void setBukkitPlayer(Object bukkitPlayer) {
        this.bukkitPlayer = bukkitPlayer;
    }

    @Generated
    public void setUser(User user) {
        this.user = user;
    }

    @Generated
    public void setGameMode(GameMode gameMode) {
        this.gameMode = gameMode;
    }

    @Generated
    public void setLastLocation(Location lastLocation) {
        this.lastLocation = lastLocation;
    }

    @Generated
    public void setClientVersion(ClientVersion clientVersion) {
        this.clientVersion = clientVersion;
    }

    @Generated
    public void setBrand(String brand) {
        this.brand = brand;
    }

    @Generated
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Generated
    public void setReceivedPunishment(boolean receivedPunishment) {
        this.receivedPunishment = receivedPunishment;
    }

    @Generated
    public void setNameChecked(boolean nameChecked) {
        this.nameChecked = nameChecked;
    }

    @Generated
    public void setBypassPermission(boolean bypassPermission) {
        this.bypassPermission = bypassPermission;
    }

    @Generated
    public void setBytesSent(double bytesSent) {
        this.bytesSent = bytesSent;
    }

    @Generated
    public void setSierraLogger(SierraLogger sierraLogger) {
        this.sierraLogger = sierraLogger;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerData)) {
            return false;
        }
        PlayerData other = (PlayerData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getJoinTime() != other.getJoinTime()) {
            return false;
        }
        if (this.isReceivedPunishment() != other.isReceivedPunishment()) {
            return false;
        }
        if (this.isExempt() != other.isExempt()) {
            return false;
        }
        if (this.isNameChecked() != other.isNameChecked()) {
            return false;
        }
        if (this.isBypassPermission() != other.isBypassPermission()) {
            return false;
        }
        if (Double.compare(this.getBytesSent(), other.getBytesSent()) != 0) {
            return false;
        }
        Object this$bukkitPlayer = this.getBukkitPlayer();
        Object other$bukkitPlayer = other.getBukkitPlayer();
        if (this$bukkitPlayer == null ? other$bukkitPlayer != null : !this$bukkitPlayer.equals(other$bukkitPlayer)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        GameMode this$gameMode = this.getGameMode();
        GameMode other$gameMode = other.getGameMode();
        if (this$gameMode == null ? other$gameMode != null : !((Object)((Object)this$gameMode)).equals((Object)other$gameMode)) {
            return false;
        }
        Location this$lastLocation = this.getLastLocation();
        Location other$lastLocation = other.getLastLocation();
        if (this$lastLocation == null ? other$lastLocation != null : !this$lastLocation.equals(other$lastLocation)) {
            return false;
        }
        ClientVersion this$clientVersion = this.getClientVersion();
        ClientVersion other$clientVersion = other.getClientVersion();
        if (this$clientVersion == null ? other$clientVersion != null : !((Object)((Object)this$clientVersion)).equals((Object)other$clientVersion)) {
            return false;
        }
        String this$brand = this.getBrand();
        String other$brand = other.getBrand();
        if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        Set<String> this$channels = this.getChannels();
        Set<String> other$channels = other.getChannels();
        if (this$channels == null ? other$channels != null : !((Object)this$channels).equals(other$channels)) {
            return false;
        }
        AlertSettings this$alertSettings = this.getAlertSettings();
        AlertSettings other$alertSettings = other.getAlertSettings();
        if (this$alertSettings == null ? other$alertSettings != null : !this$alertSettings.equals(other$alertSettings)) {
            return false;
        }
        AlertSettings this$mitigationSettings = this.getMitigationSettings();
        AlertSettings other$mitigationSettings = other.getMitigationSettings();
        if (this$mitigationSettings == null ? other$mitigationSettings != null : !this$mitigationSettings.equals(other$mitigationSettings)) {
            return false;
        }
        SierraLogger this$sierraLogger = this.getSierraLogger();
        SierraLogger other$sierraLogger = other.getSierraLogger();
        if (this$sierraLogger == null ? other$sierraLogger != null : !((Object)this$sierraLogger).equals(other$sierraLogger)) {
            return false;
        }
        CheckManager this$checkManager = this.getCheckManager();
        CheckManager other$checkManager = other.getCheckManager();
        if (this$checkManager == null ? other$checkManager != null : !this$checkManager.equals(other$checkManager)) {
            return false;
        }
        BrandProcessor this$brandProcessor = this.getBrandProcessor();
        BrandProcessor other$brandProcessor = other.getBrandProcessor();
        if (this$brandProcessor == null ? other$brandProcessor != null : !this$brandProcessor.equals(other$brandProcessor)) {
            return false;
        }
        GameModeProcessor this$gameModeProcessor = this.getGameModeProcessor();
        GameModeProcessor other$gameModeProcessor = other.getGameModeProcessor();
        if (this$gameModeProcessor == null ? other$gameModeProcessor != null : !this$gameModeProcessor.equals(other$gameModeProcessor)) {
            return false;
        }
        PingProcessor this$pingProcessor = this.getPingProcessor();
        PingProcessor other$pingProcessor = other.getPingProcessor();
        if (this$pingProcessor == null ? other$pingProcessor != null : !this$pingProcessor.equals(other$pingProcessor)) {
            return false;
        }
        TeleportProcessor this$teleportProcessor = this.getTeleportProcessor();
        TeleportProcessor other$teleportProcessor = other.getTeleportProcessor();
        if (this$teleportProcessor == null ? other$teleportProcessor != null : !this$teleportProcessor.equals(other$teleportProcessor)) {
            return false;
        }
        TransactionProcessor this$transactionProcessor = this.getTransactionProcessor();
        TransactionProcessor other$transactionProcessor = other.getTransactionProcessor();
        if (this$transactionProcessor == null ? other$transactionProcessor != null : !this$transactionProcessor.equals(other$transactionProcessor)) {
            return false;
        }
        TimingHandler this$timingProcessor = this.getTimingProcessor();
        TimingHandler other$timingProcessor = other.getTimingProcessor();
        return !(this$timingProcessor == null ? other$timingProcessor != null : !this$timingProcessor.equals(other$timingProcessor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PlayerData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $joinTime = this.getJoinTime();
        result = result * 59 + (int)($joinTime >>> 32 ^ $joinTime);
        result = result * 59 + (this.isReceivedPunishment() ? 79 : 97);
        result = result * 59 + (this.isExempt() ? 79 : 97);
        result = result * 59 + (this.isNameChecked() ? 79 : 97);
        result = result * 59 + (this.isBypassPermission() ? 79 : 97);
        long $bytesSent = Double.doubleToLongBits(this.getBytesSent());
        result = result * 59 + (int)($bytesSent >>> 32 ^ $bytesSent);
        Object $bukkitPlayer = this.getBukkitPlayer();
        result = result * 59 + ($bukkitPlayer == null ? 43 : $bukkitPlayer.hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        GameMode $gameMode = this.getGameMode();
        result = result * 59 + ($gameMode == null ? 43 : ((Object)((Object)$gameMode)).hashCode());
        Location $lastLocation = this.getLastLocation();
        result = result * 59 + ($lastLocation == null ? 43 : $lastLocation.hashCode());
        ClientVersion $clientVersion = this.getClientVersion();
        result = result * 59 + ($clientVersion == null ? 43 : ((Object)((Object)$clientVersion)).hashCode());
        String $brand = this.getBrand();
        result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        Set<String> $channels = this.getChannels();
        result = result * 59 + ($channels == null ? 43 : ((Object)$channels).hashCode());
        AlertSettings $alertSettings = this.getAlertSettings();
        result = result * 59 + ($alertSettings == null ? 43 : $alertSettings.hashCode());
        AlertSettings $mitigationSettings = this.getMitigationSettings();
        result = result * 59 + ($mitigationSettings == null ? 43 : $mitigationSettings.hashCode());
        SierraLogger $sierraLogger = this.getSierraLogger();
        result = result * 59 + ($sierraLogger == null ? 43 : ((Object)$sierraLogger).hashCode());
        CheckManager $checkManager = this.getCheckManager();
        result = result * 59 + ($checkManager == null ? 43 : $checkManager.hashCode());
        BrandProcessor $brandProcessor = this.getBrandProcessor();
        result = result * 59 + ($brandProcessor == null ? 43 : $brandProcessor.hashCode());
        GameModeProcessor $gameModeProcessor = this.getGameModeProcessor();
        result = result * 59 + ($gameModeProcessor == null ? 43 : $gameModeProcessor.hashCode());
        PingProcessor $pingProcessor = this.getPingProcessor();
        result = result * 59 + ($pingProcessor == null ? 43 : $pingProcessor.hashCode());
        TeleportProcessor $teleportProcessor = this.getTeleportProcessor();
        result = result * 59 + ($teleportProcessor == null ? 43 : $teleportProcessor.hashCode());
        TransactionProcessor $transactionProcessor = this.getTransactionProcessor();
        result = result * 59 + ($transactionProcessor == null ? 43 : $transactionProcessor.hashCode());
        TimingHandler $timingProcessor = this.getTimingProcessor();
        result = result * 59 + ($timingProcessor == null ? 43 : $timingProcessor.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PlayerData(bukkitPlayer=" + this.getBukkitPlayer() + ", user=" + this.getUser() + ", gameMode=" + (Object)((Object)this.getGameMode()) + ", lastLocation=" + this.getLastLocation() + ", clientVersion=" + (Object)((Object)this.getClientVersion()) + ", brand=" + this.getBrand() + ", locale=" + this.getLocale() + ", channels=" + this.getChannels() + ", joinTime=" + this.getJoinTime() + ", receivedPunishment=" + this.isReceivedPunishment() + ", exempt=" + this.isExempt() + ", nameChecked=" + this.isNameChecked() + ", bypassPermission=" + this.isBypassPermission() + ", bytesSent=" + this.getBytesSent() + ", alertSettings=" + this.getAlertSettings() + ", mitigationSettings=" + this.getMitigationSettings() + ", sierraLogger=" + this.getSierraLogger() + ", checkManager=" + this.getCheckManager() + ", brandProcessor=" + this.getBrandProcessor() + ", gameModeProcessor=" + this.getGameModeProcessor() + ", pingProcessor=" + this.getPingProcessor() + ", teleportProcessor=" + this.getTeleportProcessor() + ", transactionProcessor=" + this.getTransactionProcessor() + ", timingProcessor=" + this.getTimingProcessor() + ")";
    }
}

