/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.manager.storage;

import de.feelix.sierra.Sierra;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.manager.storage.history.HistoryDocument;
import de.feelix.sierraapi.check.CheckType;
import de.feelix.sierraapi.events.impl.AsyncHistoryCreateEvent;
import de.feelix.sierraapi.history.History;
import de.feelix.sierraapi.history.HistoryType;
import de.feelix.sierraapi.user.UserRepository;
import de.feelix.sierraapi.user.impl.SierraUser;
import de.feelix.sierraapi.violation.MitigationStrategy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.square.sierra.kyori.adventure.text.Component;
import net.square.sierra.kyori.adventure.text.TextComponent;
import net.square.sierra.kyori.adventure.text.event.ClickEvent;
import net.square.sierra.kyori.adventure.text.event.HoverEvent;
import net.square.sierra.packetevents.api.PacketEvents;
import net.square.sierra.packetevents.api.adventure.serializer.legacy.LegacyComponentSerializer;
import net.square.sierra.packetevents.api.event.PacketListenerCommon;
import net.square.sierra.packetevents.api.event.UserConnectEvent;
import net.square.sierra.packetevents.api.event.UserDisconnectEvent;
import net.square.sierra.packetevents.api.protocol.player.User;
import net.square.sierra.packetevents.api.util.folia.FoliaScheduler;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SierraDataManager
implements UserRepository {
    private static final String VERSION_START_TAG = "\"tag_name\":\"";
    private static final String GITHUB_API_BASE_URL = "https://api.github.com/repos/";
    private static final String GITHUB_API_RELEASES = "/releases/latest";
    public static final String UNKNOWN_VERSION = "UNKNOWN";
    public static final Map<String, Integer> violationCount = new HashMap<String, Integer>();
    public static int KICKS = 0;
    public static int BANS = 0;
    public static boolean skipSkullUUIDCheck = false;
    public static boolean skipModelCheck = false;
    public static boolean skipAnvilCheck = false;
    public static boolean skipDeltaPositionCheck = false;
    private static SierraDataManager instance;
    private final Map<User, PlayerData> playerData = new ConcurrentHashMap<User, PlayerData>();
    private final List<History> histories = new ArrayList<History>();

    public SierraDataManager() {
        instance = this;
        this.initializePacketListeners();
    }

    private void initializePacketListeners() {
        PacketEvents.getAPI().getEventManager().registerListener(new PacketListenerCommon(){

            @Override
            public void onUserConnect(UserConnectEvent event) {
                User user = event.getUser();
                SierraDataManager.this.addPlayerData(user);
                SierraDataManager.this.checkIfBlocked(user);
                SierraDataManager.this.checkForUpdate(user);
            }

            @Override
            public void onUserDisconnect(UserDisconnectEvent event) {
                SierraDataManager.this.removePlayerData(event.getUser());
            }
        });
    }

    private void checkIfBlocked(User user) {
        if (Sierra.getPlugin().getSierraConfigEngine().config().getBoolean("block-connections-after-ban", true)) {
            String hostAddress = user.getAddress().getAddress().getHostAddress();
            if (Sierra.getPlugin().getAddressStorage().invalid(hostAddress)) {
                Sierra.getPlugin().getLogger().info("Connection of " + hostAddress + " got blocked, cause it was punished recently");
                PlayerData data = (PlayerData)this.getPlayerData(user).get();
                if (data != null) {
                    data.punish(MitigationStrategy.KICK);
                }
            }
        }
    }

    private void checkForUpdate(User user) {
        FoliaScheduler.getAsyncScheduler().runNow((Plugin)Sierra.getPlugin(), o -> {
            Player player;
            try {
                TimeUnit.MILLISECONDS.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            if (this.isVersionOutdated() && this.isUserValid(user) && !this.isVersionInvalid() && (player = this.getPlayer(user)) != null && this.playerCanUpdate(player)) {
                this.sendMessage(user);
            }
        });
    }

    private boolean isVersionInvalid() {
        return Sierra.getPlugin().getUpdateChecker().getLatestReleaseVersion().equalsIgnoreCase(UNKNOWN_VERSION);
    }

    private boolean isVersionOutdated() {
        String localVersion = Sierra.getPlugin().getDescription().getVersion();
        String latestReleaseVersion = Sierra.getPlugin().getUpdateChecker().getLatestReleaseVersion();
        return !latestReleaseVersion.equalsIgnoreCase(localVersion);
    }

    private boolean isUserValid(User user) {
        return user != null && user.getName() != null;
    }

    private Player getPlayer(User user) {
        return Bukkit.getPlayer((String)user.getName());
    }

    private boolean playerCanUpdate(Player player) {
        return player.hasPermission("sierra.update") || player.isOp();
    }

    public void addKick(CheckType checkType) {
        String name = checkType.getFriendlyName().replace(" ", "");
        violationCount.merge(name, 1, Integer::sum);
    }

    private void sendMessage(User user) {
        String localVersion = Sierra.getPlugin().getDescription().getVersion();
        String latestReleaseVersion = Sierra.getPlugin().getUpdateChecker().getLatestReleaseVersion();
        user.sendMessage(Sierra.PREFIX + " \u00a7cServer is running an outdated version of Sierra");
        user.sendMessage(Sierra.PREFIX + " \u00a7fLocal: \u00a7c" + localVersion + "\u00a7f, Latest: \u00a7a" + latestReleaseVersion);
        user.sendMessage((Component)((TextComponent)LegacyComponentSerializer.legacy('&').deserialize(Sierra.PREFIX + " &c&nToo lazy? Stay always up-to-date with SierraLoader&c").clickEvent(ClickEvent.clickEvent(ClickEvent.Action.OPEN_URL, "https://sierra.squarecode.de/sierra/sierra-documentation/sierra-loader"))).hoverEvent(HoverEvent.showText(Component.text("\u00a77Click me to view the documentation"))));
    }

    public void createPunishmentHistory(String username, String clientVersion, MitigationStrategy mitigationStrategy, long ping, String description) {
        this.createHistory(username, clientVersion, mitigationStrategy, ping, description, HistoryType.PUNISH);
    }

    public void createMitigateHistory(String username, String clientVersion, MitigationStrategy mitigationStrategy, long ping, String description) {
        this.createHistory(username, clientVersion, mitigationStrategy, ping, description, HistoryType.MITIGATE);
    }

    private void createHistory(String username, String clientVersion, MitigationStrategy mitigationStrategy, long ping, String description, HistoryType type) {
        FoliaScheduler.getAsyncScheduler().runNow((Plugin)Sierra.getPlugin(), o -> {
            HistoryDocument document = new HistoryDocument(username, description, clientVersion, ping, mitigationStrategy, type);
            AsyncHistoryCreateEvent event = new AsyncHistoryCreateEvent(document);
            Sierra.getPlugin().getEventBus().publish(event);
            if (!event.isCancelled()) {
                this.histories.add(document);
            }
        });
    }

    public WeakReference<PlayerData> getPlayerData(User user) {
        return new WeakReference<PlayerData>(this.playerData.get(user));
    }

    public void addPlayerData(User user) {
        this.playerData.put(user, new PlayerData(user));
    }

    public void removePlayerData(User user) {
        PlayerData data = this.playerData.get(user);
        if (data != null && data.getSierraLogger() != null) {
            data.getSierraLogger().close();
        }
        this.playerData.remove(user);
    }

    public static void increaseKickValue() {
        ++KICKS;
    }

    public static void increaseBanValue() {
        ++BANS;
    }

    @Override
    public Optional<SierraUser> queryUserByUuid(UUID uuid) {
        return this.playerData.keySet().stream().filter(user -> user.getUUID().equals(uuid)).map(user -> this.playerData.get(user)).findFirst();
    }

    @Override
    public Optional<SierraUser> queryUserByEntityId(int id) {
        return this.playerData.keySet().stream().filter(user -> user.getEntityId() == id).map(user -> this.playerData.get(user)).findFirst();
    }

    @Override
    public Optional<SierraUser> queryUserByName(String name) {
        return this.playerData.keySet().stream().filter(user -> user.getName().equalsIgnoreCase(name)).map(user -> this.playerData.get(user)).findFirst();
    }

    @Override
    public List<History> getLocalActionHistory() {
        return this.histories;
    }

    @Generated
    public Map<User, PlayerData> getPlayerData() {
        return this.playerData;
    }

    @Generated
    public List<History> getHistories() {
        return this.histories;
    }

    @Generated
    public static SierraDataManager getInstance() {
        return instance;
    }
}

