/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.manager.storage.history;

import de.feelix.sierra.utilities.FormatUtils;
import de.feelix.sierraapi.history.History;
import de.feelix.sierraapi.history.HistoryType;
import de.feelix.sierraapi.violation.MitigationStrategy;
import lombok.Generated;

public class HistoryDocument
implements History {
    private final String username;
    private final String description;
    private final String clientVersion;
    private final long ping;
    private final MitigationStrategy mitigationStrategy;
    private final HistoryType historyType;
    private final long timestamp = System.currentTimeMillis();

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public MitigationStrategy mitigationStrategy() {
        return this.mitigationStrategy;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public String clientVersion() {
        return this.clientVersion;
    }

    @Override
    public HistoryType historyType() {
        return this.historyType;
    }

    @Override
    public long ping() {
        return this.ping;
    }

    public String formatTimestamp() {
        return FormatUtils.formatTimestamp(this.timestamp);
    }

    public String shortenDescription() {
        return FormatUtils.shortenString(this.description);
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getClientVersion() {
        return this.clientVersion;
    }

    @Generated
    public long getPing() {
        return this.ping;
    }

    @Generated
    public MitigationStrategy getMitigationStrategy() {
        return this.mitigationStrategy;
    }

    @Generated
    public HistoryType getHistoryType() {
        return this.historyType;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HistoryDocument)) {
            return false;
        }
        HistoryDocument other = (HistoryDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPing() != other.getPing()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$clientVersion = this.getClientVersion();
        String other$clientVersion = other.getClientVersion();
        if (this$clientVersion == null ? other$clientVersion != null : !this$clientVersion.equals(other$clientVersion)) {
            return false;
        }
        MitigationStrategy this$mitigationStrategy = this.getMitigationStrategy();
        MitigationStrategy other$mitigationStrategy = other.getMitigationStrategy();
        if (this$mitigationStrategy == null ? other$mitigationStrategy != null : !((Object)((Object)this$mitigationStrategy)).equals((Object)other$mitigationStrategy)) {
            return false;
        }
        HistoryType this$historyType = this.getHistoryType();
        HistoryType other$historyType = other.getHistoryType();
        return !(this$historyType == null ? other$historyType != null : !((Object)((Object)this$historyType)).equals((Object)other$historyType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HistoryDocument;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ping = this.getPing();
        result = result * 59 + (int)($ping >>> 32 ^ $ping);
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $clientVersion = this.getClientVersion();
        result = result * 59 + ($clientVersion == null ? 43 : $clientVersion.hashCode());
        MitigationStrategy $mitigationStrategy = this.getMitigationStrategy();
        result = result * 59 + ($mitigationStrategy == null ? 43 : ((Object)((Object)$mitigationStrategy)).hashCode());
        HistoryType $historyType = this.getHistoryType();
        result = result * 59 + ($historyType == null ? 43 : ((Object)((Object)$historyType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HistoryDocument(username=" + this.getUsername() + ", description=" + this.getDescription() + ", clientVersion=" + this.getClientVersion() + ", ping=" + this.getPing() + ", mitigationStrategy=" + (Object)((Object)this.getMitigationStrategy()) + ", historyType=" + (Object)((Object)this.getHistoryType()) + ", timestamp=" + this.getTimestamp() + ")";
    }

    @Generated
    public HistoryDocument(String username, String description, String clientVersion, long ping, MitigationStrategy mitigationStrategy, HistoryType historyType) {
        this.username = username;
        this.description = description;
        this.clientVersion = clientVersion;
        this.ping = ping;
        this.mitigationStrategy = mitigationStrategy;
        this.historyType = historyType;
    }
}

