/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.manager.storage.logger;

import de.feelix.sierra.Sierra;
import de.feelix.sierra.manager.storage.logger.LogTag;
import de.feelix.sierraapi.exceptions.SierraException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import lombok.Generated;

public class SierraLogger {
    private BufferedWriter writer;
    private String playerName;

    public SierraLogger(String playerName) {
        this.playerName = playerName;
        File sierraLogs = new File("plugins/Sierra/logs/");
        if (!sierraLogs.exists() && !sierraLogs.mkdirs()) {
            throw new SierraException("Failed to create directory " + sierraLogs.getAbsolutePath());
        }
        File pluginDir = new File("plugins/Sierra/logs/" + playerName);
        if (!pluginDir.exists() && !pluginDir.mkdirs()) {
            throw new RuntimeException("Failed to create plugin directory: " + pluginDir);
        }
        try {
            this.writer = new BufferedWriter(new FileWriter(new File(pluginDir, "logs.sierra"), true));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void log(LogTag tag, String message) {
        if (message.equalsIgnoreCase("{}")) {
            return;
        }
        String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        String logMessage = String.format("[%s] %s: %s", timestamp, tag.name(), message);
        try {
            this.writer.write(logMessage);
            this.writer.newLine();
            this.writer.flush();
        }
        catch (IOException e) {
            Sierra.getPlugin().getLogger().warning("Unable to write log: " + e.getMessage());
        }
    }

    public void close() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Generated
    public BufferedWriter getWriter() {
        return this.writer;
    }

    @Generated
    public String getPlayerName() {
        return this.playerName;
    }

    @Generated
    public void setWriter(BufferedWriter writer) {
        this.writer = writer;
    }

    @Generated
    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SierraLogger)) {
            return false;
        }
        SierraLogger other = (SierraLogger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BufferedWriter this$writer = this.getWriter();
        BufferedWriter other$writer = other.getWriter();
        if (this$writer == null ? other$writer != null : !this$writer.equals(other$writer)) {
            return false;
        }
        String this$playerName = this.getPlayerName();
        String other$playerName = other.getPlayerName();
        return !(this$playerName == null ? other$playerName != null : !this$playerName.equals(other$playerName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SierraLogger;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BufferedWriter $writer = this.getWriter();
        result = result * 59 + ($writer == null ? 43 : $writer.hashCode());
        String $playerName = this.getPlayerName();
        result = result * 59 + ($playerName == null ? 43 : $playerName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SierraLogger(writer=" + this.getWriter() + ", playerName=" + this.getPlayerName() + ")";
    }
}

