/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.manager.storage.menu;

import lombok.Generated;
import net.square.sierra.packetevents.api.PacketEvents;
import net.square.sierra.packetevents.api.manager.server.ServerVersion;

public enum MenuType {
    GENERIC_9x1(0, "minecraft:generic_9x1"),
    GENERIC_9x2(1, "minecraft:generic_9x2"),
    GENERIC_9x3(2, "minecraft:generic_9x3"),
    GENERIC_9x4(3, "minecraft:generic_9x4"),
    GENERIC_9x5(4, "minecraft:generic_9x5"),
    GENERIC_9x6(5, "minecraft:generic_9x6"),
    GENERIC_3x3(6, "minecraft:generic_3x3"),
    CRAFTER_3x3(7, "minecraft:crafter_3x3"),
    ANVIL(8, "minecraft:anvil"),
    BEACON(9, "minecraft:beacon"),
    BLAST_FURNACE(10, "minecraft:blast_furnace"),
    BREWING_STAND(11, "minecraft:brewing_stand"),
    CRAFTING(12, "minecraft:crafting"),
    ENCHANTMENT(13, "minecraft:enchantment"),
    FURNACE(14, "minecraft:furnace"),
    GRINDSTONE(15, "minecraft:grindstone"),
    HOPPER(16, "minecraft:hopper"),
    LECTERN(17, "minecraft:lectern"),
    LOOM(18, "minecraft:loom"),
    MERCHANT(19, "minecraft:merchant"),
    SHULKER_BOX(20, "minecraft:shulker_box"),
    SMITHING(21, "minecraft:smithing"),
    SMOKER(22, "minecraft:smoker"),
    CARTOGRAPHY_TABLE(23, "minecraft:cartography"),
    STONECUTTER(24, "minecraft:stonecutter"),
    UNKNOWN(-1, "UNKNOWN");

    private final int id;
    private final String legacyName;
    private static final int MAX_ID_OLD_VERSION = 23;

    public static MenuType[] getMenuTypeValues() {
        return MenuType.values();
    }

    public static MenuType getMenuType(int id) {
        ServerVersion version = PacketEvents.getAPI().getServerManager().getVersion();
        if (MenuType.isInvalidId(id, version)) {
            return UNKNOWN;
        }
        if (version.isOlderThan(ServerVersion.V_1_20_3) && id >= 7) {
            ++id;
        }
        return MenuType.getMenuTypeValues()[id];
    }

    private static boolean isInvalidId(int id, ServerVersion version) {
        return id < 0 || id > MenuType.getMaxIdBasedOnVersion(version) || id >= MenuType.getMenuTypeValues().length;
    }

    private static int getMaxIdBasedOnVersion(ServerVersion version) {
        return version.isOlderThan(ServerVersion.V_1_20_3) ? 23 : MenuType.getMenuTypeValues().length - 1;
    }

    @Generated
    private MenuType(int id, String legacyName) {
        this.id = id;
        this.legacyName = legacyName;
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getLegacyName() {
        return this.legacyName;
    }
}

