/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.manager.storage.processor;

import de.feelix.sierra.Sierra;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.utilities.CastUtil;
import de.feelix.sierraapi.events.impl.UserBrandEvent;
import lombok.Generated;
import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.protocol.packettype.PacketType;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientPluginMessage;

public class BrandProcessor {
    private final PlayerData playerData;
    private boolean hasBrand = false;

    public BrandProcessor(PlayerData playerData) {
        this.playerData = playerData;
    }

    public void process(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.PLUGIN_MESSAGE) {
            WrapperPlayClientPluginMessage wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientPluginMessage(event), this.playerData::exceptionDisconnect);
            this.handleChannelMessage(wrapper.getChannelName(), wrapper.getData());
        }
    }

    private void handleChannelMessage(String channel, byte[] data) {
        if (this.isBrandChannel(channel)) {
            this.processBrandData(data);
        }
    }

    private boolean isBrandChannel(String channel) {
        return channel.equalsIgnoreCase("minecraft:brand") || channel.equals("MC|Brand");
    }

    private void processBrandData(byte[] data) {
        if (data.length > 64 || data.length == 0) {
            this.playerData.setBrand("sent " + data.length + " bytes as brand");
        } else if (!this.hasBrand) {
            String brand = new String(data, 1, data.length - 1).replace(" (Velocity)", "");
            this.playerData.setBrand(brand);
            this.hasBrand = true;
        }
        Sierra.getPlugin().getEventBus().publish(new UserBrandEvent(this.playerData, this.playerData.getBrand()));
    }

    @Generated
    public PlayerData getPlayerData() {
        return this.playerData;
    }

    @Generated
    public boolean isHasBrand() {
        return this.hasBrand;
    }
}

