/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.manager.storage.processor;

import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.utilities.CastUtil;
import lombok.Generated;
import net.square.sierra.packetevents.api.event.PacketSendEvent;
import net.square.sierra.packetevents.api.protocol.packettype.PacketType;
import net.square.sierra.packetevents.api.protocol.packettype.PacketTypeCommon;
import net.square.sierra.packetevents.api.protocol.player.GameMode;
import net.square.sierra.packetevents.api.wrapper.play.server.WrapperPlayServerChangeGameState;
import net.square.sierra.packetevents.api.wrapper.play.server.WrapperPlayServerJoinGame;
import net.square.sierra.packetevents.api.wrapper.play.server.WrapperPlayServerRespawn;

public class GameModeProcessor {
    private final PlayerData playerData;

    public GameModeProcessor(PlayerData playerData) {
        this.playerData = playerData;
    }

    public void process(PacketSendEvent event) {
        PacketTypeCommon typeCommon = event.getPacketType();
        if (typeCommon.equals(PacketType.Play.Server.CHANGE_GAME_STATE)) {
            this.handleGameStateChange(event);
        } else if (typeCommon.equals(PacketType.Play.Server.JOIN_GAME)) {
            this.handleJoinGame(event);
        } else if (typeCommon.equals(PacketType.Play.Server.RESPAWN)) {
            this.handleRespawn(event);
        }
    }

    private void handleGameStateChange(PacketSendEvent event) {
        WrapperPlayServerChangeGameState packet = CastUtil.getSupplier(() -> new WrapperPlayServerChangeGameState(event), this.playerData::exceptionDisconnect);
        if (packet.getReason() == WrapperPlayServerChangeGameState.Reason.CHANGE_GAME_MODE) {
            int gameModeValue = (int)packet.getValue();
            GameMode gameMode = gameModeValue < 0 || gameModeValue >= GameMode.values().length ? GameMode.SURVIVAL : GameMode.values()[gameModeValue];
            this.playerData.setGameMode(gameMode);
        }
    }

    private void handleJoinGame(PacketSendEvent event) {
        WrapperPlayServerJoinGame joinGame = CastUtil.getSupplier(() -> new WrapperPlayServerJoinGame(event), this.playerData::exceptionDisconnect);
        this.playerData.setGameMode(joinGame.getGameMode());
    }

    private void handleRespawn(PacketSendEvent event) {
        WrapperPlayServerRespawn respawn = CastUtil.getSupplier(() -> new WrapperPlayServerRespawn(event), this.playerData::exceptionDisconnect);
        this.playerData.setGameMode(respawn.getGameMode());
    }

    @Generated
    public PlayerData getPlayerData() {
        return this.playerData;
    }
}

