/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.manager.storage.processor;

import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.utilities.CastUtil;
import lombok.Generated;
import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.event.PacketSendEvent;
import net.square.sierra.packetevents.api.protocol.packettype.PacketType;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientKeepAlive;
import net.square.sierra.packetevents.api.wrapper.play.server.WrapperPlayServerKeepAlive;

public class PingProcessor {
    private final PlayerData playerData;
    private long ping = -1L;
    private long lastId = -1L;
    private long lastTime = -1L;

    public PingProcessor(PlayerData playerData) {
        this.playerData = playerData;
    }

    public void handlePacketSend(PacketSendEvent event) {
        if (event.getPacketType() == PacketType.Play.Server.KEEP_ALIVE) {
            WrapperPlayServerKeepAlive wrapper = CastUtil.getSupplier(() -> new WrapperPlayServerKeepAlive(event), this.playerData::exceptionDisconnect);
            this.lastId = wrapper.getId();
            this.lastTime = System.currentTimeMillis();
        }
    }

    public void handlePacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.KEEP_ALIVE) {
            WrapperPlayClientKeepAlive wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientKeepAlive(event), this.playerData::exceptionDisconnect);
            if (wrapper.getId() == this.lastId) {
                this.ping = System.currentTimeMillis() - this.lastTime;
            }
        }
    }

    @Generated
    public PlayerData getPlayerData() {
        return this.playerData;
    }

    @Generated
    public long getPing() {
        return this.ping;
    }

    @Generated
    public long getLastId() {
        return this.lastId;
    }

    @Generated
    public long getLastTime() {
        return this.lastTime;
    }
}

