/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.manager.storage.processor;

import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.utilities.CastUtil;
import de.feelix.sierra.utilities.Teleport;
import lombok.Generated;
import net.square.sierra.packetevents.api.event.PacketSendEvent;
import net.square.sierra.packetevents.api.protocol.packettype.PacketType;
import net.square.sierra.packetevents.api.util.Vector3d;
import net.square.sierra.packetevents.api.wrapper.play.server.WrapperPlayServerPlayerPositionAndLook;

public class TeleportProcessor {
    private final PlayerData playerData;
    private Teleport teleport;

    public TeleportProcessor(PlayerData playerData) {
        this.playerData = playerData;
    }

    public void handle(PacketSendEvent event) {
        if (event.getPacketType() == PacketType.Play.Server.PLAYER_POSITION_AND_LOOK) {
            WrapperPlayServerPlayerPositionAndLook wrapper = CastUtil.getSupplier(() -> new WrapperPlayServerPlayerPositionAndLook(event), this.playerData::exceptionDisconnect);
            this.teleport = new Teleport(wrapper.getTeleportId(), new Vector3d(wrapper.getX(), wrapper.getY(), wrapper.getZ()), wrapper.getYaw(), wrapper.getPitch());
        }
    }

    public long getLastTeleportTime() {
        return this.teleport != null ? this.teleport.getTimestamp() : 0L;
    }

    @Generated
    public PlayerData getPlayerData() {
        return this.playerData;
    }

    @Generated
    public Teleport getTeleport() {
        return this.teleport;
    }
}

