/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.manager.storage.processor;

import de.feelix.sierra.Sierra;
import de.feelix.sierra.manager.storage.PlayerData;
import de.feelix.sierra.manager.storage.logger.LogTag;
import de.feelix.sierra.utilities.CastUtil;
import de.feelix.sierra.utilities.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import net.square.sierra.packetevents.api.PacketEvents;
import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.event.PacketSendEvent;
import net.square.sierra.packetevents.api.manager.server.ServerVersion;
import net.square.sierra.packetevents.api.netty.channel.ChannelHelper;
import net.square.sierra.packetevents.api.protocol.ConnectionState;
import net.square.sierra.packetevents.api.protocol.packettype.PacketType;
import net.square.sierra.packetevents.api.protocol.packettype.PacketTypeCommon;
import net.square.sierra.packetevents.api.wrapper.PacketWrapper;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientPong;
import net.square.sierra.packetevents.api.wrapper.play.client.WrapperPlayClientWindowConfirmation;
import net.square.sierra.packetevents.api.wrapper.play.server.WrapperPlayServerPing;
import net.square.sierra.packetevents.api.wrapper.play.server.WrapperPlayServerWindowConfirmation;

public class TransactionProcessor {
    private final PlayerData player;
    public final Queue<Pair<Short, Long>> transactionsSent = new ConcurrentLinkedQueue<Pair<Short, Long>>();
    public final Queue<Pair<Long, Long>> keepAlivesSent = new ConcurrentLinkedQueue<Pair<Long, Long>>();
    private final LinkedList<Pair<Integer, Runnable>> transactionMap = new LinkedList();
    public final List<Short> didWeSendThatTrans = Collections.synchronizedList(new ArrayList());
    private final AtomicInteger transactionIDCounter = new AtomicInteger(0);
    public AtomicInteger lastTransactionSent = new AtomicInteger(0);
    public AtomicInteger lastTransactionReceived = new AtomicInteger(0);
    private long transactionPing = 0L;
    public long lastTransSent = 0L;
    public long lastTransReceived = 0L;
    private long playerClockAtLeast = System.nanoTime();

    public TransactionProcessor(PlayerData playerData) {
        this.player = playerData;
    }

    public boolean addTransactionResponse(short id) {
        Pair<Short, Long> data = null;
        boolean hasID = false;
        int skipped = 0;
        for (Pair pair : this.transactionsSent) {
            if ((Short)pair.getFirst() == id) {
                hasID = true;
                break;
            }
            ++skipped;
        }
        if (hasID) {
            if (skipped > 0 && System.currentTimeMillis() - this.player.getJoinTime() > 5000L) {
                this.player.getSierraLogger().log(LogTag.SKIP, "Skipped transaction: " + id + " (" + skipped + ")");
            }
            while ((data = this.transactionsSent.poll()) != null) {
                this.lastTransactionReceived.incrementAndGet();
                this.lastTransReceived = System.currentTimeMillis();
                this.transactionPing = System.nanoTime() - data.getSecond();
                this.playerClockAtLeast = data.getSecond();
                if (data.getFirst() != id) continue;
            }
            this.handleNettySyncTransaction(this.lastTransactionReceived.get());
        }
        return data != null && (Short)data.getFirst() == id;
    }

    public void sendTransaction() {
        this.sendTransaction(false);
    }

    public void sendTransaction(boolean async) {
        if (this.player.getUser().getEncoderState() != ConnectionState.PLAY) {
            return;
        }
        if ((double)(System.nanoTime() - this.getPlayerClockAtLeast()) > 1.5E10) {
            return;
        }
        this.lastTransSent = System.currentTimeMillis();
        short transactionID = (short)(-1 * (this.transactionIDCounter.getAndIncrement() & Short.MAX_VALUE));
        try {
            PacketWrapper packet = PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_17) ? (PacketWrapper)CastUtil.getSupplier(() -> new WrapperPlayServerPing(transactionID), this.player::exceptionDisconnect) : (PacketWrapper)CastUtil.getSupplier(() -> new WrapperPlayServerWindowConfirmation(0, transactionID, false), this.player::exceptionDisconnect);
            if (async) {
                ChannelHelper.runInEventLoop(this.player.getUser().getChannel(), () -> {
                    this.addTransactionSend(transactionID);
                    this.player.getUser().writePacket(packet);
                });
            } else {
                this.addTransactionSend(transactionID);
                this.player.getUser().writePacket(packet);
            }
        }
        catch (Exception exception) {
            this.player.getSierraLogger().log(LogTag.TRANS_EXCEP, "Error: " + exception.getMessage());
        }
    }

    public void handleTransactionClient(PacketReceiveEvent event) {
        PacketTypeCommon packetType = event.getPacketType();
        if (packetType == PacketType.Play.Client.WINDOW_CONFIRMATION) {
            this.handleWindowConfirmation(event);
        } else if (packetType == PacketType.Play.Client.PONG) {
            this.handlePong(event);
        }
    }

    private void handleWindowConfirmation(PacketReceiveEvent event) {
        WrapperPlayClientWindowConfirmation wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientWindowConfirmation(event), this.player::exceptionDisconnect);
        short id = wrapper.getActionId();
        if (id <= 0 && this.addTransactionResponse(id)) {
            event.setCancelled(true);
        }
    }

    private void handlePong(PacketReceiveEvent event) {
        WrapperPlayClientPong wrapper = CastUtil.getSupplier(() -> new WrapperPlayClientPong(event), this.player::exceptionDisconnect);
        int id = wrapper.getId();
        if (id == (short)id && this.addTransactionResponse((short)id)) {
            event.setCancelled(true);
        }
    }

    public void handleTransactionSend(PacketSendEvent event) {
        if (event.getPacketType() == PacketType.Play.Server.PING) {
            this.handlePingTransaction(event);
        } else if (event.getPacketType() == PacketType.Play.Server.WINDOW_CONFIRMATION) {
            this.handleWindowConfirmationTransaction(event);
        }
    }

    private void handlePingTransaction(PacketSendEvent event) {
        Short shortID;
        WrapperPlayServerPing wrapper = CastUtil.getSupplier(() -> new WrapperPlayServerPing(event), this.player::exceptionDisconnect);
        int id = wrapper.getId();
        if (id == (short)id && this.didWeSendThatTrans.remove(shortID = Short.valueOf((short)id))) {
            Pair<Short, Long> solarPair = new Pair<Short, Long>(shortID, System.nanoTime());
            this.transactionsSent.add(solarPair);
            this.lastTransactionSent.getAndIncrement();
        }
    }

    private void handleWindowConfirmationTransaction(PacketSendEvent event) {
        WrapperPlayServerWindowConfirmation wrapper = CastUtil.getSupplier(() -> new WrapperPlayServerWindowConfirmation(event), this.player::exceptionDisconnect);
        short id = wrapper.getActionId();
        if (id <= 0 && this.didWeSendThatTrans.remove((Object)id)) {
            Pair<Short, Long> solarPair = new Pair<Short, Long>(id, System.nanoTime());
            this.transactionsSent.add(solarPair);
            this.lastTransactionSent.getAndIncrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRealTimeTask(int transaction, boolean async, Runnable runnable) {
        if (this.lastTransactionReceived.get() >= transaction) {
            if (async) {
                ChannelHelper.runInEventLoop(this.player.getUser().getChannel(), runnable);
            } else {
                runnable.run();
            }
            return;
        }
        TransactionProcessor transactionProcessor = this;
        synchronized (transactionProcessor) {
            this.transactionMap.add(new Pair<Integer, Runnable>(transaction, runnable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNettySyncTransaction(int transaction) {
        TransactionProcessor transactionProcessor = this;
        synchronized (transactionProcessor) {
            ListIterator iterator = this.transactionMap.listIterator();
            while (iterator.hasNext()) {
                Pair pair = (Pair)iterator.next();
                if (transaction + 1 < (Integer)pair.getFirst()) {
                    return;
                }
                if (transaction == (Integer)pair.getFirst() - 1) continue;
                try {
                    ((Runnable)pair.getSecond()).run();
                }
                catch (Exception e) {
                    Sierra.getPlugin().getLogger().severe("An error has occurred when running transactions for player: " + this.player.username());
                    e.printStackTrace();
                }
                iterator.remove();
            }
        }
    }

    public void addTransactionSend(short id) {
        this.didWeSendThatTrans.add(id);
    }

    @Generated
    public PlayerData getPlayer() {
        return this.player;
    }

    @Generated
    public Queue<Pair<Short, Long>> getTransactionsSent() {
        return this.transactionsSent;
    }

    @Generated
    public Queue<Pair<Long, Long>> getKeepAlivesSent() {
        return this.keepAlivesSent;
    }

    @Generated
    public LinkedList<Pair<Integer, Runnable>> getTransactionMap() {
        return this.transactionMap;
    }

    @Generated
    public List<Short> getDidWeSendThatTrans() {
        return this.didWeSendThatTrans;
    }

    @Generated
    public AtomicInteger getTransactionIDCounter() {
        return this.transactionIDCounter;
    }

    @Generated
    public AtomicInteger getLastTransactionSent() {
        return this.lastTransactionSent;
    }

    @Generated
    public AtomicInteger getLastTransactionReceived() {
        return this.lastTransactionReceived;
    }

    @Generated
    public long getTransactionPing() {
        return this.transactionPing;
    }

    @Generated
    public long getLastTransSent() {
        return this.lastTransSent;
    }

    @Generated
    public long getLastTransReceived() {
        return this.lastTransReceived;
    }

    @Generated
    public long getPlayerClockAtLeast() {
        return this.playerClockAtLeast;
    }
}

