/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.utilities;

import de.feelix.sierra.check.violation.Debug;
import de.feelix.sierraapi.annotation.Nullable;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import net.square.sierra.packetevents.api.protocol.packettype.PacketTypeCommon;

public final class FormatUtils {
    private static final int INVALID_INT_DEFAULT = 1;
    private static final double NANOSECONDS_PER_TICK = 5.0E7;
    private static final String[] units = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"};
    private static final String[] teens = new String[]{"ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
    private static final String[] tens = new String[]{"", "", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};
    private static final Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-ORX]");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("MM/dd HH:mm:ss");

    @Nullable
    public static String stripColor(@Nullable String input) {
        return input == null ? null : STRIP_COLOR_PATTERN.matcher(input).replaceAll("");
    }

    public static int toInt(String input) {
        int num;
        try {
            num = Integer.parseInt(input);
        }
        catch (NumberFormatException ignored) {
            num = 1;
        }
        return num;
    }

    public static String chainDebugs(List<Debug<?>> debugList) {
        boolean isValid = debugList.stream().anyMatch(FormatUtils::isValidDebug);
        if (isValid) {
            return debugList.stream().filter(FormatUtils::isValidDebug).map(debug -> debug.getName() + ": " + debug.getInfo()).collect(Collectors.joining(", "));
        }
        return "";
    }

    public static int sumValuesInHashMap(HashMap<PacketTypeCommon, Integer> map) {
        int sum = 0;
        for (Integer value : map.values()) {
            sum += value.intValue();
        }
        return sum;
    }

    private static boolean isValidDebug(Debug<?> debug) {
        return !debug.getName().isEmpty() && !String.valueOf(debug.getInfo()).isEmpty();
    }

    public static double calculateResult(double x) {
        return x / 5.0E7;
    }

    public static String shortenString(String input) {
        if (input.length() > 50) {
            return input.substring(0, 50);
        }
        return input;
    }

    public static boolean detectCharacterSpam(String input, int threshold) {
        if (input == null || input.isEmpty()) {
            return false;
        }
        int count = 1;
        char previousChar = input.charAt(0);
        for (int i = 1; i < input.length(); ++i) {
            char currentChar = input.charAt(i);
            if (currentChar == previousChar) {
                if (++count <= threshold) continue;
                return true;
            }
            count = 1;
            previousChar = currentChar;
        }
        return false;
    }

    public static boolean checkDoublePrecision(double number) {
        BigDecimal bd = BigDecimal.valueOf(number);
        int precision = bd.scale();
        return precision > 3;
    }

    public static <K, V> String mapToString(Map<K, V> map) {
        StringJoiner sj = new StringJoiner(", ", "{", "}");
        for (Map.Entry<K, V> entry : map.entrySet()) {
            sj.add(entry.getKey() + "=" + entry.getValue());
        }
        return sj.toString();
    }

    public static int countOccurrences(String input, String subString) {
        Objects.requireNonNull(input, "Input string must not be null");
        Objects.requireNonNull(subString, "Substring must not be null");
        if (subString.isEmpty()) {
            return 0;
        }
        int count = 0;
        int index = 0;
        while ((index = input.indexOf(subString, index)) != -1) {
            ++count;
            index += subString.length();
        }
        return count;
    }

    public static String numberToText(int number) {
        if (number < 0 || number > 100) {
            return "Number out of range";
        }
        if (number < 10) {
            return units[number];
        }
        if (number < 20) {
            return teens[number - 10];
        }
        if (number == 100) {
            return "one hundred";
        }
        int tenPlace = number / 10;
        int unitPlace = number % 10;
        if (unitPlace == 0) {
            return tens[tenPlace];
        }
        return tens[tenPlace] + "-" + units[unitPlace];
    }

    public static int convertMillisToTicks(long millis) {
        return (int)(millis * 20L / 1000L);
    }

    public static String formatTimestamp(long timestamp) {
        LocalDateTime dateTime = Instant.ofEpochMilli(timestamp).atZone(ZoneId.systemDefault()).toLocalDateTime();
        return DATE_TIME_FORMATTER.format(dateTime);
    }

    @Generated
    private FormatUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

