/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.utilities.attributes;

import lombok.Generated;

public enum AttributeMapper {
    Armor("generic.armor", 30.0, 0.0),
    ArmorTough("generic.armorToughness", 20.0, 0.0),
    AttackDamage("generic.attackDamage", 2.048, 0.0),
    AttackKnockback("generic.attackKnockback", 5.0, 0.0),
    AttackSpeed("generic.attackSpeed", 1.024, 0.0),
    FlyingSpeed("generic.flyingSpeed", 1.024, 0.0),
    HoseJumpStrength("horse.jumpStrength", 2.0, 0.0),
    JumpStrength("generic.jumpStrength", 32.0, 0.0),
    PlayerBlockInteraction("player.blockInteractionRange", 64.0, 0.0),
    PlayerEntityRange("player.entityInteractionRange", 64.0, 0.0),
    PlayerBlockBreak("player.blockBreakSpeed", 1024.0, 0.0),
    KnockbackResistance("generic.knockbackResistance", 1.0, 0.0),
    Luck("generic.luck", 1.024, -1.024),
    Gravity("generic.gravity", 1.0, -1.0),
    FallDistance("generic.safeFallDistance", 1.024, -1.024),
    FallDamageMultiplier("generic.fallDamageMultiplier", 100.0, 0.0),
    MaxHealth("generic.maxHealth", 1.0, -1.0),
    MaxAbsorption("generic.maxAbsorption", 2.048, 0.0),
    Scale("generic.scale", 16.0, 0.0625),
    StepHeight("generic.stepHeight", 10.0, 0.0),
    FollowRange("generic.followRange", 2.048, 0.0),
    MovementSpeed("generic.movementSpeed", 1.024, 0.0),
    SpawnReinforcements("zombie.spawnReinforcements", 1.0, 0.0);

    private final String key;
    private final double max;
    private final double min;

    private AttributeMapper(String key, double max, double min) {
        this.key = key;
        this.max = max;
        this.min = min;
    }

    public static AttributeMapper getAttributeMapper(String key) {
        key = key.toLowerCase().replace("minecraft:", "");
        for (AttributeMapper value : AttributeMapper.values()) {
            String valueKey = value.getKey().toLowerCase().replace("_", "");
            if (!valueKey.equalsIgnoreCase(key)) continue;
            return value;
        }
        return null;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public double getMax() {
        return this.max;
    }

    @Generated
    public double getMin() {
        return this.min;
    }
}

