/*
 * Decompiled with CFR 0.152.
 */
package de.feelix.sierra.utilities.pagination;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class Pagination<T> {
    private final List<T> entries;
    private final int itemsPerPage;

    public Pagination(List<T> entries, int itemsPerPage) {
        this.entries = entries;
        this.itemsPerPage = itemsPerPage;
    }

    public List<T> itemsForPage(int requestedPage) {
        this.validatePageNumber(requestedPage);
        if (this.entries.isEmpty()) {
            return new ArrayList();
        }
        int startIndex = this.calculateStartIndex(requestedPage);
        int endIndex = this.calculateEndIndex(startIndex);
        return this.entries.subList(startIndex, endIndex);
    }

    private int calculateStartIndex(int page) {
        return (page - 1) * this.itemsPerPage;
    }

    private int calculateEndIndex(int startIndex) {
        return Math.min(startIndex + this.itemsPerPage, this.entries.size());
    }

    private void validatePageNumber(int page) {
        if (page < 1) {
            throw new IllegalArgumentException("Parameter page must be greater than 1.");
        }
    }

    public int totalPages() {
        return (int)Math.ceil((double)this.entries.size() / (double)this.itemsPerPage);
    }

    @Generated
    public List<T> getEntries() {
        return this.entries;
    }

    @Generated
    public int getItemsPerPage() {
        return this.itemsPerPage;
    }
}

