/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.google.common.collect;

import java.util.Queue;
import net.square.sierra.google.common.annotations.GwtCompatible;
import net.square.sierra.google.common.base.Preconditions;
import net.square.sierra.google.common.collect.AbstractIterator;
import net.square.sierra.google.common.collect.ElementTypesAreNonnullByDefault;
import net.square.sierra.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class ConsumingQueueIterator<T>
extends AbstractIterator<T> {
    private final Queue<T> queue;

    ConsumingQueueIterator(Queue<T> queue) {
        this.queue = Preconditions.checkNotNull(queue);
    }

    @Override
    @CheckForNull
    protected T computeNext() {
        if (this.queue.isEmpty()) {
            return this.endOfData();
        }
        return this.queue.remove();
    }
}

