/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.google.common.collect;

import java.util.Collection;
import java.util.Set;
import net.square.sierra.google.common.annotations.GwtCompatible;
import net.square.sierra.google.common.base.Preconditions;
import net.square.sierra.google.common.collect.ElementTypesAreNonnullByDefault;
import net.square.sierra.google.common.collect.ForwardingCollection;
import net.square.sierra.google.common.collect.Sets;
import net.square.sierra.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ForwardingSet<E>
extends ForwardingCollection<E>
implements Set<E> {
    protected ForwardingSet() {
    }

    @Override
    protected abstract Set<E> delegate();

    @Override
    public boolean equals(@CheckForNull Object object) {
        return object == this || this.delegate().equals(object);
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    @Override
    protected boolean standardRemoveAll(Collection<?> collection) {
        return Sets.removeAllImpl(this, Preconditions.checkNotNull(collection));
    }

    protected boolean standardEquals(@CheckForNull Object object) {
        return Sets.equalsImpl(this, object);
    }

    protected int standardHashCode() {
        return Sets.hashCodeImpl(this);
    }
}

