/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.google.common.collect;

import java.util.Set;
import net.square.sierra.google.common.annotations.GwtCompatible;
import net.square.sierra.google.common.annotations.GwtIncompatible;
import net.square.sierra.google.common.annotations.J2ktIncompatible;
import net.square.sierra.google.common.collect.ElementTypesAreNonnullByDefault;
import net.square.sierra.google.common.collect.ImmutableList;
import net.square.sierra.google.common.collect.IndexedImmutableSet;
import net.square.sierra.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class JdkBackedImmutableSet<E>
extends IndexedImmutableSet<E> {
    private final Set<?> delegate;
    private final ImmutableList<E> delegateList;

    JdkBackedImmutableSet(Set<?> delegate, ImmutableList<E> delegateList) {
        this.delegate = delegate;
        this.delegateList = delegateList;
    }

    @Override
    E get(int index) {
        return this.delegateList.get(index);
    }

    @Override
    public boolean contains(@CheckForNull Object object) {
        return this.delegate.contains(object);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int size() {
        return this.delegateList.size();
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

